/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.io.parser;

import com.vicious.persist.except.ParserException;
import com.vicious.persist.io.parser.TokenView;
import com.vicious.persist.io.parser.enums.CommentType;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface IParser {
    public static final String newLines = "\n\r";

    default public Map<String, Object> mappify(InputStream inputStream) {
        return this.mappify(new TokenView(inputStream));
    }

    default public List<Object> listify(InputStream inputStream) {
        return this.listify(new TokenView(inputStream));
    }

    public Map<String, Object> mappify(TokenView var1);

    public List<Object> listify(TokenView var1);

    public TokenView getTokenView();

    default public char getLastToken() {
        return this.getTokenView().getLastToken();
    }

    default public char getCurrentToken() {
        return this.getTokenView().getCurrentToken();
    }

    default public char getNextToken() {
        return this.getTokenView().getNextToken();
    }

    public CommentType getCommentState();

    public void setCommentState(CommentType var1);

    default public CommentType getCommentType() {
        if (this.getCurrentToken() == '/') {
            if (this.getNextToken() == '*') {
                return CommentType.BLOCK;
            }
            if (this.getNextToken() == '/') {
                return CommentType.SINGLE_LINE;
            }
        }
        return CommentType.NONE;
    }

    default public boolean isCommentEnd(CommentType type) {
        if (type == CommentType.NONE) {
            return false;
        }
        if (type == CommentType.SINGLE_LINE) {
            return this.isNewline(this.getCurrentToken());
        }
        return this.getCurrentToken() == '/' && this.getLastToken() == '*';
    }

    default public boolean isNewline(char character) {
        return newLines.indexOf(character) > -1;
    }

    default public boolean inComment() {
        return this.getCommentState() != CommentType.NONE;
    }

    default public void updateCommentState() {
        if (this.getCommentState() == CommentType.NONE) {
            this.setCommentState(this.getCommentType());
        } else if (this.getCommentState() != CommentType.NONE) {
            if (this.getCommentType() == CommentType.BLOCK) {
                this.setCommentState(CommentType.BLOCK);
            } else if (this.isCommentEnd(this.getCommentState())) {
                if (this.getCommentState() == CommentType.BLOCK) {
                    try {
                        this.getTokenView().read();
                    }
                    catch (IOException e) {
                        throw new ParserException("Failed to skip block comment end", e);
                    }
                }
                this.setCommentState(CommentType.NONE);
            }
        }
    }

    default public boolean notEscaped() {
        return this.getLastToken() != '\\';
    }
}

