/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.mappify;

import com.vicious.persist.mappify.reflect.ClassData;
import com.vicious.persist.mappify.reflect.FieldData;
import com.vicious.persist.mappify.registry.Reserved;
import com.vicious.persist.mappify.registry.Stringify;
import com.vicious.persist.shortcuts.NotationFormat;
import com.vicious.persist.util.StringTree;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class Context {
    public final boolean isStatic;
    public final Class<?> type;
    public final boolean isEnum;
    public final boolean isArray;
    public final Object source;
    public final ClassData data;

    protected Context(Object source) {
        this.isStatic = source instanceof Class;
        this.isEnum = source instanceof Enum;
        this.isArray = source instanceof Array;
        this.type = this.isEnum ? ((Enum)source).getDeclaringClass() : (this.isStatic ? (Class<?>)source : source.getClass());
        this.source = source;
        this.data = ClassData.getClassData(this.type);
    }

    public static Context of(Object source) {
        return new Context(source);
    }

    public Class<?> getType() {
        return this.type;
    }

    public void forEach(Consumer<FieldData<?>> consumer) {
        this.data.forEach(this.isStatic, consumer);
    }

    public boolean hasMappifiableTraits() {
        return this.data.hasTraitsInContext(this.isStatic);
    }

    public void whenPresent(String key, Consumer<FieldData<?>> consumer) {
        this.data.whenPresent(key, this.isStatic, consumer);
    }

    public boolean hasMappifiableTraits(boolean isStatic) {
        return this.data.hasTraitsInContext(isStatic);
    }

    public String getPersistentPath() {
        return this.data.getPersistentPath(this);
    }

    public NotationFormat getPersistentPathFormat() {
        return this.data.getPersistentPathFormat(this);
    }

    public boolean getPersistentPathMigrateMode() {
        return this.data.getPersistentPathMigrateMode(this);
    }

    public boolean hasTransformations() {
        return this.data.hasTransformations(this.isStatic);
    }

    public void transform(Map<Object, Object> map) {
        if (map.containsKey(Reserved.TRANSFORMER_VER) && map.get(Reserved.TRANSFORMER_VER) instanceof Number && this.data.getTransformerVer() == ((Number)map.get(Reserved.TRANSFORMER_VER)).intValue()) {
            return;
        }
        this.transform(map, map, this.data.getTransformations(this.isStatic), 0, "");
    }

    private void transform(Map<Object, Object> rootMap, Map<Object, Object> map, StringTree<String> tree, int depth, String path) {
        int treeDepth = tree.depth();
        for (Object o : new ArrayList<Object>(map.keySet())) {
            String str = Stringify.stringify(o);
            String pth = path + str;
            String replacement = tree.get(pth);
            if (replacement != null) {
                Object val = map.remove(str);
                String[] dest = replacement.split("/");
                Map sub = rootMap;
                for (int i = 0; i < dest.length - 1; ++i) {
                    sub = (Map)sub.computeIfAbsent((Object)dest[i], k -> new HashMap());
                }
                sub.put(dest[dest.length - 1], val);
                continue;
            }
            if (depth + 1 >= treeDepth || !(map.get(str) instanceof Map) || !tree.containsNode(pth)) continue;
            this.transform(rootMap, (Map)map.get(str), tree, depth + 1, pth + "/");
        }
    }

    public int getTransformerVer() {
        return this.data.getTransformerVer();
    }

    public FieldData<?> getField(String targetField) {
        return this.data.getField(targetField);
    }
}

