/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.shortcuts;

import com.vicious.persist.Persist;
import com.vicious.persist.shortcuts.NotationFormat;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;

public class Migrator {
    public static boolean migrate(NotationFormat format, String relativePath) {
        try {
            String pathFileName = Paths.get(relativePath, new String[0]).getFileName().toString();
            String filenameWithoutExtension = pathFileName.substring(0, pathFileName.lastIndexOf(46));
            File directory = new File(relativePath).getParentFile();
            File[] options = directory.listFiles();
            if (options != null) {
                for (File option : options) {
                    if (!option.getName().startsWith(filenameWithoutExtension)) continue;
                    for (NotationFormat value : NotationFormat.values()) {
                        if (!value.isValidFile(option.getName())) continue;
                        Map<String, Object> map = value.parser.mappify(Files.newInputStream(option.toPath(), new OpenOption[0]));
                        option.delete();
                        format.writer.write(map, Files.newOutputStream(new File(relativePath).toPath(), new OpenOption[0]));
                        return true;
                    }
                }
            }
        }
        catch (IOException e) {
            Persist.logger.warning("Could not migrate file");
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

