/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.util;

import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringTree<T>
implements Map<String, T> {
    private final Node<T> root = new Node<Object>(null, false);
    private int size = 0;
    private int depth = 0;

    @Override
    public int size() {
        return this.size;
    }

    public int depth() {
        return this.depth;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String[] path = ((String)key).split("/");
        Node current = this.root;
        for (String s : path) {
            if ((current = (Node)current.get(s)) != null) continue;
            return false;
        }
        return current.isSet;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(this.root, value);
    }

    private boolean containsValue(Node<T> current, Object value) {
        for (Node node : current.values()) {
            if (node.value != value && !this.containsValue(node, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String[] path = ((String)key).split("/");
        Node current = this.root;
        for (String s : path) {
            if ((current = (Node)current.get(s)) != null) continue;
            return null;
        }
        return current.value;
    }

    @Override
    @Nullable
    public T put(String key, T value) {
        String[] path = key.split("/");
        Node current = this.root;
        for (String s : path) {
            current = current.computeIfAbsent(s, k -> new Node<Object>(null, false));
        }
        Object pre = current.value;
        current.value = value;
        current.isSet = true;
        this.recalc();
        return pre;
    }

    private void recalc() {
        int[] v = this.recalc(this.root);
        this.size = v[0];
        this.depth = v[1];
    }

    private int[] recalc(Node<T> current) {
        int k = current.isSet ? 1 : 0;
        int v = 0;
        for (Node node : current.values()) {
            int[] x = this.recalc(node);
            k += x[0];
            v = Math.max(v, x[1]);
        }
        return new int[]{k, v + (current.isEmpty() ? 0 : 1)};
    }

    @Override
    public T remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String[] path = ((String)key).split("/");
        Node current = this.root;
        for (String s : path) {
            if ((current = (Node)current.get(s)) != null) continue;
            return null;
        }
        Object pre = current.value;
        current.value = null;
        current.isSet = false;
        this.prune(this.root);
        this.recalc();
        return pre;
    }

    private boolean prune(Node<T> current) {
        Iterator iterator = current.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry node = iterator.next();
            if (!this.prune((Node)node.getValue())) continue;
            iterator.remove();
        }
        return current.isEmpty() && !current.isSet;
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends T> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.root.clear();
        this.size = 0;
        this.depth = 0;
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.keySet(keys, this.root, "");
        return keys;
    }

    private void keySet(Set<String> set, Node<T> current, String str) {
        for (String s : current.keySet()) {
            Node node = (Node)current.get(s);
            String path = str + s;
            if (node.isSet) {
                set.add(path);
            }
            this.keySet(set, node, path + "/");
        }
    }

    @Override
    @NotNull
    public Collection<T> values() {
        ArrayList values = new ArrayList();
        this.values(values, this.root);
        return values;
    }

    private void values(Collection<T> collection, Node<T> current) {
        if (current.isSet) {
            collection.add(current.value);
        }
        for (Node node : current.values()) {
            this.values(collection, node);
        }
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, T>> entrySet() {
        HashSet<Map.Entry<String, T>> set = new HashSet<Map.Entry<String, T>>();
        this.entrySet(set, this.root, "");
        return set;
    }

    private void entrySet(Set<Map.Entry<String, T>> set, Node<T> current, String str) {
        for (String s : current.keySet()) {
            Node node = (Node)current.get(s);
            String path = str + s;
            if (node.isSet) {
                set.add(new AbstractMap.SimpleImmutableEntry((CallSite)((Object)path), node.value));
            }
            this.entrySet(set, node, path + "/");
        }
    }

    public boolean containsNode(String key) {
        if (!(key instanceof String)) {
            return false;
        }
        String[] path = key.split("/");
        Node current = this.root;
        for (String s : path) {
            if ((current = (Node)current.get(s)) != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Iterator<Map.Entry<String, T>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<String, T> e = i.next();
            String key = e.getKey();
            T value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private static class Node<T>
    extends HashMap<String, Node<T>> {
        private boolean isSet = false;
        @Nullable
        private T value;

        private Node(T value, boolean set) {
            this.value = value;
            this.isSet = set;
        }

        @Override
        public void clear() {
            for (Node tNode : this.values()) {
                tNode.clear();
            }
            super.clear();
        }
    }
}

