package com.drathonix.loadmychunks.common.block;


import com.mojang.serialization.MapCodec;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityLagometer;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLagometer extends BaseEntityBlock {
    //? if >1.20.3 {
    public static final MapCodec<BlockLagometer> CODEC = m_306223_(BlockLagometer::new);
    @Override
    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return f_303539_;
    }
    //?}
    public static final IntegerProperty LAG = IntegerProperty.m_61631_("lmc_lag",0,15);


    public BlockLagometer(Properties properties) {
        super(properties);
        m_49959_(this.f_49792_.m_61090_().m_61124_(LAG, 0));
    }



    @Override
    public @NotNull RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    //? if <=1.16.5 {
    /*@Nullable
    @Override
    public BlockEntity newBlockEntity(BlockGetter blockGetter) {
        return new BlockEntityLagometer();
    }
    *///?}

    //? if >1.16.5 {
    @Nullable
    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BlockEntityLagometer(blockPos,blockState);
    }
    //?}

    @Override
    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    @Override
    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        if(level instanceof ServerLevel) {
            return (int) (ChunkDataManager.getOrCreateChunkData((ServerLevel)level, blockPos).getTickTimer().getLagFraction()*15.0);
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> arg) {
        arg.m_61104_(LAG);
    }
}