/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.block.blockentity;

import com.drathonix.loadmychunks.common.block.blockentity.BEBase;
import com.drathonix.loadmychunks.common.bridge.IDestroyable;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IHasChunkloader;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityChunkLoader
extends BEBase
implements IDestroyable,
IHasChunkloader {
    private PlacedChunkLoader chunkLoader;
    private UUID owner = Util.f_137441_;

    public BlockEntityChunkLoader(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)LMCContent.chunkLoaderBlockEntity.get(), blockPos, blockState);
    }

    @Override
    public PlacedChunkLoader loadMyChunks$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    protected void read(CompoundTag tag) {
        super.read(tag);
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
    }

    @Override
    protected void write(CompoundTag tag) {
        super.write(tag);
        if (tag.m_128441_("owner")) {
            this.setOwner(tag.m_128342_("owner"));
        }
    }

    @Override
    public void loadMyChunks$destroy() {
        if (this.f_58857_ instanceof ServerLevel) {
            ChunkDataManager.removeChunkLoader((ServerLevel)this.f_58857_, this.m_58899_(), (IChunkLoader)this.chunkLoader);
        }
    }

    @Override
    public void validate(Level level) {
        MultiversioningHelper.serverLevel(level, sl -> {
            if (this.chunkLoader == null) {
                this.chunkLoader = ChunkDataManager.computeChunkLoaderIfAbsent(sl, this.m_58899_(), PlacedChunkLoader.class, loader -> loader.getPosition().equals((Object)this.m_58899_()), () -> new PlacedChunkLoader(this.m_58899_(), this.owner));
            }
        });
    }

    public void setOwner(UUID uuid) {
        UUID prev = this.owner;
        this.owner = uuid == null ? Util.f_137441_ : uuid;
        MultiversioningHelper.serverLevel(this.f_58857_, sl -> {
            if (this.chunkLoader != null) {
                this.chunkLoader.setOwner(uuid);
                ChunkDataManager.markChunkNotOwnedBy(sl, this.chunkLoader.getChunkPos().m_45588_(), prev);
                ChunkDataManager.markChunkOwnedBy(sl, this.chunkLoader.getChunkPos().m_45588_(), uuid);
            }
        });
    }
}

