/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.control;

import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import java.util.Comparator;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;

public class ChunkForcer {
    public static final int BLOCK_TICKING_LEVEL = 32;
    public static final int ENTITY_TICKING_LEVEL = 31;
    public static final TicketType<ChunkPos> FORCED = TicketType.m_9462_((String)"lmc_forced", Comparator.comparingLong(ChunkPos::m_45588_));
    public static final TicketType<ChunkPos> ENTITY = TicketType.m_9462_((String)"lmc_entity", Comparator.comparingLong(ChunkPos::m_45588_));

    private static synchronized void addTicket(DistanceManager manager, ChunkPos pos, boolean entityTicking) {
        ChunkForcer.removeTicket(manager, pos, !entityTicking);
        manager.m_140792_(entityTicking ? ENTITY : FORCED, pos, entityTicking ? 31 : 32, (Object)pos);
    }

    private static synchronized void removeTicket(DistanceManager manager, ChunkPos pos, boolean entityTicking) {
        manager.m_140823_(entityTicking ? ENTITY : FORCED, pos, entityTicking ? 31 : 32, (Object)pos);
    }

    public static void unforceChunk(ServerLevel level, ChunkPos pos, boolean wasEntityTicking) {
        ChunkForcer.removeTicket(((IChunkMapMixin)level.m_7726_().f_8325_).lmc$getDistanceManager(), pos, wasEntityTicking);
    }

    public static void forceChunk(ServerLevel level, ChunkPos pos, boolean doEntityTicking) {
        ChunkForcer.addTicket(((IChunkMapMixin)level.m_7726_().f_8325_).lmc$getDistanceManager(), pos, doEntityTicking);
    }
}

