/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.extension.ExtensionChunkLoader;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacedExtensionChunkLoader
extends ExtensionChunkLoader<PlacedChunkLoader>
implements IOwnable {
    protected long activityEnd = -1L;

    public PlacedExtensionChunkLoader() {
    }

    public PlacedExtensionChunkLoader(ChunkPos loadedChunk, PlacedChunkLoader host) {
        super(host, loadedChunk);
    }

    @Override
    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag) {
        tag = super.save(tag);
        LongArrayTag hostsTag = new LongArrayTag(new long[0]);
        for (int i = 0; i < this.hosts.length; ++i) {
            hostsTag.add((Object)LongTag.m_128882_((long)((PlacedChunkLoader)this.getHost(i)).getPosition().m_121878_()));
        }
        tag.m_128365_("hosts", (Tag)hostsTag);
        tag.m_128356_("duration", this.activityEnd);
        return tag;
    }

    @Override
    public void load(@NotNull CompoundTag tag, ServerLevel level) throws DoNotAddException {
        long[] hostPoses = tag.m_128467_("host");
        this.hosts = new PlacedChunkLoader[hostPoses.length];
        if (this.hosts.length == 0) {
            throw new DoNotAddException();
        }
        for (int i = 0; i < this.hosts.length; ++i) {
            BlockPos p = BlockPos.m_122022_((long)hostPoses[i]);
            this.hosts[i] = ChunkDataManager.computeChunkLoaderIfAbsent(level, p, PlacedChunkLoader.class, loader -> loader.getPosition().equals((Object)p), () -> new PlacedChunkLoader(p));
        }
        if (tag.m_128441_("duration")) {
            this.activityEnd = tag.m_128454_("duration");
        }
        super.load(tag, level);
    }

    @Override
    @Nullable
    public UUID getOwner() {
        PlacedChunkLoader pcl = (PlacedChunkLoader)this.getPrimaryHostLoader();
        if (pcl != null) {
            return pcl.getOwner();
        }
        return null;
    }

    @Override
    public void setOwner(@NotNull UUID owner) {
    }

    @Override
    public ResourceLocation getTypeId() {
        return LoaderTypeKeys.PLACED_EXTENSION_LOADER;
    }

    @Override
    public ILoadState getActiveState() {
        if (this.hasExceededChunkLimit() || LMCConfig.cost.enabled && this.activityEnd == -1L) {
            return LoadStateRegistry.DISABLED;
        }
        return super.getActiveState();
    }

    @Override
    @NotNull
    public BlockPos getItemSource() {
        return ((PlacedChunkLoader)this.getPrimaryHostLoader()).getItemSource();
    }

    @Override
    public boolean shouldConsumeItems() {
        return this.isHosted() && super.shouldConsumeItems();
    }
}

