package com.drathonix.loadmychunks.common.block.blockentity;


import com.drathonix.loadmychunks.common.block.BlockLagometer;
import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityLagometer extends BEBase implements IInformable {
    private ChunkDataModule cdm;

    //? if <=1.16.5 {
    /*public BlockEntityLagometer() {
        super(LMCContent.lagometerBlockEntity.get());
    }
    *///?}

    @Override
    public void validate(Level level) {
        super.validate(level);
        if(level instanceof ServerLevel) {
            cdm = ChunkDataManager.getOrCreateChunkData((ServerLevel) level, m_58899_());
            cdm.addRecipient(this);
        }
    }

    //? if >1.16.5 {
    public BlockEntityLagometer(BlockPos blockPos, BlockState blockState) {
        super(LMCContent.lagometerBlockEntity.get(), blockPos, blockState);
    }
    //?}

    @Override
    public void lmc$informLagFrac(float frac) {
        if(!m_58901_()) {
            BlockState blockState = m_58900_();
            int prevLag = blockState.m_61143_(BlockLagometer.LAG);
            int currLag = (int) (cdm.getTickTimer().getLagFraction() * 15);
            if (prevLag != currLag) {
                this.f_58857_.m_7731_(this.f_58858_, blockState.m_61124_(BlockLagometer.LAG, currLag), 3);
            }
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if(cdm != null){
            cdm.removeRecipient(this);
        }
    }
}