package com.drathonix.loadmychunks.common.system;


import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.bridge.ILevelChunkMixin;
import com.drathonix.loadmychunks.common.bridge.IServerLevelMixin;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.registry.custom.LoaderTypeRegistry;
import com.drathonix.loadmychunks.common.system.control.*;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.drathonix.loadmychunks.common.util.ProtectedEntityTickList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;

//? if forge {
import net.minecraftforge.entity.PartEntity;
//?}
//? if neoforge {
/*import net.neoforged.neoforge.entity.PartEntity;
*///?}

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ChunkDataModule {
    private final ProtectedEntityTickList entities = new ProtectedEntityTickList();
    private final CombinedTimings chunkTickTimer = new CombinedTimings();
    private Period gracePeriod;
    private Period disabledPeriod;
    public ILoadState defaultLoadState = LoadStateEnum.DISABLED;
    private ILoadState loadState = defaultLoadState;
    private final Set<IChunkLoader> loaders = new HashSet<>();
    private final ChunkPos position;
    //private ILevelChunkMixin chunk;
    private final Set<IInformable> recipients = new HashSet<>();
    private long nextGameTimeCheckTick = -1;

    public ChunkDataModule(ChunkPos position){
        this.position=position;
    }

    public ChunkDataModule(long position){
        this(new ChunkPos(position));
    }

    public void load(CompoundTag tag, ServerLevel level){
        if(tag.m_128441_("grace")){
            gracePeriod = new Period(tag.m_128454_("grace"));
        }
        if(tag.m_128441_("disabled")){
            disabledPeriod = new Period(tag.m_128454_("disabled"));
        }
        if(tag.m_128441_("nextCheck")){
            nextGameTimeCheckTick = tag.m_128454_("nextCheck");
        }
        defaultLoadState = LoadStateRegistry.fromCompound("default",tag,LoadStateRegistry.DISABLED);
        loadState=defaultLoadState;
        ListTag loaders = tag.m_128437_("loaders", 10);
        for (Tag loader : loaders) {
            if(loader instanceof CompoundTag){
                CompoundTag ct = (CompoundTag) loader;
                LoaderTypeRegistry.INSTANCE.m_6612_(ModResource.parse(ct.m_128461_("type_id")))
                .ifPresent(obj->{
                    IChunkLoader loaderInst = obj.create();
                    try {
                        loaderInst.load(ct, level);
                        addLoader(level,loaderInst);
                        //TODO Redo this such that it only runs after a chunk has been added to the chunk map and wont cause a deadlock.
                        /*try {
                            loaderInst.postLoad(level);
                        } catch (DoNotAddException ignored){
                            removeLoader(level,loaderInst);
                        }*/
                        //Delete loaders that explicitly request to not be added to the CDM (likely due to invalid data).
                    } catch (DoNotAddException ignored){}
                });
            }
        }
        if(loadState.shouldLoad()) {
            startGrace();
        }
    }

    public CompoundTag save(){
        CompoundTag tag = new CompoundTag();
        if(gracePeriod != null){
            tag.m_128356_("grace",gracePeriod.getEnd());
        }
        if(disabledPeriod != null){
            tag.m_128356_("disabled",disabledPeriod.getEnd());
        }
        tag.m_128356_("nextCheck",nextGameTimeCheckTick);
        ListTag loaders = new ListTag();
        for (IChunkLoader loader : this.loaders) {
            if(loader.shouldPersist()) {
                CompoundTag data = new CompoundTag();
                data.m_128359_("type_id", loader.getTypeId().toString());
                data = loader.save(data);
                loaders.add(data);
            }
        }
        tag.m_128365_("loaders",loaders);
        defaultLoadState.putCompound("default",tag);
        return tag;
    }

    /**
     * Adds a loader to the chunk data module if it is not already present.
     * @param loader the loader to be added
     * @return whether the chunk's loadstate has changed.
     */
    public boolean addLoader(ServerLevel level, @NotNull IChunkLoader loader){
        loaders.add(loader);
        ILoadState previous = loadState;
        if(onCooldown()){
            loadState = LoadStateEnum.OVERTICKED;
        }
        else{
            loadState = loader.getActiveState().getSuperiorLoadState(loadState);
        }
        nextGameTimeCheckTick=-1;
        if(loader instanceof IOwnable) {}
        return previous != loadState;
    }

    /**
     * Remove a loader from the chunk data module if it is present.
     * @param loader the loader to be removed
     * @return whether the chunk's loadstate has changed.
     */
    public boolean removeLoader(ServerLevel level, @NotNull IChunkLoader loader){
        if(loader.hasExtensions()){
            loader.getExtensionChunkLoaders().recompute(loader.getExtensionClass(),-1, null);
        }
        loaders.remove(loader);
        ILoadState previous = loadState;
        update();
        nextGameTimeCheckTick=-1;
        if(loader instanceof IOwnable){
            if(!getAllOwners().contains(((IOwnable)loader).getOwner())){
                ChunkDataManager.markChunkNotOwnedBy(level,position.m_45588_(),((IOwnable) loader).getOwner());
            }
        }
        return previous != loadState;
    }

    /**
     * Updates the LoadState based on the loaders in the chunk.
     */
    public void update(){
        loadState = defaultLoadState;
        if(!onCooldown()) {
            for (IChunkLoader loader : loaders) {
                loadState = loader.getActiveState().getSuperiorLoadState(loadState);
                if(loadState.blockEntityTickingPower() == LoaderPower.FORCED){
                    break;
                }
            }
        }
        else{
            loadState= LoadStateEnum.OVERTICKED;
            gracePeriod=null;
        }

    }

    public @NotNull CombinedTimings getTickTimer(){
        return chunkTickTimer;
    }

    public boolean isOverticked(){
        return chunkTickTimer.durationExceeds(LMCConfig.msPerChunk);
    }

    public @Nullable Period getGracePeriod(){
        return gracePeriod;
    }

    public @Nullable Period getDisabledPeriod(){
        return disabledPeriod;
    }

    public @NotNull ILoadState getLoadState(){
        return loadState;
    }

    public @NotNull Set<IChunkLoader> getLoaders() {
        return loaders;
    }

    public boolean shouldUseTimings() {
        return !recipients.isEmpty() || shouldApplyTimings();
    }

    public boolean shouldApplyTimings(){
        return loadState.blockEntityTickingPower().isManaged() && !inGrace();
    }

    public boolean isPermaLoaded(){
        return loadState.shouldLoad() && loadState.permanent();
    }

    public void startGrace(){
        gracePeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.reloadGracePeriod));
    }

    public void startShutoff(){
        loadState = LoadStateEnum.OVERTICKED;
        disabledPeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.delayBeforeReload));
    }

    public boolean onCooldown() {
        return disabledPeriod != null && !disabledPeriod.hasEnded();
    }

    public boolean inGrace() {
        return gracePeriod != null && !gracePeriod.hasEnded();
    }

    public @NotNull ChunkPos getPosition(){
        return position;
    }

    public boolean containsOwnedLoader(@NotNull UUID uuid) {
        for (IChunkLoader loader : loaders) {
            if(loader instanceof IOwnable && uuid.equals(((IOwnable)loader).getOwner())){
               return true;
            }
        }
        return false;
    }

    public void addRecipient(IInformable informable) {
        recipients.add(informable);
    }

    public void removeRecipient(IInformable informable){
        recipients.remove(informable);
    }

    public void inform(){
        Iterator<IInformable> iterator = recipients.iterator();
        float frac = chunkTickTimer.getLagFraction();
        while(iterator.hasNext()) {
            IInformable informable = iterator.next();
            informable.lmc$informLagFrac(frac);
            if(informable instanceof BlockEntity){
                if(((BlockEntity) informable).m_58901_()){
                    iterator.remove();
                }
            }
            if(informable instanceof Entity){
                //? if >1.16.5 {
                if(((Entity) informable).m_146902_().m_45588_() != position.m_45588_()){
                    iterator.remove();
                }
                //?}
                //? if <=1.16.5 {
                /*Entity e = (Entity) informable;
                if(new ChunkPos(e.xChunk,e.zChunk).toLong() != position.toLong()){
                    iterator.remove();
                }
                *///?}
            }
        }
    }

    public Set<@NotNull UUID> getPlayerOwners() {
        HashSet<UUID> owners = new HashSet<>();
        for (IChunkLoader loader : loaders) {
            if(loader instanceof IOwnable){
                if(((IOwnable) loader).hasOwner()){
                    owners.add(((IOwnable) loader).getOwner());
                }
            }
        }
        return owners;
    }

    public Set<@Nullable UUID> getAllOwners() {
        HashSet<UUID> owners = new HashSet<>();
        for (IChunkLoader loader : loaders) {
            if(loader instanceof IOwnable){
                owners.add(((IOwnable) loader).getOwner());
            }
        }
        return owners;
    }

    public void clearCooldowns() {
        disabledPeriod=null;
        gracePeriod=null;
    }

    public boolean shouldPersist(){
        return (defaultLoadState != LoadStateEnum.DISABLED) || loadState.permanent() || !loaders.isEmpty();
    }

    @SuppressWarnings("all")
    public long getCooldownTime(){
        return onCooldown() ? getDisabledPeriod().getTimeRemaining() : 0;
    }

    public void updateChunkLoadState(@NotNull ServerLevel level, @NotNull ILoadState previous){
        if(getLoadState().shouldLoad()){
            startGrace();
        }
        getLoadState().apply(level, position.m_45588_(),previous);
    }

    public @Nullable PlacedChunkLoader getChunkLoaderAt(BlockPos blockPos) {
        for (IChunkLoader loader : loaders) {
            if(loader instanceof PlacedChunkLoader && ((PlacedChunkLoader)loader).getPosition().equals(blockPos)){
                return (PlacedChunkLoader) loader;
            }
        }
        return null;
    }

    public void preTick(ServerLevel level) {
        if(LMCConfig.cost.enabled && level.m_46467_() >= nextGameTimeCheckTick){
            boolean doStateUpdateCheck = false;
            for (IChunkLoader loader : loaders) {
                ILoadState pre = loader.getActiveState();
                loader.timingsCheck(level,this,level.m_46467_());
                if(pre != loader.getActiveState()){
                    doStateUpdateCheck=true;
                }
            }
            if(doStateUpdateCheck) {
                consumeLoadState(previous->{
                    update(()->updateChunkLoadState(level,previous));
                });
            }
        }
    }

    public void update(Runnable onChange){
        ILoadState pre = loadState;
        update();
        if(pre != loadState){
            onChange.run();
        }
    }

    public void updateCheckTime(long time) {
        this.nextGameTimeCheckTick = time;
    }

    public void consumeLoadState(Consumer<ILoadState> consumer){
        consumer.accept(loadState);
    }

    // Note: Its assumed that this method is called on when this chunk that is actually entity ticking.
    public void tickEntities(ServerLevel sl, ProfilerFiller profilerfiller){
        boolean applyTimings = shouldApplyTimings();
        boolean useTimings = applyTimings || shouldUseTimings();
        IServerLevelMixin mixin = (IServerLevelMixin) sl;
        if(useTimings){
            getTickTimer().startEntities();
        }
        entities.forEach(entity -> {
            if (!MultiversioningHelper.isRemoved(entity)
                //? if >=1.21.2 {
                /*&& !sl.tickRateManager().isEntityFrozen(entity)
                 *///?}
            ) {
                if (mixin.lmc$shouldDiscardEntity(entity)) {
                    //? if >1.16.5 {
                    entity.m_146870_();
                    //?} else {
                    /*entity.remove();
                     *///?}
                } else {
                    profilerfiller.m_6180_("checkDespawn");
                    entity.m_6043_();
                    profilerfiller.m_7238_();
                    Entity vehicle = entity.m_20202_();
                    if (vehicle != null) {
                        if (!MultiversioningHelper.isRemoved(vehicle) && vehicle.m_20363_(entity)) {
                            return; // this continues the forEach for anyone confused.
                        }
                        entity.m_8127_();
                    }
                    // Anything here will not be a passenger.
                    profilerfiller.m_6180_("tick");
                    // Neoforge/forge specific
                    //? if neoforge || forge {
                    if(!(entity instanceof PartEntity))
                        //?}
                        sl.m_46653_(sl::m_8647_, entity);

                    profilerfiller.m_7238_();

                }
            }
        });
        if(useTimings){
            getTickTimer().endEntities();
        }
    }

    public void lmc$removeEntity(Entity entity){
        entities.remove(entity);
    }
    public void lmc$addEntity(Entity entity){
        entities.add(entity);
    }
}
