/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.config;

import com.drathonix.loadmychunks.common.config.regis.ItemStackRetriever;
import com.drathonix.loadmychunks.common.config.regis.LoadStateRetriever;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.vicious.persist.annotations.PersistentPath;
import com.vicious.persist.annotations.Range;
import com.vicious.persist.annotations.ReplaceKeys;
import com.vicious.persist.annotations.Save;
import com.vicious.persist.shortcuts.NotationFormat;
import com.vicious.persist.shortcuts.PersistShortcuts;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;

@ReplaceKeys(staticReplacements={@ReplaceKeys.Pair(target={"lagometerComputerExposureLevel"}, replacement="cct/lagometerComputerExposureLevel")}, transformerVersion=1)
public class LMCConfig {
    public static LMCConfig instance;
    @PersistentPath(value=NotationFormat.JSON5)
    private static final String path = "config/loadmychunks.json5";
    @Save(description="The maximum time in milliseconds it can take to tick a chunk completely. If this time is exceeded the chunk will be considered 'overticked' and the loader temporarily disables. Note these ranges are super arbitrary, Running with 0 will functionally disable the mod and running at 1000 will only disable chunks if they take an entire second to process (1tps) which is basically gameplay ruining tps lag. The default here is equal to ~2 TPS per loaded chunk max which should be fair for well-designed end game bases.")
    @Range(minimum=1.0, maximum=1000.0)
    public static long msPerChunk;
    @Save(description="The time in seconds an overticked chunk needs to wait before being reloaded by a chunk loader.")
    @Range(minimum=1.0, maximum=3.1536E7)
    public static long delayBeforeReload;
    @Save(description="The time in seconds a reloaded chunk is allowed to exist before chunk tick times are checked.")
    @Range(minimum=1.0, maximum=86400.0)
    public static long reloadGracePeriod;
    @Save(description="The lagometer effectively allows xraying chunks to find bases on chunk lag. On pvp servers I highly recommend setting this to true. On pve servers the lagometer is relatively harmless to player base security. Keep this false.")
    public static boolean lagometerNeedsChunkOwnership;
    @Save
    public static boolean useDebugLogging;
    @Save(description="Maximum number of times a chunk loader's range can be extended.")
    @Range(minimum=0.0, maximum=10.0)
    public static int maximumRangeExtensions;
    @Save(description="Controls the default level for placed load my chunks chunk loaders. Set to \"loadmychunks:ticking\" for managed forced ticking, \"loadmychunks:entity_ticking\" for managed entity ticking, \"loadmychunks:permanent\" for unmanaged ticking, \"loadmychunks:permanent_entity_ticking\" for unmanaged entity ticking.")
    public static LoadStateRetriever placedChunkLoaderDefaultLevel;
    @Save(description="When true, no mod items or blocks will be registered, allowing clients without the mod to be able to connect. This is intended for servers that merely want to run the LMC chunk loading engine. Must restart the game to enable!")
    public static boolean zeroContent;
    @Save(description="Configures chunk loader item consumption")
    public static Cost cost;
    @Save(description="Allows limiting number of loaded chunks.")
    public static Limit limitSettings;
    @Save(description="Integration settings for CC:Tweaked")
    public static CCTIntegration cct;

    public static void init() {
        PersistShortcuts.init(LMCConfig.class);
    }

    public static boolean isLagometerAllowedOnTurtle() {
        return LMCConfig.cct.lagometerComputerExposureLevel == 2;
    }

    public static boolean isLagometerAllowedOnComputer() {
        return LMCConfig.cct.lagometerComputerExposureLevel >= 1;
    }

    public static void reload() {
        PersistShortcuts.readFromFile(LMCConfig.class);
        LMCConfig.postReload();
    }

    public static void postReload() {
        ChunkDataManager.handleConfigReload();
    }

    public static boolean consumeFuel(ServerLevel level, BlockPos invPos) {
        return LMCConfig.consumeFuel(level, invPos, 1);
    }

    public static boolean consumeFuel(ServerLevel level, BlockPos invPos, int multi) {
        BlockEntity above = level.m_7702_(invPos);
        if (above == null) {
            return false;
        }
        if (above instanceof Container) {
            Container container = (Container)above;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!LMCConfig.cost.itemStack.is(stack) || stack.m_41613_() < LMCConfig.cost.itemStack.size * multi) continue;
                stack.m_41774_(LMCConfig.cost.itemStack.size * multi);
                container.m_6836_(i, stack);
                return true;
            }
        }
        return false;
    }

    static {
        msPerChunk = 5L;
        delayBeforeReload = 300L;
        reloadGracePeriod = 5L;
        lagometerNeedsChunkOwnership = false;
        useDebugLogging = false;
        maximumRangeExtensions = 1;
        placedChunkLoaderDefaultLevel = new LoadStateRetriever(LoadStateRegistry.INSTANCE.m_7981_(LoadStateRegistry.TICKING));
        zeroContent = false;
        cost = new Cost();
        limitSettings = new Limit();
        cct = new CCTIntegration();
    }

    public static class CCTIntegration {
        @Save(description="Enables turtle chunk loading.")
        public boolean enableTurtleChunkLoading = true;
        @Save(description="Makes turtles consume items to remain loaded (only applies if cost/enabled is true)")
        public boolean turtlesConsumeItems = true;
        @Save(description="Makes all turtles act as chunk loaders without needing a peripheral. Chunk Loader Peripheral LUA features will still be unavailable without a chunk loader peripheral present. In addition, they will consume items if the feature is enabled.")
        public boolean turtlesChunkLoadWithoutPeripheral = false;
        @Save(description="Makes turtle chunk loaders ignore LMC's lag limit system. Not recommended for public servers.")
        public boolean ignoreTickChecks = false;
        @Save(description="When 2: Usage allowed in all computers. When 1: Usage banned in turtles and pocket computers. When 0: Usage banned in all computers")
        @Range(minimum=0.0, maximum=2.0)
        public int lagometerComputerExposureLevel = 2;
        @Save(description="Controls the default level for turtle chunk loaders. Set to \"loadmychunks:ticking\" for managed forced ticking, \"loadmychunks:entity_ticking\" for managed entity ticking, \"loadmychunks:permanent\" for unmanaged ticking, \"loadmychunks:permanent_entity_ticking\" for unmanaged entity ticking.")
        public LoadStateRetriever turtleChunkLoaderDefaultLevel = new LoadStateRetriever(LoadStateRegistry.INSTANCE.m_7981_(LoadStateRegistry.TICKING));
    }

    public static class Cost {
        @Save(description="Set to true to enable this feature.")
        public boolean enabled = false;
        @Save(description="The time in seconds each item grants per chunk loader.")
        @Range(minimum=1.0)
        public long timeSecondsGained = 14400L;
        @Save(description="Essentially makes loading more expensive if the loader is entity ticking as well when this value is >0 and <1.")
        @Range(minimum=1.0E-13, maximum=1.0)
        public float entityTickingCostFactor = 1.0f;
        @Save(description="Change this to set the itemstack consumed.")
        public ItemStackRetriever itemStack = new ItemStackRetriever(Items.f_42584_.m_7968_());

        public long getDurationFor(ILoadState defaultState) {
            if (defaultState.shouldForceEntities()) {
                return (long)((float)this.timeSecondsGained * this.entityTickingCostFactor);
            }
            return this.timeSecondsGained;
        }
    }

    public static class Limit {
        @Save(description="When enabled players can only have a certain number of concurrently forced chunks")
        public boolean enabledForPlayers = false;
        @Save(description="When enabled, the environment can only have a certain number of concurrently forced chunks. This is specifically included as a safeguard against non-player placed loaders.")
        public boolean enabledForEnvironment = false;
        @Range(minimum=0.0)
        @Save(description="Maximum number of concurrently loaded chunks a player/the environment can have")
        public int limit = 63;

        @Save.Setter(value="enabledForPlayers")
        public void setEnabledForPlayers(boolean val) {
            this.enabledForPlayers = val;
            ChunkDataManager.handleConfigReload();
        }

        @Save.Setter(value="enabledForEnvironment")
        public void setEnabledForEnvironment(boolean val) {
            this.enabledForEnvironment = val;
            ChunkDataManager.handleConfigReload();
        }

        @Save.Setter(value="limit")
        public void setLimit(int val) {
            this.limit = val;
            ChunkDataManager.handleConfigReload();
        }
    }
}

