/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.integ.cct.peripheral;

import com.drathonix.loadmychunks.common.integ.cct.peripheral.AbstractLagometerPeripheral;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.control.LoadStateEnum;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChunkLoaderPeripheral
extends AbstractLagometerPeripheral {
    private static final Set<String> additional = new HashSet<String>();

    @NotNull
    public abstract IChunkLoader getChunkLoader();

    @Override
    public String getType() {
        return "lmc_chunk_loader";
    }

    public Set<String> getAdditionalTypes() {
        return additional;
    }

    public void setActive(boolean active) {
        if (active) {
            this.getChunkLoader().setActiveState(this.getChunkLoader().getDefaultState());
            this.getChunkDataModule().consumeLoadState(previous -> {
                if (this.getChunkDataModule().addLoader(this.getLevel(), this.getChunkLoader())) {
                    this.getChunkDataModule().updateChunkLoadState(this.getLevel(), (ILoadState)previous);
                }
                ChunkDataManager.setDirty(this.getLevel());
            });
        } else {
            this.getChunkLoader().setActiveState(LoadStateEnum.DISABLED);
            this.getChunkDataModule().consumeLoadState(previous -> {
                if (this.getChunkDataModule().removeLoader(this.getLevel(), this.getChunkLoader())) {
                    this.getChunkDataModule().updateChunkLoadState(this.getLevel(), (ILoadState)previous);
                }
            });
            ChunkDataManager.setDirty(this.getLevel());
        }
    }

    @LuaFunction
    public final boolean isActive(ILuaContext context, IComputerAccess access, IArguments arguments) {
        return this.getChunkLoader().getActiveState().shouldLoad();
    }

    @LuaFunction
    public final void setActive(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.setActive(arguments.getBoolean(0));
    }

    @LuaFunction
    public final void activate(ILuaContext context, IComputerAccess access, IArguments arguments) {
        this.setActive(true);
    }

    @LuaFunction
    public final void deactivate(ILuaContext context, IComputerAccess access, IArguments arguments) {
        this.setActive(false);
    }

    @LuaFunction
    public final void toggleActive(ILuaContext context, IComputerAccess access, IArguments arguments) {
        this.setActive(!this.isActive(context, access, arguments));
    }

    public final Optional<GameProfile> getOwnerProfile() {
        if (this.getChunkLoader() instanceof IOwnable) {
            return Optional.ofNullable(((IOwnable)((Object)this.getChunkLoader())).getOwner()).flatMap(owner -> MultiversioningHelper.enforceOptional(this.getLevel().m_7654_().m_129927_().m_11002_(owner)));
        }
        return Optional.empty();
    }

    @LuaFunction
    public final String getOwnerName(ILuaContext context, IComputerAccess access, IArguments arguments) {
        return this.getOwnerProfile().map(GameProfile::getName).orElse(null);
    }

    @LuaFunction
    public final UUID getOwnerUUID(ILuaContext context, IComputerAccess access, IArguments arguments) {
        return this.getOwnerProfile().map(GameProfile::getId).orElse(null);
    }

    @LuaFunction
    public final boolean shouldLoad(ILuaContext context, IComputerAccess access, IArguments arguments) {
        return this.getChunkLoader().getActiveState().shouldLoad();
    }

    @LuaFunction
    public final boolean shouldEntityTick(ILuaContext context, IComputerAccess access, IArguments arguments) {
        return this.getChunkLoader().getActiveState().shouldForceEntities();
    }

    static {
        additional.add("lmc_lagometer");
    }
}

