/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.integ.cct.peripheral;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLagometerPeripheral
implements IPeripheral {
    @NotNull
    public abstract ChunkDataModule getChunkDataModule();

    public String getType() {
        return "lmc_lagometer";
    }

    @NotNull
    protected abstract ServerLevel getLevel();

    @NotNull
    protected abstract BlockPos getPosition();

    @LuaFunction
    public final long getChunkLastTickDuration(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().getTickTimer().getDuration();
    }

    @LuaFunction
    public final long getChunkTickDurationLimit(ILuaContext context, IComputerAccess access, IArguments arguments) {
        return LMCConfig.msPerChunk;
    }

    @LuaFunction
    public final long getChunkLastTickRatio(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkLastTickDuration(context, access, arguments) / LMCConfig.msPerChunk;
    }

    @LuaFunction
    public final long getChunkCooldownTime(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().getCooldownTime();
    }

    @LuaFunction
    public final boolean isChunkOnCooldown(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().onCooldown();
    }

    @LuaFunction
    public final boolean isChunkForced(ILuaContext context, IComputerAccess access, IArguments arguments) throws LuaException {
        this.checkPerm(access);
        return this.getChunkDataModule().getLoadState().shouldLoad();
    }

    public void checkPerm(IComputerAccess access) throws LuaException {
        if (!this.isLagometerPermitted(access)) {
            throw new LuaException("This feature is disabled for this computer type by the server.");
        }
    }

    public boolean isLagometerPermitted(IComputerAccess access) {
        if (access instanceof ITurtleAccess) {
            return LMCConfig.isLagometerAllowedOnTurtle();
        }
        if (access instanceof IPocketAccess) {
            IPocketAccess pa = (IPocketAccess)access;
            if (pa.getEntity() instanceof Player) {
                Player plr = (Player)pa.getEntity();
                return !LMCConfig.lagometerNeedsChunkOwnership || plr.m_20310_(2) || this.getChunkDataModule().containsOwnedLoader(plr.m_20148_());
            }
            return LMCConfig.isLagometerAllowedOnTurtle();
        }
        return LMCConfig.isLagometerAllowedOnComputer();
    }
}

