/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.integ.cct.turtle;

import com.drathonix.loadmychunks.common.integ.cct.bridge.ITurtleBrainMixin;
import com.drathonix.loadmychunks.common.integ.cct.peripheral.AbstractChunkLoaderPeripheral;
import com.drathonix.loadmychunks.common.integ.cct.turtle.TurtleChunkLoader;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurtleChunkLoaderPeripheral
extends AbstractChunkLoaderPeripheral {
    private final ITurtleBrainMixin turtle;
    public final TurtleSide side;

    public TurtleChunkLoaderPeripheral(ITurtleBrainMixin turtle, TurtleSide side) {
        if (!(turtle.getLevel() instanceof ServerLevel)) {
            throw new IllegalStateException("Turtle chunk loader code cannot be accessed on the clientside.");
        }
        this.turtle = turtle;
        this.side = side;
    }

    @Override
    @NotNull
    public ChunkDataModule getChunkDataModule() {
        return this.turtle.lmc$getChunkDataModule();
    }

    @Override
    @NotNull
    public TurtleChunkLoader getChunkLoader() {
        return this.turtle.lmc$getChunkLoader();
    }

    @Override
    public String getType() {
        return "lmc_chunkloader";
    }

    @Override
    @NotNull
    protected ServerLevel getLevel() {
        return (ServerLevel)this.turtle.getLevel();
    }

    @Override
    @NotNull
    protected BlockPos getPosition() {
        return this.getChunkLoader().getPosition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TurtleChunkLoaderPeripheral that = (TurtleChunkLoaderPeripheral)o;
        return Objects.equals(this.turtle, that.turtle) && this.side == that.side;
    }

    public int hashCode() {
        return Objects.hash(this.turtle, this.side);
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this.equals((Object)other);
    }
}

