/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.IEntitySectionMixin;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntitySection.class})
public abstract class MixinEntitySection<T extends EntityAccess>
implements IEntitySectionMixin {
    @Unique
    private long lmc$longChunk;

    @Shadow
    public abstract Stream<T> m_156845_();

    @Inject(method={"add"}, at={@At(value="TAIL")})
    public void addToChunkTicker(T entityAccess, CallbackInfo ci) {
        try {
            if (entityAccess instanceof Entity) {
                Entity e = (Entity)entityAccess;
                MultiversioningHelper.serverLevel(e, sl -> ChunkDataManager.getOrCreateChunkData(sl, this.lmc$longChunk).lmc$addEntity(e));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    public void removeFromChunkTicker(T entityAccess, CallbackInfoReturnable<Boolean> cir) {
        try {
            if (entityAccess instanceof Entity) {
                Entity e = (Entity)entityAccess;
                MultiversioningHelper.serverLevel(e, sl -> ChunkDataManager.getOrCreateChunkData(sl, this.lmc$longChunk).lmc$removeEntity(e));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Inject(method={"updateChunkStatus"}, at={@At(value="HEAD")})
    public void captureEntitiesAgain(Visibility visibility, CallbackInfoReturnable<Visibility> cir) {
        Optional<T> e = this.m_156845_().findFirst();
        if (e.isPresent() && visibility.m_157691_()) {
            MultiversioningHelper.serverLevel((Entity)e.get(), sl -> {
                ChunkDataModule module = ChunkDataManager.getOrCreateChunkData(sl, this.lmc$longChunk);
                this.m_156845_().forEach(ent -> module.lmc$addEntity((Entity)ent));
            });
        }
    }

    @Override
    public void lmc$setChunkPos(long pos) {
        this.lmc$longChunk = pos;
    }
}

