/*
 * Decompiled with CFR 0.152.
 */
package com.drathonix.loadmychunks.common.registry;

import com.drathonix.loadmychunks.common.LoadMyChunks;
import com.drathonix.loadmychunks.common.block.BlockChunkLoader;
import com.drathonix.loadmychunks.common.block.BlockLagometer;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityChunkLoader;
import com.drathonix.loadmychunks.common.block.blockentity.BlockEntityLagometer;
import com.drathonix.loadmychunks.common.debug.LoadMyChunksDebug;
import com.drathonix.loadmychunks.common.item.ItemChunkLoader;
import com.drathonix.loadmychunks.common.item.ItemChunkLoaderExtension;
import com.drathonix.loadmychunks.common.item.ItemChunkometer;
import com.drathonix.loadmychunks.common.item.ItemHasTooltip;
import com.drathonix.loadmychunks.common.item.ItemLagometer;
import com.drathonix.loadmychunks.common.item.ItemLifeforceBroadcaster;
import com.drathonix.loadmychunks.common.item.LMCProperties;
import com.drathonix.loadmychunks.common.registry.LMCRegistrar;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.drathonix.loadmychunks.unified.BlockEntityTypeBuilder;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class LMCContent {
    public static final Map<String, RegistrySupplier<Block>> chunkLoaderBlockMap = new HashMap<String, RegistrySupplier<Block>>();
    public static RegistrySupplier<BlockEntityType<BlockEntityChunkLoader>> chunkLoaderBlockEntity;
    public static RegistrySupplier<BlockEntityType<BlockEntityLagometer>> lagometerBlockEntity;
    public static RegistrySupplier<Item> itemTickometer;
    public static RegistrySupplier<Item> itemPlayerSpoofer;
    public static RegistrySupplier<Item> itemLifeforceBroadcaster;
    public static RegistrySupplier<Item> itemLocatingCore;
    public static RegistrySupplier<Item> itemDiamondWire;
    public static RegistrySupplier<ItemChunkLoaderExtension> itemExtension;
    public static RegistrySupplier<ItemChunkometer> itemChunkometer;
    public static RegistrySupplier<Block> lagometerBlock;
    public static RegistrySupplier<Block> chunkLoaderBlock;
    public static CreativeTabRegistry.TabSupplier creativeTab;

    public static void init() {
        creativeTab = CreativeTabRegistry.create((ResourceLocation)ModResource.of("creative_tab"), () -> LMCRegistrar.ITEM.get(ModResource.of("chunk_loader")).m_7968_());
        LMCRegistrar.BLOCK.queue(reg -> {
            String[] colors;
            chunkLoaderBlock = LMCContent.registerCLBlockWithItem((DeferredRegister<Block>)reg, "chunk_loader", () -> new BlockChunkLoader(MultiversioningHelper.properties("chunk_loader", 50.0f, 1200.0f)));
            for (String color : colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"}) {
                RegistrySupplier<Block> block = LMCContent.registerCLBlockWithItem((DeferredRegister<Block>)reg, color + "_chunk_loader", () -> new BlockChunkLoader(MultiversioningHelper.properties(color + "_chunk_loader", 50.0f, 1200.0f)));
                chunkLoaderBlockMap.put(color, block);
            }
            chunkLoaderBlockMap.put("", chunkLoaderBlock);
            lagometerBlock = LMCContent.registerBlockWithItem((DeferredRegister<Block>)reg, "lagometer", () -> new BlockLagometer(MultiversioningHelper.properties("lagometer", 3.5f, 4.0f)), ItemLagometer::new);
        });
        LMCRegistrar.ITEM.queue(reg -> {
            itemTickometer = reg.register(ModResource.of("tickometer"), () -> new ItemHasTooltip(new LMCProperties("tickometer"), 1));
            itemPlayerSpoofer = reg.register(ModResource.of("player_spoofer"), () -> new ItemHasTooltip(new LMCProperties("player_spoofer"), 3));
            itemLocatingCore = reg.register(ModResource.of("dimensional_locator"), () -> new ItemHasTooltip(new LMCProperties("dimensional_locator"), 2));
            itemDiamondWire = reg.register(ModResource.of("diamond_wire"), () -> new ItemHasTooltip(new LMCProperties("diamond_wire"), 3));
            itemChunkometer = reg.register(ModResource.of("chunkometer"), () -> new ItemChunkometer(new LMCProperties("chunkometer")));
            itemExtension = reg.register(ModResource.of("chunk_loader_extension"), () -> new ItemChunkLoaderExtension(new LMCProperties("chunk_loader_extension")));
            itemLifeforceBroadcaster = reg.register(ModResource.of("lifeforce_broadcaster"), () -> new ItemLifeforceBroadcaster(new LMCProperties("lifeforce_broadcaster")));
        });
        LMCRegistrar.BLOCK_ENTITY_TYPE.queue(reg -> {
            chunkLoaderBlockEntity = reg.register(ModResource.of("chunk_loader"), () -> BlockEntityTypeBuilder.make(BlockEntityChunkLoader::new, chunkLoaderBlockMap.values()));
            lagometerBlockEntity = reg.register(ModResource.of("lagometer"), () -> BlockEntityTypeBuilder.make(BlockEntityLagometer::new, lagometerBlock));
        });
        if (LoadMyChunks.allowUsingDebugFeatures()) {
            LoadMyChunksDebug.init();
        }
        LMCRegistrar.init();
    }

    public static <T extends Block> RegistrySupplier<T> registerBlockWithItem(DeferredRegister<Block> reg, String name, Supplier<? extends T> supplier) {
        ResourceLocation resource = ModResource.of(name);
        RegistrySupplier block = reg.register(resource, supplier);
        LMCRegistrar.ITEM.queue(ireg -> ireg.register(resource, () -> new BlockItem((Block)block.get(), (Item.Properties)new LMCProperties(name))));
        return block;
    }

    public static <T extends Block> RegistrySupplier<T> registerBlockWithItem(DeferredRegister<Block> reg, String name, Supplier<? extends T> supplier, BiFunction<Block, LMCProperties, BlockItem> function) {
        ResourceLocation resource = ModResource.of(name);
        RegistrySupplier block = reg.register(resource, supplier);
        LMCRegistrar.ITEM.queue(ireg -> ireg.register(resource, () -> (BlockItem)function.apply((Block)block.get(), new LMCProperties(name))));
        return block;
    }

    public static <T extends Block> RegistrySupplier<T> registerCLBlockWithItem(DeferredRegister<Block> reg, String name, Supplier<? extends T> supplier) {
        ResourceLocation resource = ModResource.of(name);
        RegistrySupplier block = reg.register(resource, supplier);
        LMCRegistrar.ITEM.queue(ireg -> ireg.register(resource, () -> new ItemChunkLoader((Block)block.get(), new LMCProperties(name))));
        return block;
    }
}

