/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.mappify.reflect;

import com.vicious.persist.Persist;
import com.vicious.persist.annotations.AltName;
import com.vicious.persist.annotations.Ordering;
import com.vicious.persist.annotations.PersistentPath;
import com.vicious.persist.annotations.ReplaceKeys;
import com.vicious.persist.annotations.Save;
import com.vicious.persist.except.InvalidAnnotationException;
import com.vicious.persist.except.InvalidSavableElementException;
import com.vicious.persist.mappify.Context;
import com.vicious.persist.mappify.reflect.FieldData;
import com.vicious.persist.mappify.reflect.PathFieldData;
import com.vicious.persist.mappify.registry.Initializers;
import com.vicious.persist.mappify.registry.Reserved;
import com.vicious.persist.shortcuts.NotationFormat;
import com.vicious.persist.util.ClassMap;
import com.vicious.persist.util.ReflectionHelper;
import com.vicious.persist.util.StringTree;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassData {
    private static final ClassMap<ClassData> classData = new ClassMap();
    @NotNull
    private final Map<String, FieldData<?>> nameToField = new LinkedHashMap();
    @NotNull
    private final LinkedHashSet<FieldData<?>>[] savableFields = new LinkedHashSet[2];
    @NotNull
    private final PathFieldData<?>[] persistentPath = new PathFieldData[2];
    @NotNull
    private final StringTree<String>[] keyTransformations = new StringTree[2];
    private final int transformerVer;
    @NotNull
    private final LinkedHashSet<FieldData<?>>[] requiredFields = new LinkedHashSet[2];
    @Nullable
    private final Initializers.CustomConstructor<?> initializer;

    /*
     * WARNING - void declaration
     */
    public ClassData(Class<?> c) {
        for (int i = 0; i < 2; ++i) {
            this.savableFields[i] = new LinkedHashSet();
            this.requiredFields[i] = new LinkedHashSet();
        }
        AtomicInteger tSum = new AtomicInteger(0);
        boolean hasInitializer = Initializers.canGenerateInitializerFor(c);
        AtomicBoolean hasPriorityOverrides = new AtomicBoolean(false);
        ReflectionHelper.forEach(c, cls -> {
            FieldData<AccessibleObject> data;
            Object altName;
            Method setter;
            PersistentPath path;
            Save save;
            for (Method method : cls.getDeclaredMethods()) {
                int idx;
                save = method.getAnnotation(Save.class);
                path = method.getAnnotation(PersistentPath.class);
                if (save != null) {
                    String name;
                    String string = name = save.value().isEmpty() ? method.getName() : save.value();
                    if (Modifier.isAbstract(method.getModifiers())) {
                        throw new InvalidSavableElementException("Abstract method " + method.getName() + " in " + String.valueOf(method.getDeclaringClass()) + " @Save(\"" + name + "\"), this is illegal. Maybe you should create a wrapper method instead.");
                    }
                    if (Reserved.isReserved(name)) {
                        throw new InvalidSavableElementException("Method " + method.getName() + " in " + String.valueOf(method.getDeclaringClass()) + " @Save(\"" + name + "\"), has a reserved name! Use a different name.");
                    }
                    if (this.nameToField.containsKey(name)) continue;
                    setter = null;
                    for (Method declaredMethod : cls.getDeclaredMethods()) {
                        Save.Setter saveSetter = declaredMethod.getAnnotation(Save.Setter.class);
                        if (saveSetter == null) continue;
                        if (Modifier.isAbstract(declaredMethod.getModifiers())) {
                            throw new InvalidAnnotationException("Abstract method " + declaredMethod.getName() + " in " + String.valueOf(declaredMethod.getDeclaringClass()) + " @Save.Setter(\"" + saveSetter.value() + "\"), this is illegal. Maybe you should create a wrapper method instead.");
                        }
                        if (!saveSetter.value().equals(name) || !this.staticMatches(method, declaredMethod)) continue;
                        setter = declaredMethod;
                        break;
                    }
                    altName = method.getAnnotation(AltName.class);
                    data = new FieldData<Method>(method, setter, hasInitializer);
                    if (altName != null) {
                        for (String s : altName.value()) {
                            if (this.nameToField.containsKey(s) || Reserved.isReserved(s)) continue;
                            this.nameToField.put(s, data);
                        }
                    }
                    this.nameToField.put(name, data);
                    this.savableFields[this.getStaticIDX(data.isStatic())].add(data);
                    if (data.getPriority() > Integer.MIN_VALUE) {
                        hasPriorityOverrides.set(true);
                    }
                }
                if (path == null) continue;
                int n = idx = Modifier.isStatic(method.getModifiers()) ? 1 : 0;
                if (this.persistentPath[idx] != null) continue;
                if (method.getReturnType() != String.class || method.getParameterCount() != 0) {
                    throw new InvalidAnnotationException("@Persistent path applied to non-String returning parameterless method: " + method.getName() + " in " + String.valueOf(method.getDeclaringClass()));
                }
                this.persistentPath[idx] = new PathFieldData<Method>(method);
            }
            for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                int idx;
                save = ((Field)accessibleObject).getAnnotation(Save.class);
                path = ((Field)accessibleObject).getAnnotation(PersistentPath.class);
                if (save != null) {
                    String name;
                    String string = name = save.value().isEmpty() ? ((Field)accessibleObject).getName() : save.value();
                    if (this.nameToField.containsKey(name)) continue;
                    if (Reserved.isReserved(name)) {
                        throw new InvalidSavableElementException("Field " + ((Field)accessibleObject).getName() + " in " + String.valueOf(((Field)accessibleObject).getDeclaringClass()) + " @Save(\"" + name + "\"), has a reserved name! Use a different name.");
                    }
                    setter = null;
                    for (Method declaredMethod : cls.getDeclaredMethods()) {
                        Save.Setter saveSetter = declaredMethod.getAnnotation(Save.Setter.class);
                        if (saveSetter == null || !saveSetter.value().equals(name) || !this.staticMatches((Member)((Object)accessibleObject), declaredMethod)) continue;
                        setter = declaredMethod;
                        break;
                    }
                    altName = ((Field)accessibleObject).getAnnotation(AltName.class);
                    data = new FieldData<AccessibleObject>(accessibleObject, setter, hasInitializer);
                    if (altName != null) {
                        for (String s : altName.value()) {
                            if (this.nameToField.containsKey(s) || Reserved.isReserved(s)) continue;
                            this.nameToField.put(s, data);
                        }
                    }
                    this.nameToField.put(name, data);
                    this.savableFields[this.getStaticIDX(data.isStatic())].add(data);
                    if (data.getPriority() > Integer.MIN_VALUE) {
                        hasPriorityOverrides.set(true);
                    }
                }
                if (path == null) continue;
                int n = idx = Modifier.isStatic(((Field)accessibleObject).getModifiers()) ? 1 : 0;
                if (this.persistentPath[idx] != null) continue;
                if (((Field)accessibleObject).getType() != String.class) {
                    throw new InvalidSavableElementException("@Persistent path applied to non-String field: " + ((Field)accessibleObject).getName() + " in " + String.valueOf(((Field)accessibleObject).getDeclaringClass()));
                }
                this.persistentPath[idx] = new PathFieldData<AccessibleObject>(accessibleObject);
            }
            ReplaceKeys transformKeys = cls.getAnnotation(ReplaceKeys.class);
            if (transformKeys != null) {
                if (transformKeys.transformerVersion() <= 0) {
                    throw new InvalidAnnotationException("@TransformKeys in " + String.valueOf(cls) + " is invalid. TransformerVer must be greater than 0");
                }
                tSum.getAndAdd(transformKeys.transformerVersion());
                ReplaceKeys.Pair[] transformations = transformKeys.nonStaticReplacements();
                if (transformations.length > 0) {
                    this.keyTransformations[0] = new StringTree();
                    for (ReplaceKeys.Pair pair : transformations) {
                        if (pair.replacement().isEmpty()) {
                            throw new InvalidAnnotationException("@TransformKeys non static key transformation pair in " + String.valueOf(cls) + " is invalid. Replacement value cannot be empty!");
                        }
                        for (String s : pair.target()) {
                            if (this.keyTransformations[0].containsKey(s)) {
                                throw new InvalidAnnotationException("@TransformKeys non static key transformation pair in " + String.valueOf(cls) + " is invalid. Target is already being replaced by another annotation! Check if a super class/interface has @TransformKeys!");
                            }
                            this.keyTransformations[0].put(s, pair.replacement());
                        }
                    }
                }
                if ((transformations = transformKeys.staticReplacements()).length > 0) {
                    this.keyTransformations[1] = new StringTree();
                    for (ReplaceKeys.Pair pair : transformations) {
                        if (pair.replacement().isEmpty()) {
                            throw new InvalidAnnotationException("@TransformKeys static key transformation pair in " + String.valueOf(cls) + " is invalid. Replacement value cannot be empty!");
                        }
                        for (String s : pair.target()) {
                            if (this.keyTransformations[1].containsKey(s)) {
                                throw new InvalidAnnotationException("@TransformKeys static key transformation pair in " + String.valueOf(cls) + " is invalid. Target is already being replaced by another annotation! Check if a super class/interface has @TransformKeys!");
                            }
                            this.keyTransformations[1].put(s, pair.replacement());
                        }
                    }
                }
            }
        });
        for (int i = 0; i < this.savableFields.length; ++i) {
            for (FieldData fieldData : this.savableFields[i]) {
                if (!fieldData.isRequired()) continue;
                this.requiredFields[i].add(fieldData);
            }
        }
        this.initializer = Initializers.tryGenerateCustomReconstructorFor(c, this);
        this.transformerVer = tSum.get();
        Ordering ord = c.getAnnotation(Ordering.class);
        if (ord != null || hasPriorityOverrides.get()) {
            void var7_11;
            LinkedHashSet[] reorderedFields = new LinkedHashSet[2];
            boolean bl = false;
            while (var7_11 < 2) {
                reorderedFields[var7_11] = new LinkedHashSet();
                ++var7_11;
            }
            if (ord != null) {
                for (String s : ord.value()) {
                    FieldData<?> fieldData = this.nameToField.get(s);
                    if (fieldData == null) {
                        Persist.logger.warning("@Ordering in class " + String.valueOf(c) + " has field of name'" + s + "' listed but no @Save field of that name exists in the class hierarchy.");
                        continue;
                    }
                    reorderedFields[this.getStaticIDX(fieldData.isStatic())].add(fieldData);
                }
            }
            PriorityQueue<FieldData> priorityQueue = new PriorityQueue<FieldData>(Comparator.comparing(FieldData::getPriority));
            for (int i = 0; i < 2; ++i) {
                for (LinkedHashSet<FieldData<?>> set : this.savableFields) {
                    priorityQueue.addAll(set);
                }
            }
            ArrayList<FieldData> lst = new ArrayList<FieldData>(priorityQueue);
            for (int i = lst.size() - 1; i >= 0; --i) {
                FieldData fieldData = lst.get(i);
                reorderedFields[this.getStaticIDX(fieldData.isStatic())].add(fieldData);
            }
            System.arraycopy(reorderedFields, 0, this.savableFields, 0, 2);
        }
    }

    @NotNull
    public static ClassData getClassData(@NotNull Object object) {
        if (object instanceof Class) {
            return ClassData.getClassData((Class)object);
        }
        return ClassData.getClassData(object.getClass());
    }

    @NotNull
    public static synchronized ClassData getClassData(Class<?> type) {
        return classData.computeIfAbsent(type, ClassData::new);
    }

    private boolean staticMatches(Member m1, Method declaredMethod) {
        return Modifier.isStatic(m1.getModifiers()) && Modifier.isStatic(declaredMethod.getModifiers()) || !Modifier.isStatic(m1.getModifiers()) && !Modifier.isStatic(declaredMethod.getModifiers());
    }

    public void forEach(boolean isStatic, Consumer<FieldData<?>> accessor) {
        this.savableFields[this.getStaticIDX(isStatic)].forEach(accessor);
    }

    public boolean hasTraitsInContext(boolean isStatic) {
        return !this.savableFields[this.getStaticIDX(isStatic)].isEmpty();
    }

    public void whenPresent(String key, boolean isStatic, Consumer<FieldData<?>> consumer) {
        FieldData<?> field = this.nameToField.get(key);
        if (field != null && field.matchesStaticness(isStatic)) {
            consumer.accept(field);
        }
    }

    public PathFieldData<?> getPersistentPathAnnotation(Context context) {
        int idx;
        int n = idx = context.isStatic ? 1 : 0;
        if (this.persistentPath[idx] != null) {
            return this.persistentPath[idx];
        }
        throw new IllegalArgumentException(String.valueOf(context.getType()) + " is missing an @PersistentPath annotated method or field in the " + (context.isStatic ? "static" : "non-static") + " context!");
    }

    public int getStaticIDX(boolean isStatic) {
        return isStatic ? 1 : 0;
    }

    public String getPersistentPath(Context context) {
        return (String)this.getPersistentPathAnnotation(context).get(context);
    }

    public NotationFormat getPersistentPathFormat(Context context) {
        return this.getPersistentPathAnnotation((Context)context).path.value();
    }

    public boolean getPersistentPathMigrateMode(Context context) {
        return this.getPersistentPathAnnotation((Context)context).path.autoMigrate();
    }

    public boolean hasTransformations(boolean isStatic) {
        return this.keyTransformations[isStatic ? 1 : 0] != null;
    }

    @Nullable
    public StringTree<String> getTransformations(boolean isStatic) {
        return this.keyTransformations[isStatic ? 1 : 0];
    }

    public int getTransformerVer() {
        return this.transformerVer;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.hasTraitsInContext(true)) {
            out.append("Static Context {\n");
            try {
                out.append("\tPath ").append(this.getPersistentPath(Context.of(Class.class))).append("\n");
                out.append("\tFormat ").append((Object)this.getPersistentPathFormat(Context.of(Class.class))).append("\n");
                out.append("\tCan Migrate: ").append(this.getPersistentPathMigrateMode(Context.of(Class.class))).append("\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.append("\tSavable Elements: {\n");
            this.nameToField.forEach((name, field) -> {
                if (field.matchesStaticness(true)) {
                    out.append("\t\t").append((String)name).append(": ").append(field.getType()).append("\n");
                }
            });
            out.append("\t}\n");
            out.append("\tKey Transformations: ").append(this.keyTransformations[1] == null ? "null" : this.keyTransformations[1].toString()).append("\n");
            out.append("}\n");
        }
        if (this.hasTraitsInContext(false)) {
            out.append("Non-Static Context {\n");
            try {
                out.append("\tPath ").append(this.getPersistentPath(Context.of(1))).append("\n");
                out.append("\tFormat ").append((Object)this.getPersistentPathFormat(Context.of(1))).append("\n");
                out.append("\tCan Migrate: ").append(this.getPersistentPathMigrateMode(Context.of(1))).append("\n");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.append("\tSavable Elements: {\n");
            this.nameToField.forEach((name, field) -> {
                if (field.matchesStaticness(false)) {
                    out.append("\t\t").append((String)name).append(": ").append(field.getType()).append("\n");
                }
            });
            out.append("\t}\n");
            out.append("\tKey Transformations: ").append(this.keyTransformations[0] == null ? "null" : this.keyTransformations[0].toString()).append("\n");
            out.append("}\n");
        }
        return out.toString();
    }

    @Nullable
    public FieldData<?> getField(String targetField) {
        return this.nameToField.get(targetField);
    }

    @NotNull
    public Set<String> getKeysOfField(@NotNull FieldData<?> field) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, FieldData<?>> entry : this.nameToField.entrySet()) {
            if (entry.getValue() != field) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public Set<FieldData<?>> copyRequired(Context context) {
        return new HashSet(this.requiredFields[this.getStaticIDX(context.isStatic)]);
    }

    @Nullable
    public Initializers.CustomConstructor<?> getInitializer() {
        return this.initializer;
    }

    public boolean hasInitializer() {
        return this.initializer != null;
    }
}

