/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.mappify.reflect;

import com.vicious.persist.annotations.CleanString;
import com.vicious.persist.annotations.Objectified;
import com.vicious.persist.annotations.Priority;
import com.vicious.persist.annotations.Range;
import com.vicious.persist.annotations.Required;
import com.vicious.persist.annotations.Save;
import com.vicious.persist.annotations.Typing;
import com.vicious.persist.except.InvalidSavableElementException;
import com.vicious.persist.mappify.Context;
import com.vicious.persist.mappify.reflect.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldData<T extends AccessibleObject>
implements TypeInfo {
    public final T getterElement;
    @NotNull
    public final Save saveData;
    @Nullable
    public final Range range;
    @Nullable
    public final CleanString cleanString;
    @Nullable
    public final Typing typing;
    @Nullable
    public final Method setter;
    private final boolean required;
    private final boolean objectified;
    private final int priority;

    public FieldData(T element, @Nullable Method setter, boolean hasInitializer) {
        if (element instanceof Method && setter == null && !hasInitializer) {
            throw new InvalidSavableElementException("Method " + ((Member)((Object)element)).getName() + " in " + String.valueOf(((Member)((Object)element)).getDeclaringClass()) + " annotated with @Save is missing a setter method annotated with @Save.Setter(" + ((Member)((Object)element)).getName() + ")");
        }
        this.getterElement = element;
        this.setter = setter;
        if (setter != null) {
            setter.setAccessible(true);
        }
        ((AccessibleObject)((Object)element)).setAccessible(true);
        this.saveData = ((AccessibleObject)((Object)element)).getAnnotation(Save.class);
        this.range = ((AccessibleObject)((Object)element)).getAnnotation(Range.class);
        this.cleanString = ((AccessibleObject)((Object)element)).getAnnotation(CleanString.class);
        Typing tempTyping = ((AccessibleObject)((Object)element)).getAnnotation(Typing.class);
        if (tempTyping == null) {
            Class<?> type;
            Class<Object> clazz = element instanceof Field ? ((Field)((Object)element)).getType() : (type = element instanceof Method ? ((Method)((Object)element)).getReturnType() : null);
            if (type == null) {
                throw new IllegalStateException("Getter element is somehow not a field or method, this is usually impossible.");
            }
            if (type.isArray()) {
                LinkedList components = new LinkedList();
                while (type.getComponentType() != null) {
                    components.add(type.getComponentType());
                    type = type.getComponentType();
                }
                final Class[] typingArray = components.toArray(new Class[0]);
                tempTyping = new Typing(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return Typing.class;
                    }

                    @Override
                    public Class<?>[] value() {
                        return typingArray;
                    }
                };
            }
        }
        this.typing = tempTyping;
        this.required = ((AccessibleObject)((Object)element)).isAnnotationPresent(Required.class);
        this.objectified = ((AccessibleObject)((Object)element)).isAnnotationPresent(Objectified.class);
        this.priority = ((AccessibleObject)((Object)element)).isAnnotationPresent(Priority.class) ? ((AccessibleObject)((Object)element)).getAnnotation(Priority.class).value() : Integer.MIN_VALUE;
    }

    public boolean matchesStaticness(boolean isStatic) {
        return isStatic && this.isStatic() || !isStatic && !this.isStatic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(((Member)this.getterElement).getModifiers());
    }

    @Nullable
    public Object get(Context context) {
        try {
            if (this.getterElement instanceof Field) {
                return ((Field)this.getterElement).get(context.source);
            }
            if (this.getterElement instanceof Method) {
                return ((Method)this.getterElement).invoke(context.source, new Object[0]);
            }
            throw new IllegalStateException("Impossible state.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access field ", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not invoke field getter method", e);
        }
    }

    public void set(Context context, @Nullable Object value) {
        try {
            if (this.range != null && value instanceof Number) {
                double v = ((Number)value).doubleValue();
                if (v < this.range.minimum()) {
                    v = Math.max(v, this.range.minimum());
                } else if (v > this.range.maximum()) {
                    v = Math.min(v, this.range.maximum());
                }
                if (value instanceof Double) {
                    value = v;
                } else if (value instanceof Float) {
                    value = Float.valueOf((float)v);
                } else if (value instanceof Byte) {
                    value = (byte)v;
                } else if (value instanceof Short) {
                    value = (short)v;
                } else if (value instanceof Integer) {
                    value = (int)v;
                } else if (value instanceof Long) {
                    value = (long)v;
                }
            }
            if (this.cleanString != null && value instanceof String) {
                for (CleanString.Replacement replacement : this.cleanString.replacements()) {
                    value = ((String)value).replaceAll(replacement.target(), replacement.replacement());
                }
                if (((String)value).length() > this.cleanString.maxLength()) {
                    value = ((String)value).substring(0, this.cleanString.maxLength());
                }
            }
            if (this.setter != null) {
                this.setter.invoke(context.source, value);
            } else if (this.getterElement instanceof Field) {
                ((Field)this.getterElement).set(context.source, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access field ", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not invoke field setter method", e);
        }
    }

    public String getName() {
        return this.saveData.value().isEmpty() ? ((Member)this.getterElement).getName() : this.saveData.value();
    }

    public String getFieldName() {
        return ((Member)this.getterElement).getName();
    }

    public boolean objectified() {
        return this.objectified;
    }

    @Override
    public Class<?> getType() {
        if (this.getterElement instanceof Field) {
            return ((Field)this.getterElement).getType();
        }
        if (this.getterElement instanceof Method) {
            return ((Method)this.getterElement).getReturnType();
        }
        throw new IllegalStateException("Impossible state.");
    }

    @Override
    public Class<?>[] getTyping() {
        if (this.typing == null) {
            throw new InvalidSavableElementException("missing @Typing annotation!");
        }
        return this.typing.value();
    }

    public String toString() {
        return "FieldData{, saveData=" + String.valueOf(this.saveData) + ", rangeData=" + String.valueOf(this.range) + ", typing=" + String.valueOf(this.typing) + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FieldData fieldData = (FieldData)object;
        return Objects.equals(this.getterElement, fieldData.getterElement);
    }

    public int hashCode() {
        return Objects.hashCode(this.getterElement);
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getPriority() {
        return this.priority;
    }
}

