/*
 * Decompiled with CFR 0.152.
 */
package com.vicious.persist.shortcuts;

import com.vicious.persist.except.NoSuchSavableElementException;
import com.vicious.persist.io.writer.wrapped.WrappedObjectMap;
import com.vicious.persist.mappify.Context;
import com.vicious.persist.mappify.Mappifier;
import com.vicious.persist.mappify.reflect.FieldData;
import com.vicious.persist.shortcuts.Migrator;
import com.vicious.persist.shortcuts.NotationFormat;
import com.vicious.persist.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistShortcuts {
    public static void saveAsFile(Object obj) {
        Context context = Context.of(obj);
        PersistShortcuts.saveAsFile(context.getPersistentPathFormat(), obj, context.getPersistentPath());
    }

    public static void saveAsFile(NotationFormat format, WrappedObjectMap map, String fileName) {
        try {
            FileUtil.resolve(fileName);
            FileOutputStream fos = new FileOutputStream(fileName);
            format.write(map, fos);
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveAsFile(NotationFormat format, Object obj, String fileName) {
        PersistShortcuts.saveAsFile(format, Mappifier.DEFAULT.mappify(obj), fileName);
    }

    public static void readFromFile(Object obj) {
        Context context = Context.of(obj);
        PersistShortcuts.readFromFile(context.getPersistentPathFormat(), obj, context.getPersistentPath(), false, context.getPersistentPathMigrateMode());
    }

    public static void readFromFile(NotationFormat format, Object obj, String fileName, boolean throwOnNoSuchFile, boolean migrate) {
        try {
            File file = new File(fileName);
            if (file.exists() || migrate && Migrator.migrate(format, fileName)) {
                FileInputStream fis = new FileInputStream(fileName);
                Map<Object, Object> map = format.parse(fis);
                fis.close();
                Mappifier.DEFAULT.unmappify(obj, map);
            } else if (throwOnNoSuchFile) {
                throw new NoSuchFileException(fileName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void init(Object obj) {
        PersistShortcuts.readFromFile(obj);
        PersistShortcuts.saveAsFile(obj);
    }

    public static void set(@NotNull Object target, @Nullable Object value, @NotNull String targetField) {
        Context ctx = Context.of(target);
        FieldData<?> data = ctx.getField(targetField);
        if (data == null) {
            throw new NoSuchSavableElementException(targetField + " is not present in the target object.");
        }
        data.set(ctx, value);
    }
}

