package com.drathonix.loadmychunks.common.block.blockentity;

import com.drathonix.loadmychunks.common.bridge.IDestroyable;
import com.drathonix.loadmychunks.common.registry.LMCContent;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.loaders.IHasChunkloader;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class BlockEntityChunkLoader extends BEBase implements IDestroyable, IHasChunkloader {
    private PlacedChunkLoader chunkLoader;
    private UUID owner = class_156.field_25140;

    //? if <=1.16.5 {
    public BlockEntityChunkLoader() {
        super(LMCContent.chunkLoaderBlockEntity.get());
    }
    //?} else {
    /*public BlockEntityChunkLoader(BlockPos blockPos, BlockState blockState) {
        super(LMCContent.chunkLoaderBlockEntity.get(), blockPos, blockState);
    }
    *///?}

    @Override
    public PlacedChunkLoader loadMyChunks$getChunkLoader() {
        return chunkLoader;
    }

    @Override
    protected void read(class_2487 tag) {
        super.read(tag);
        if(owner != null) {
            tag.method_25927("owner", owner);
        }
    }

    @Override
    protected void write(class_2487 tag) {
        super.write(tag);
        if(tag.method_10545("owner")) {
            setOwner(tag.method_25926("owner"));
        }
    }

    @Override
    public void loadMyChunks$destroy() {
        if(field_11863 instanceof class_3218) {
            ChunkDataManager.removeChunkLoader((class_3218) field_11863,method_11016(),chunkLoader);
        }
    }

    @Override
    public void validate(class_1937 level) {
        MultiversioningHelper.serverLevel(level,sl->{
            if(chunkLoader == null) {
                chunkLoader = ChunkDataManager.computeChunkLoaderIfAbsent(sl,method_11016(),PlacedChunkLoader.class, loader-> loader.getPosition().equals(method_11016()),()-> new PlacedChunkLoader(method_11016(),owner));
            }
        });
    }

    public void setOwner(UUID uuid) {
        UUID prev = this.owner;
        this.owner=uuid == null ? class_156.field_25140 : uuid;
        MultiversioningHelper.serverLevel(field_11863,sl->{
            if(chunkLoader != null){
                this.chunkLoader.setOwner(uuid);
                ChunkDataManager.markChunkNotOwnedBy(sl,chunkLoader.getChunkPos().method_8324(),prev);
                ChunkDataManager.markChunkOwnedBy(sl,chunkLoader.getChunkPos().method_8324(), uuid);
            }
        });
    }
}
