package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import com.drathonix.loadmychunks.common.bridge.IDistanceManagerMixin;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import net.minecraft.class_1255;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2794;
import net.minecraft.class_2823;
import net.minecraft.class_3193;
import net.minecraft.class_32;
import net.minecraft.class_3204;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3485;
import net.minecraft.class_3898;
import net.minecraft.class_3949;
import net.minecraft.class_4076;
import net.minecraft.server.level.*;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Mixin(class_3898.class)
public abstract class MixinChunkMap implements IChunkMapMixin {
    @Shadow @Final private Long2ObjectLinkedOpenHashMap<class_3193> updatingChunkMap;

    //? if >1.16.5 {
    /*@Shadow abstract boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkPos);
    *///?}

    /**
     * method to capture the distance manager instance without using access transformers in 1.16.5 because I HATE them. I HATE THEM SO MUCH!
     */
    @Unique private IDistanceManagerMixin lmc$distanceManager;
    //? if <1.18.2 {
    @Inject(method = "<init>",at = @At(value = "RETURN"))
    public void captureDistMan(class_3218 arg, class_32.class_5143 arg2, DataFixer dataFixer, class_3485 arg3, Executor executor, class_1255 arg4, class_2823 arg5, class_2794 arg6, class_3949 arg7, Supplier supplier, int i, boolean bl, CallbackInfo ci){
    //?} elif <1.19.2 {
    /*@Inject(method = "<init>",at = @At(value = "RETURN"))
    public void captureDistMan(ServerLevel arg, LevelStorageSource.LevelStorageAccess arg2, DataFixer dataFixer, StructureManager arg3, Executor executor, BlockableEventLoop arg4, LightChunkGetter arg5, ChunkGenerator arg6, ChunkProgressListener arg7, ChunkStatusUpdateListener arg8, Supplier supplier, int i, boolean bl, CallbackInfo ci){
    *///?} else {
    /*@Inject(method = "<init>",at = @At(value = "RETURN"))
    public void captureDistMan(ServerLevel serverLevel, LevelStorageSource.LevelStorageAccess levelStorageAccess, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor executor, BlockableEventLoop blockableEventLoop, LightChunkGetter lightChunkGetter, ChunkGenerator chunkGenerator, ChunkProgressListener chunkProgressListener, ChunkStatusUpdateListener chunkStatusUpdateListener, Supplier supplier, int i, boolean bl, CallbackInfo ci){
    *///?}
        for (Field declaredField : this.getClass().getDeclaredFields()) {
            if(IDistanceManagerMixin.class.isAssignableFrom(declaredField.getType())){
                try {
                    declaredField.setAccessible(true);
                    lmc$distanceManager = (IDistanceManagerMixin) declaredField.get(this);
                    return;
                } catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }


    @Shadow @Final private class_3218 level;


    @Override
    public Long2ObjectLinkedOpenHashMap<class_3193> lmc$getUpdatingChunkMap() {
        return updatingChunkMap;
    }

    @Override
    public boolean lmc$playerDistCheck(class_1923 pos) {
        //? if >1.16.5 {
        /*return anyPlayerCloseEnoughForSpawning(pos);
        *///?} else {
        if (!lmc$distanceManager.lmc$hasPlayersNearby(pos.method_8324())) {
            return false;
        } else {
            for (class_3222 serverplayer : this.level.method_8503().method_3760().method_14571()) {
                if (this.lmc$playerIsCloseEnoughForSpawning(serverplayer, pos)) {
                    return true;
                }
            }

            return false;
        }
        //?}
    }

    @Unique
    private boolean lmc$playerIsCloseEnoughForSpawning(class_3222 p_183752_, class_1923 p_183753_) {
        if (p_183752_.method_7325()) {
            return false;
        } else {
            double d0 = lmc$euclideanDistanceSquared(p_183753_, p_183752_);
            return d0 < 16384.0;
        }
    }

    @Unique
    private static double lmc$euclideanDistanceSquared(class_1923 p_140227_, class_1297 p_140228_) {
        double d0 = class_4076.method_18688(p_140227_.field_9181)+8;
        double d1 = class_4076.method_18688(p_140227_.field_9180)+8;
        double d2 = d0 - p_140228_.method_23317();
        double d3 = d1 - p_140228_.method_23321();
        return d2 * d2 + d3 * d3;
    }

    @Override
    public boolean lmc$inEntityTickingRange(long l) {
        return lmc$distanceManager.lmc$inEntityTickingRange(l);
    }

    @Override
    public class_3204 lmc$getDistanceManager() {
        return (class_3204) lmc$distanceManager;
    }
}
