package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import com.drathonix.loadmychunks.common.bridge.ILevelChunkMixin;
import com.drathonix.loadmychunks.common.bridge.ILevelMixin;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3695;

@Mixin(value = class_1937.class,priority = 0)
public abstract class MixinLevel implements ILevelMixin {
    //? if >1.16.5 {
    /*@Shadow @Final protected List<TickingBlockEntity> blockEntityTickers;


    @Shadow public abstract boolean isClientSide();
    @Unique private static final Iterator<TickingBlockEntity> lmc$emptyIter = Collections.emptyIterator();

    //? if <1.21.2 {
    @Shadow public abstract ProfilerFiller getProfiler();
    //?} else {
    /^public ProfilerFiller getProfiler(){
        return Profiler.get();
    }
    ^///?}
    /^*
     * Overrides the default block ticking logic by ticking each chunk's tile entities in groups rather than all TEs individually.
     ^/
    @Redirect(method = "tickBlockEntities",at = @At(value = "INVOKE", target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    public Iterator<TickingBlockEntity> tickChunkWise(List<TickingBlockEntity> instance){
        if(!this.isClientSide()){
            //noinspection resource
            if (loadMyChunks$cast().getChunkSource() instanceof ServerChunkCache scc) {
                Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap = ((IChunkMapMixin) scc.chunkMap).lmc$getUpdatingChunkMap();
                synchronized (updatingChunkMap) {
                    for (ChunkHolder value : updatingChunkMap.values()) {
                        if (value != null && value.getTickingChunk() instanceof ILevelChunkMixin chunk) {
                            if (scc.chunkMap.getDistanceManager().inBlockTickingRange(chunk.loadMyChunks$posAsLong())) {
                                chunk.loadMyChunks$tick();
                            }
                        }
                    }
                }
            }
            return lmc$emptyIter;
        } else {
            return instance.iterator();
        }
    }

    @Override
    public void loadMyChunks$removeTicker(TickingBlockEntity tickingBlockEntity) {
        blockEntityTickers.remove(tickingBlockEntity);
    }

    @Unique
    public Level loadMyChunks$cast(){
        return Level.class.cast(this);
    }
    *///?}

    //TODO: Remove redundancies
    //? if <=1.16.5 {

    @Unique private static final Iterator<class_2586> lmc$emptyIter = Collections.emptyIterator();

    @Shadow public abstract boolean isClientSide();

    @Shadow @Final public List<class_2586> tickableBlockEntities;

    @Shadow @Final public List<class_2586> blockEntityList;

    @Shadow public abstract class_3695 getProfiler();

    /**
     * Overrides the default block ticking logic by ticking each chunk's tile entities in groups rather than all TEs individually.
     *
     * @return An empty list to spoof the original method
     */
    //TODO: investigate if this has significant mod conflicts.
    @Redirect(method = "tickBlockEntities",at = @At(value = "INVOKE",target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    public Iterator<class_2586> tickChunkWise(List<class_2586> instance){
        if(!this.isClientSide()) {
            //noinspection resource
            if (loadMyChunks$cast().method_8398() instanceof class_3215) {
                class_3215 scc = (class_3215) loadMyChunks$cast().method_8398();
                Long2ObjectLinkedOpenHashMap<class_3193> updatingChunkMap = ((IChunkMapMixin) scc.field_17254).lmc$getUpdatingChunkMap();
                for (class_3193 value : updatingChunkMap.values()) {
                    if(value != null) {
                        class_2818 tickingChunk = value.method_16144();
                        if (tickingChunk instanceof ILevelChunkMixin) {
                            if (scc.method_20529(tickingChunk.method_12004().method_8323())) {
                                ((ILevelChunkMixin)tickingChunk).loadMyChunks$tick(getProfiler());
                            }
                        }
                    }
                }
            }
            return lmc$emptyIter;
        }
        else{
            return instance.iterator();
        }
    }

    @Override
    public void loadMyChunks$removeTicker(class_2586 tickingBlockEntity) {
        tickableBlockEntities.remove(tickingBlockEntity);
        blockEntityList.remove(tickingBlockEntity);
    }

    @Unique
    public class_1937 loadMyChunks$cast(){
        return class_1937.class.cast(this);
    }
    //?}
}
