package com.drathonix.loadmychunks.common.mixin;

import com.drathonix.loadmychunks.common.bridge.*;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;

import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.drathonix.loadmychunks.common.util.ProtectedEntityTickList;
import java.util.function.Consumer;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1951;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_3000;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_4548;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

@Mixin(class_2818.class)

public abstract class MixinLevelChunk
    //? if >1.16.5 {
        /*extends MixinChunkAccess
    *///?}
        implements ILevelChunkMixin {
    @Shadow @Final class_1937 level;


    @Override
    public ChunkDataModule loadMyChunks$getDataModule() {
        return loadMyChunks$loadDataModule;
    }

    public ChunkDataModule loadMyChunks$getAndCache(){
        if(this.loadMyChunks$loadDataModule == null) {
            this.loadMyChunks$loadDataModule = ChunkDataManager.getOrCreateChunkData((class_3218) level, loadMyChunks$posAsLong());
        }
        return this.loadMyChunks$loadDataModule;
    }

    @Override
    public long loadMyChunks$posAsLong() {
        return chunkPos.method_8324();
    }

    //? if <1.18.2 {
    @Inject(method = "addEntity",at = @At("TAIL"))
    public void onAdd(class_1297 entity, CallbackInfo ci){
        if(level instanceof class_3218){
            loadMyChunks$getAndCache().lmc$addEntity(entity);
        }
    }
    @Inject(method = "removeEntity(Lnet/minecraft/world/entity/Entity;I)V",at = @At("TAIL"))
    public void onRemove(class_1297 entity, int i, CallbackInfo ci){
        if(level instanceof class_3218){
            loadMyChunks$getAndCache().lmc$removeEntity(entity);
        }
    }
    //?}

    @Unique
    @Override
    public void loadMyChunks$tickEntities(class_3695 profilerfiller) {
        if(level instanceof class_3218) {
            loadMyChunks$loadDataModule.tickEntities((class_3218) level,profilerfiller);
        }
    }


    //? if >1.16.5 {
    /*@Unique
    private final List<TickingBlockEntity> loadMyChunks$queuedTickers = new ArrayList<>();
    @Unique
    private final List<TickingBlockEntity> loadMyChunks$tickers = new ArrayList<>();

    @Shadow @Nullable
    public abstract BlockEntity getBlockEntity(BlockPos arg);

    @Shadow public abstract Level getLevel();

    @Unique private ChunkDataModule loadMyChunks$loadDataModule;

    @Inject(method = "<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/chunk/UpgradeData;Lnet/minecraft/world/ticks/LevelChunkTicks;Lnet/minecraft/world/ticks/LevelChunkTicks;J[Lnet/minecraft/world/level/chunk/LevelChunkSection;Lnet/minecraft/world/level/chunk/LevelChunk$PostLoadProcessor;Lnet/minecraft/world/level/levelgen/blending/BlendingData;)V",at = @At("RETURN"))
    public void setup(Level arg, ChunkPos arg2, UpgradeData arg3, LevelChunkTicks arg4, LevelChunkTicks arg5, long l, LevelChunkSection[] args, LevelChunk.PostLoadProcessor arg6, BlendingData arg7, CallbackInfo ci){
        if(level instanceof ServerLevel sl) {
            loadMyChunks$getAndCache();
        }
    }

    @Override
    public void loadMyChunks$tick() {
        if(level instanceof ServerLevel) {
            loadMyChunks$loadDataModule.preTick((ServerLevel) level);
        }
        boolean applyTimings = loadMyChunks$loadDataModule.shouldApplyTimings() && !level.isClientSide;
        boolean useTimings = applyTimings || (!level.isClientSide && loadMyChunks$loadDataModule.shouldUseTimings());
        Iterator<TickingBlockEntity> iterator = loadMyChunks$queuedTickers.iterator();
        // 1.0.3 Conmod patch
        while(iterator.hasNext()){
            TickingBlockEntity tickingblockentity = iterator.next();
            loadMyChunks$tickers.add(tickingblockentity);
            iterator.remove();
        }
        if(useTimings){
            loadMyChunks$loadDataModule.getTickTimer().startBlockEntities();
        }
        iterator = loadMyChunks$tickers.iterator();
        // patch end
        while(iterator.hasNext()){
            TickingBlockEntity tickingblockentity = iterator.next();
            if (tickingblockentity.isRemoved()) {
                ((ILevelMixin)level).loadMyChunks$removeTicker(tickingblockentity);
                iterator.remove();
            } else {
                tickingblockentity.tick();
            }
        }
        if(useTimings){
            loadMyChunks$loadDataModule.getTickTimer().endBlockEntities();
            loadMyChunks$loadDataModule.inform();
            if(applyTimings && loadMyChunks$loadDataModule.isOverticked()){
                ILoadState prev = loadMyChunks$loadDataModule.getLoadState();
                loadMyChunks$loadDataModule.startShutoff();
                ChunkDataManager.markShutDown((ServerLevel)level,chunkPos,prev);
            }
        }
    }

    // Use inject instead due to conflict with fabric mixins
    @Inject(method = "getBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk$EntityCreationType;)Lnet/minecraft/world/level/block/entity/BlockEntity;",at = @At(value = "INVOKE", target = "Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;",ordinal = 0),
            slice = @Slice(
            from = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/entity/BlockEntity;isRemoved()Z"
            )),
            locals = LocalCapture.CAPTURE_FAILHARD
    )
    public void properlyDestroyTileEntities1(BlockPos blockPos, LevelChunk.EntityCreationType entityCreationType, CallbackInfoReturnable<BlockEntity> cir, BlockEntity blockEntity){
        if(!level.isClientSide){
            if(blockEntity instanceof IDestroyable destroyable){
                destroyable.loadMyChunks$destroy();
            }
        }
    }

    @Redirect(method = "removeBlockEntity",at = @At(value = "INVOKE", target = "Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;",ordinal = 0))
    public Object properlyDestroyTileEntities2(Map<?,?> instance, Object o){
        Object rem = instance.remove(o);
        if(rem instanceof IDestroyable destroyable && !level.isClientSide()){
            destroyable.loadMyChunks$destroy();
        }
        return rem;
    }

    @Inject(method = "clearAllBlockEntities",at = @At("RETURN"))
    public void clearQueues(CallbackInfo ci){
        loadMyChunks$queuedTickers.clear();
        loadMyChunks$tickers.clear();
    }

    //Use lazy typing to avoid needing an AT
    @Redirect(method = "updateBlockEntityTicker",at = @At(value = "INVOKE",target = "Ljava/util/Map;compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"))
    public <K,V> Object addToQueue(Map<K,V> instance, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction){
        //Ensure this will be the first instance
        if(!instance.containsKey(key)){
            Object current = instance.get(key);
            TickingBlockEntity result = (TickingBlockEntity)instance.compute(key, remappingFunction);
            if(result != null) {
                loadMyChunks$queuedTickers.add(result);
            }
            //Account for the new ticker being invalidated (somehow)
            else if(current != null){
                loadMyChunks$tickers.remove(result);
                loadMyChunks$queuedTickers.remove(result);
            }
            return result;
        }
        return remappingFunction.apply(key, instance.get(key));
    }

    *///?}

    //TODO: Remove redundant code. For now I'm just assuming 1.16.5 is too complex to really integrate well (I'm definitely wrong)
    //? if <=1.16.5 {

    @Unique private final List<class_2586> loadMyChunks$queued = new ArrayList<>();
    @Unique private final List<class_2586> loadMyChunks$tickers = new ArrayList<>();

    @Shadow @Nullable
    public abstract class_2586 getBlockEntity(class_2338 arg);

    @Shadow @Final private class_1923 chunkPos;

    @Shadow public abstract class_2680 getBlockState(class_2338 blockPos);

    @Shadow @Nullable public abstract class_2586 getBlockEntity(class_2338 blockPos, class_2818.class_2819 entityCreationType);

    @Unique private ChunkDataModule loadMyChunks$loadDataModule;

    @Inject(method = "<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/chunk/ChunkBiomeContainer;Lnet/minecraft/world/level/chunk/UpgradeData;Lnet/minecraft/world/level/TickList;Lnet/minecraft/world/level/TickList;J[Lnet/minecraft/world/level/chunk/LevelChunkSection;Ljava/util/function/Consumer;)V",at = @At("RETURN"))
    public void setup(class_1937 level, class_1923 chunkPos, class_4548 chunkBiomeContainer, class_2843 upgradeData, class_1951 tickList, class_1951 tickList2, long l, class_2826[] levelChunkSections, Consumer consumer, CallbackInfo ci){
        if(level instanceof class_3218) {
            this.loadMyChunks$loadDataModule = ChunkDataManager.getOrCreateChunkData((class_3218)level,chunkPos);
        }
    }

    @Override
    public void loadMyChunks$tick(class_3695 profilerFiller) {
        if(level instanceof class_3218) {
            loadMyChunks$loadDataModule.preTick((class_3218) level);
        }
        Iterator<class_2586> iterator = loadMyChunks$queued.iterator();
        while(iterator.hasNext()){
            loadMyChunks$tickers.add(iterator.next());
            iterator.remove();
        }

        boolean applyTimings = loadMyChunks$loadDataModule.shouldApplyTimings() && !level.field_9236;
        boolean useTimings = applyTimings || (!level.field_9236 && loadMyChunks$getDataModule().shouldUseTimings());
        if(useTimings){
            loadMyChunks$loadDataModule.getTickTimer().startBlockEntities();
        }
        iterator = loadMyChunks$tickers.iterator();
        while(iterator.hasNext()){
            class_2586 tickingblockentity = iterator.next();

            if (tickingblockentity.method_11015()) {
                ((ILevelMixin)level).loadMyChunks$removeTicker(tickingblockentity);
                iterator.remove();
            } else if(tickingblockentity instanceof class_3000){
                try {
                    profilerFiller.method_15400(() -> String.valueOf(class_2591.method_11033(tickingblockentity.method_11017())));
                    if (tickingblockentity.method_11017().method_20526(getBlockState(tickingblockentity.method_11016()).method_26204())) {
                        ((class_3000)tickingblockentity).method_16896();
                    } else {
                        tickingblockentity.method_20525();
                    }
                    profilerFiller.method_15407();
                } catch (Throwable var8) {
                    class_128 crashReport = class_128.method_560(var8, "Ticking block entity");
                    class_129 crashReportCategory = crashReport.method_562("Block entity being ticked");
                    tickingblockentity.method_11003(crashReportCategory);
                    throw new class_148(crashReport);
                }
            }
        }
        if(useTimings){
            loadMyChunks$loadDataModule.getTickTimer().endBlockEntities();
            loadMyChunks$loadDataModule.inform();
            if(applyTimings && loadMyChunks$loadDataModule.isOverticked()){
                loadMyChunks$loadDataModule.consumeLoadState(prev->{
                    loadMyChunks$loadDataModule.startShutoff();
                    ChunkDataManager.markShutDown((class_3218)level,chunkPos,prev);
                });
            }
        }
    }

    // Use inject instead due to conflict with fabric mixins
    @Inject(method = "getBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk$EntityCreationType;)Lnet/minecraft/world/level/block/entity/BlockEntity;",at = @At(value = "INVOKE", target = "Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;",ordinal = 0),
            slice = @Slice(
            from = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/entity/BlockEntity;isRemoved()Z"
            )),
            locals = LocalCapture.CAPTURE_FAILHARD
    )
    public void properlyDestroyTileEntities1(class_2338 blockPos, class_2818.class_2819 entityCreationType, CallbackInfoReturnable<class_2586> cir, class_2586 blockEntity){
        if(!level.field_9236){
            if(blockEntity instanceof IDestroyable){
                ((IDestroyable)blockEntity).loadMyChunks$destroy();
            }
        }
    }
    @Redirect(method = "removeBlockEntity",at = @At(value = "INVOKE", target = "Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;",ordinal = 0))
    public Object properlyDestroyTileEntities2(Map<?,?> instance, Object o){
        Object rem = instance.remove(o);
        if(rem instanceof IDestroyable && !level.method_8608()){
            ((IDestroyable) rem).loadMyChunks$destroy();
        }
        return rem;
    }

    @Inject(method = "setBlockEntity",at = @At(value = "INVOKE",target = "Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;",shift = At.Shift.AFTER))
    public void addTicker(class_2338 blockPos, class_2586 blockEntity, CallbackInfo ci){
        if(blockEntity instanceof class_3000) {
            if(!level.method_8608()) {
                loadMyChunks$queued.add(blockEntity);
            }
        }
    }
    //?}
}
