package com.drathonix.loadmychunks.common.system;


import com.drathonix.loadmychunks.common.bridge.IChunkMapMixin;
import com.drathonix.loadmychunks.common.bridge.IInformable;
import com.drathonix.loadmychunks.common.bridge.ILevelChunkMixin;
import com.drathonix.loadmychunks.common.bridge.IServerLevelMixin;
import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.registry.custom.LoaderTypeRegistry;
import com.drathonix.loadmychunks.common.system.control.*;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IChunkLoader;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import com.drathonix.loadmychunks.common.util.ModResource;
import com.drathonix.loadmychunks.common.util.MultiversioningHelper;
import com.drathonix.loadmychunks.common.util.ProtectedEntityTickList;

//? if forge {
/*import net.minecraftforge.entity.PartEntity;
*///?}
//? if neoforge {
/*import net.neoforged.neoforge.entity.PartEntity;
*///?}

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3695;

public class ChunkDataModule {
    private final ProtectedEntityTickList entities = new ProtectedEntityTickList();
    private final CombinedTimings chunkTickTimer = new CombinedTimings();
    private Period gracePeriod;
    private Period disabledPeriod;
    public ILoadState defaultLoadState = LoadStateEnum.DISABLED;
    private ILoadState loadState = defaultLoadState;
    private final Set<IChunkLoader> loaders = new HashSet<>();
    private final class_1923 position;
    //private ILevelChunkMixin chunk;
    private final Set<IInformable> recipients = new HashSet<>();
    private long nextGameTimeCheckTick = -1;

    public ChunkDataModule(class_1923 position){
        this.position=position;
    }

    public ChunkDataModule(long position){
        this(new class_1923(position));
    }

    public void load(class_2487 tag, class_3218 level){
        if(tag.method_10545("grace")){
            gracePeriod = new Period(tag.method_10537("grace"));
        }
        if(tag.method_10545("disabled")){
            disabledPeriod = new Period(tag.method_10537("disabled"));
        }
        if(tag.method_10545("nextCheck")){
            nextGameTimeCheckTick = tag.method_10537("nextCheck");
        }
        defaultLoadState = LoadStateRegistry.fromCompound("default",tag,LoadStateRegistry.DISABLED);
        loadState=defaultLoadState;
        class_2499 loaders = tag.method_10554("loaders", 10);
        for (class_2520 loader : loaders) {
            if(loader instanceof class_2487){
                class_2487 ct = (class_2487) loader;
                LoaderTypeRegistry.INSTANCE.method_17966(ModResource.parse(ct.method_10558("type_id")))
                .ifPresent(obj->{
                    IChunkLoader loaderInst = obj.create();
                    try {
                        loaderInst.load(ct, level);
                        addLoader(level,loaderInst);
                        //TODO Redo this such that it only runs after a chunk has been added to the chunk map and wont cause a deadlock.
                        /*try {
                            loaderInst.postLoad(level);
                        } catch (DoNotAddException ignored){
                            removeLoader(level,loaderInst);
                        }*/
                        //Delete loaders that explicitly request to not be added to the CDM (likely due to invalid data).
                    } catch (DoNotAddException ignored){}
                });
            }
        }
        if(loadState.shouldLoad()) {
            startGrace();
        }
    }

    public class_2487 save(){
        class_2487 tag = new class_2487();
        if(gracePeriod != null){
            tag.method_10544("grace",gracePeriod.getEnd());
        }
        if(disabledPeriod != null){
            tag.method_10544("disabled",disabledPeriod.getEnd());
        }
        tag.method_10544("nextCheck",nextGameTimeCheckTick);
        class_2499 loaders = new class_2499();
        for (IChunkLoader loader : this.loaders) {
            if(loader.shouldPersist()) {
                class_2487 data = new class_2487();
                data.method_10582("type_id", loader.getTypeId().toString());
                data = loader.save(data);
                loaders.add(data);
            }
        }
        tag.method_10566("loaders",loaders);
        defaultLoadState.putCompound("default",tag);
        return tag;
    }

    /**
     * Adds a loader to the chunk data module if it is not already present.
     * @param loader the loader to be added
     * @return whether the chunk's loadstate has changed.
     */
    public boolean addLoader(class_3218 level, @NotNull IChunkLoader loader){
        loaders.add(loader);
        ILoadState previous = loadState;
        if(onCooldown()){
            loadState = LoadStateEnum.OVERTICKED;
        }
        else{
            loadState = loader.getActiveState().getSuperiorLoadState(loadState);
        }
        nextGameTimeCheckTick=-1;
        if(loader instanceof IOwnable) {}
        return previous != loadState;
    }

    /**
     * Remove a loader from the chunk data module if it is present.
     * @param loader the loader to be removed
     * @return whether the chunk's loadstate has changed.
     */
    public boolean removeLoader(class_3218 level, @NotNull IChunkLoader loader){
        if(loader.hasExtensions()){
            loader.getExtensionChunkLoaders().recompute(loader.getExtensionClass(),-1, null);
        }
        loaders.remove(loader);
        ILoadState previous = loadState;
        update();
        nextGameTimeCheckTick=-1;
        if(loader instanceof IOwnable){
            if(!getAllOwners().contains(((IOwnable)loader).getOwner())){
                ChunkDataManager.markChunkNotOwnedBy(level,position.method_8324(),((IOwnable) loader).getOwner());
            }
        }
        return previous != loadState;
    }

    /**
     * Updates the LoadState based on the loaders in the chunk.
     */
    public void update(){
        loadState = defaultLoadState;
        if(!onCooldown()) {
            for (IChunkLoader loader : loaders) {
                loadState = loader.getActiveState().getSuperiorLoadState(loadState);
                if(loadState.blockEntityTickingPower() == LoaderPower.FORCED){
                    break;
                }
            }
        }
        else{
            loadState= LoadStateEnum.OVERTICKED;
            gracePeriod=null;
        }

    }

    public @NotNull CombinedTimings getTickTimer(){
        return chunkTickTimer;
    }

    public boolean isOverticked(){
        return chunkTickTimer.durationExceeds(LMCConfig.msPerChunk);
    }

    public @Nullable Period getGracePeriod(){
        return gracePeriod;
    }

    public @Nullable Period getDisabledPeriod(){
        return disabledPeriod;
    }

    public @NotNull ILoadState getLoadState(){
        return loadState;
    }

    public @NotNull Set<IChunkLoader> getLoaders() {
        return loaders;
    }

    public boolean shouldUseTimings() {
        return !recipients.isEmpty() || shouldApplyTimings();
    }

    public boolean shouldApplyTimings(){
        return loadState.blockEntityTickingPower().isManaged() && !inGrace();
    }

    public boolean isPermaLoaded(){
        return loadState.shouldLoad() && loadState.permanent();
    }

    public void startGrace(){
        gracePeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.reloadGracePeriod));
    }

    public void startShutoff(){
        loadState = LoadStateEnum.OVERTICKED;
        disabledPeriod = Period.after(TimeUnit.SECONDS.toMillis(LMCConfig.delayBeforeReload));
    }

    public boolean onCooldown() {
        return disabledPeriod != null && !disabledPeriod.hasEnded();
    }

    public boolean inGrace() {
        return gracePeriod != null && !gracePeriod.hasEnded();
    }

    public @NotNull class_1923 getPosition(){
        return position;
    }

    public boolean containsOwnedLoader(@NotNull UUID uuid) {
        for (IChunkLoader loader : loaders) {
            if(loader instanceof IOwnable && uuid.equals(((IOwnable)loader).getOwner())){
               return true;
            }
        }
        return false;
    }

    public void addRecipient(IInformable informable) {
        recipients.add(informable);
    }

    public void removeRecipient(IInformable informable){
        recipients.remove(informable);
    }

    public void inform(){
        Iterator<IInformable> iterator = recipients.iterator();
        float frac = chunkTickTimer.getLagFraction();
        while(iterator.hasNext()) {
            IInformable informable = iterator.next();
            informable.lmc$informLagFrac(frac);
            if(informable instanceof class_2586){
                if(((class_2586) informable).method_11015()){
                    iterator.remove();
                }
            }
            if(informable instanceof class_1297){
                //? if >1.16.5 {
                /*if(((Entity) informable).chunkPosition().toLong() != position.toLong()){
                    iterator.remove();
                }
                *///?}
                //? if <=1.16.5 {
                class_1297 e = (class_1297) informable;
                if(new class_1923(e.field_6024,e.field_5980).method_8324() != position.method_8324()){
                    iterator.remove();
                }
                //?}
            }
        }
    }

    public Set<@NotNull UUID> getPlayerOwners() {
        HashSet<UUID> owners = new HashSet<>();
        for (IChunkLoader loader : loaders) {
            if(loader instanceof IOwnable){
                if(((IOwnable) loader).hasOwner()){
                    owners.add(((IOwnable) loader).getOwner());
                }
            }
        }
        return owners;
    }

    public Set<@Nullable UUID> getAllOwners() {
        HashSet<UUID> owners = new HashSet<>();
        for (IChunkLoader loader : loaders) {
            if(loader instanceof IOwnable){
                owners.add(((IOwnable) loader).getOwner());
            }
        }
        return owners;
    }

    public void clearCooldowns() {
        disabledPeriod=null;
        gracePeriod=null;
    }

    public boolean shouldPersist(){
        return (defaultLoadState != LoadStateEnum.DISABLED) || loadState.permanent() || !loaders.isEmpty();
    }

    @SuppressWarnings("all")
    public long getCooldownTime(){
        return onCooldown() ? getDisabledPeriod().getTimeRemaining() : 0;
    }

    public void updateChunkLoadState(@NotNull class_3218 level, @NotNull ILoadState previous){
        if(getLoadState().shouldLoad()){
            startGrace();
        }
        getLoadState().apply(level, position.method_8324(),previous);
    }

    public @Nullable PlacedChunkLoader getChunkLoaderAt(class_2338 blockPos) {
        for (IChunkLoader loader : loaders) {
            if(loader instanceof PlacedChunkLoader && ((PlacedChunkLoader)loader).getPosition().equals(blockPos)){
                return (PlacedChunkLoader) loader;
            }
        }
        return null;
    }

    public void preTick(class_3218 level) {
        if(LMCConfig.cost.enabled && level.method_8510() >= nextGameTimeCheckTick){
            boolean doStateUpdateCheck = false;
            for (IChunkLoader loader : loaders) {
                ILoadState pre = loader.getActiveState();
                loader.timingsCheck(level,this,level.method_8510());
                if(pre != loader.getActiveState()){
                    doStateUpdateCheck=true;
                }
            }
            if(doStateUpdateCheck) {
                consumeLoadState(previous->{
                    update(()->updateChunkLoadState(level,previous));
                });
            }
        }
    }

    public void update(Runnable onChange){
        ILoadState pre = loadState;
        update();
        if(pre != loadState){
            onChange.run();
        }
    }

    public void updateCheckTime(long time) {
        this.nextGameTimeCheckTick = time;
    }

    public void consumeLoadState(Consumer<ILoadState> consumer){
        consumer.accept(loadState);
    }

    // Note: Its assumed that this method is called on when this chunk that is actually entity ticking.
    public void tickEntities(class_3218 sl, class_3695 profilerfiller){
        boolean applyTimings = shouldApplyTimings();
        boolean useTimings = applyTimings || shouldUseTimings();
        IServerLevelMixin mixin = (IServerLevelMixin) sl;
        if(useTimings){
            getTickTimer().startEntities();
        }
        entities.forEach(entity -> {
            if (!MultiversioningHelper.isRemoved(entity)
                //? if >=1.21.2 {
                /*&& !sl.tickRateManager().isEntityFrozen(entity)
                 *///?}
            ) {
                if (mixin.lmc$shouldDiscardEntity(entity)) {
                    //? if >1.16.5 {
                    /*entity.discard();
                    *///?} else {
                    entity.method_5650();
                     //?}
                } else {
                    profilerfiller.method_15396("checkDespawn");
                    entity.method_5982();
                    profilerfiller.method_15407();
                    class_1297 vehicle = entity.method_5854();
                    if (vehicle != null) {
                        if (!MultiversioningHelper.isRemoved(vehicle) && vehicle.method_5626(entity)) {
                            return; // this continues the forEach for anyone confused.
                        }
                        entity.method_5848();
                    }
                    // Anything here will not be a passenger.
                    profilerfiller.method_15396("tick");
                    // Neoforge/forge specific
                    //? if neoforge || forge {
                    /*if(!(entity instanceof PartEntity))
                        *///?}
                        sl.method_18472(sl::method_18762, entity);

                    profilerfiller.method_15407();

                }
            }
        });
        if(useTimings){
            getTickTimer().endEntities();
        }
    }

    public void lmc$removeEntity(class_1297 entity){
        entities.remove(entity);
    }
    public void lmc$addEntity(class_1297 entity){
        entities.add(entity);
    }
}
