package com.drathonix.loadmychunks.common.system.loaders.extension;

import com.drathonix.loadmychunks.common.config.LMCConfig;
import com.drathonix.loadmychunks.common.registry.LoaderTypeKeys;
import com.drathonix.loadmychunks.common.registry.custom.LoadStateRegistry;
import com.drathonix.loadmychunks.common.system.ChunkDataManager;
import com.drathonix.loadmychunks.common.system.ChunkDataModule;
import com.drathonix.loadmychunks.common.system.control.ILoadState;
import com.drathonix.loadmychunks.common.system.loaders.DoNotAddException;
import com.drathonix.loadmychunks.common.system.loaders.IOwnable;
import com.drathonix.loadmychunks.common.system.loaders.PlacedChunkLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class PlacedExtensionChunkLoader extends ExtensionChunkLoader<PlacedChunkLoader> implements IOwnable {
    protected long activityEnd = -1;

    public PlacedExtensionChunkLoader(){}
    public PlacedExtensionChunkLoader(class_1923 loadedChunk, PlacedChunkLoader host){
        super(host,loadedChunk);
    }

    @Override
    public @NotNull class_2487 save(@NotNull class_2487 tag) {
        tag = super.save(tag);
        class_2501 hostsTag = new class_2501(new long[0]);
        for (int i = 0; i < hosts.length; i++) {
            hostsTag.add(class_2503.method_23251(getHost(i).getPosition().method_10063()));
        }
        tag.method_10566("hosts",hostsTag);
        tag.method_10544("duration",activityEnd);
        return tag;
    }

    @Override
    public void load(@NotNull class_2487 tag, class_3218 level) throws DoNotAddException {
        long[] hostPoses = tag.method_10565("host");
        this.hosts = new PlacedChunkLoader[hostPoses.length];
        if(hosts.length == 0){
            throw new DoNotAddException();
        }
        for (int i = 0; i < hosts.length; i++) {
            class_2338 p = class_2338.method_10092(hostPoses[i]);
            hosts[i] = ChunkDataManager.computeChunkLoaderIfAbsent(level,p, PlacedChunkLoader.class,loader->loader.getPosition().equals(p),()->new PlacedChunkLoader(p));
        }
        if(tag.method_10545("duration")){
            activityEnd = tag.method_10537("duration");
        }
        super.load(tag, level);
    }

    @Override
    public @Nullable UUID getOwner() {
        PlacedChunkLoader pcl = getPrimaryHostLoader();
        if(pcl != null) {
            return pcl.getOwner();
        }
        else{
            return null;
        }
    }

    @Override
    public void setOwner(@NotNull UUID owner) {

    }

    @Override
    public class_2960 getTypeId() {
        return LoaderTypeKeys.PLACED_EXTENSION_LOADER;
    }

    @Override
    public ILoadState getActiveState() {
        if(hasExceededChunkLimit() || (LMCConfig.cost.enabled && activityEnd == -1)){
            return LoadStateRegistry.DISABLED;
        }
        return super.getActiveState();
    }

    @Override
    public @NotNull class_2338 getItemSource() {
        return getPrimaryHostLoader().getItemSource();
    }

    @Override
    public boolean shouldConsumeItems() {
        return isHosted() && super.shouldConsumeItems();
    }
}
