/*
 * Decompiled with CFR 0.152.
 */
package com.geitenijs.commandblocks;

import com.geitenijs.commandblocks.Events;
import com.geitenijs.commandblocks.Main;
import com.geitenijs.commandblocks.Metrics;
import com.geitenijs.commandblocks.Strings;
import com.geitenijs.commandblocks.commands.CommandWrapper;
import com.geitenijs.commandblocks.updatechecker.UpdateCheck;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.milkbowl.vault.Vault;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Utilities {
    public static FileConfiguration config;
    public static FileConfiguration blocks;
    static ConcurrentHashMap<String, Double> timeouts;
    private static File configFile;
    private static File blocksFile;
    private static boolean updateAvailable;
    private static String updateVersion;

    static void pluginBanner() {
        if (config.getBoolean("general.pluginbanner")) {
            Utilities.consoleBanner("");
            Utilities.consoleBanner("&c _______                                  _&8 ______  _             _          ");
            Utilities.consoleBanner("&c(_______)                                | &8(____  \\| |           | |  &cv1.4.0");
            Utilities.consoleBanner("&c _       ___  ____  ____  _____ ____   __| &8|____)  ) | ___   ____| |  _  ___ ");
            Utilities.consoleBanner("&c| |     / _ \\|    \\|    \\(____ |  _ \\ / _  &8|  __  (| |/ _ \\ / ___) |_/ )/___)");
            Utilities.consoleBanner("&c| |____| |_| | | | | | | / ___ | | | ( (_| &8| |__)  ) | |_| ( (___|  _ (|___ |");
            Utilities.consoleBanner("&c \\______)___/|_|_|_|_|_|_\\_____|_| |_|\\____&8|______/ \\_)___/ \\____)_| \\_|___/ ");
            Utilities.consoleBanner("");
        }
    }

    static void createConfigs() {
        ArrayList<String> configComments = new ArrayList<String>();
        configComments.addAll(Strings.ASCIILOGO);
        configComments.addAll(Arrays.asList("Executing your commands since 2018! By Geitenijs", "Information & Support: https://www.spigotmc.org/resources/62720", "", "general:", "  pluginbanner: Whether or not to display the fancy banner in your console on server startup.", "  colourfulconsole: Console messages will be coloured when this is enabled.", "updates:", "  check: When enabled, the plugin will check for updates. No automatic downloads, just a subtle notification in the console.", "  notify: Would you like to get an in-game reminder of a new update? Requires permission 'commandblocks.notify.update'.", "default:"));
        config.options().setHeader(configComments);
        configComments.addAll(Strings.BLOCKDEFAULTS);
        config.set("general.debug", null);
        config.addDefault("general.pluginbanner", (Object)true);
        config.addDefault("general.colourfulconsole", (Object)true);
        config.addDefault("updates.check", (Object)true);
        config.addDefault("updates.notify", (Object)true);
        ArrayList<String> successCommandsConsole = new ArrayList<String>();
        ArrayList<String> successCommandsPlayer = new ArrayList<String>();
        ArrayList successMessages = new ArrayList();
        ArrayList permissionCommandsConsole = new ArrayList();
        ArrayList permissionCommandsPlayer = new ArrayList();
        ArrayList<String> permissionMessages = new ArrayList<String>();
        ArrayList costCommandsConsole = new ArrayList();
        ArrayList costCommandsPlayer = new ArrayList();
        ArrayList<String> costMessages = new ArrayList<String>();
        ArrayList timeoutCommandsConsole = new ArrayList();
        ArrayList timeoutCommandsPlayer = new ArrayList();
        ArrayList<String> timeoutMessages = new ArrayList<String>();
        successCommandsConsole.add("say {player} used a CommandBlock!");
        successCommandsPlayer.add("me I used a CommandBlock!");
        permissionMessages.add("&cYou don't have permission to do that.");
        costMessages.add("&cYou don't have sufficient funds to do that.");
        timeoutMessages.add("&cPlease wait {time} seconds before doing that again.");
        config.addDefault("default.success.commands.console", successCommandsConsole);
        config.addDefault("default.success.commands.player", successCommandsPlayer);
        config.addDefault("default.success.messages", successMessages);
        config.addDefault("default.permission.value", (Object)"commandblocks.use");
        config.addDefault("default.permission.commands.console", permissionCommandsConsole);
        config.addDefault("default.permission.commands.player", permissionCommandsPlayer);
        config.addDefault("default.permission.messages", permissionMessages);
        config.addDefault("default.cost.value", (Object)0);
        config.addDefault("default.cost.bypasspermission", (Object)"commandblocks.cost.bypass");
        config.addDefault("default.cost.commands.console", costCommandsConsole);
        config.addDefault("default.cost.commands.player", costCommandsPlayer);
        config.addDefault("default.cost.messages", costMessages);
        config.addDefault("default.timeout.value", (Object)5);
        config.addDefault("default.timeout.bypasspermission", (Object)"commandblocks.timeout.bypass");
        config.addDefault("default.timeout.commands.console", timeoutCommandsConsole);
        config.addDefault("default.timeout.commands.player", timeoutCommandsPlayer);
        config.addDefault("default.timeout.messages", timeoutMessages);
        config.addDefault("default.delay.value", (Object)0);
        ArrayList<String> blocksComments = new ArrayList<String>();
        blocksComments.addAll(Strings.ASCIILOGO);
        blocksComments.addAll(Arrays.asList("Executing your commands since 2018! By Geitenijs", "Information & Support: https://www.spigotmc.org/resources/62720", "", "block:", "  location: The location of the CommandBlock. Don't change this unless you know what you're doing!"));
        blocksComments.addAll(Strings.BLOCKDEFAULTS);
        blocks.options().setHeader(blocksComments);
        config.options().parseComments(true);
        config.options().copyDefaults(true);
        blocks.options().parseComments(true);
        blocks.options().copyDefaults(true);
        Utilities.saveConfigFile();
        Utilities.reloadConfigFile();
        Utilities.saveBlocksFile();
        Utilities.reloadBlocksFile();
    }

    static void registerCommandsAndCompletions() {
        Main.plugin.getCommand("commandblocks").setExecutor((CommandExecutor)new CommandWrapper());
        Main.plugin.getCommand("cb").setExecutor((CommandExecutor)new CommandWrapper());
        Main.plugin.getCommand("commandblocks").setTabCompleter((TabCompleter)new CommandWrapper());
        Main.plugin.getCommand("cb").setTabCompleter((TabCompleter)new CommandWrapper());
    }

    static void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new Events(), (Plugin)Main.plugin);
    }

    static void startTasks() {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                for (String o : timeouts.keySet()) {
                    timeouts.put(o, timeouts.get(o) - 1.0);
                    if (!(timeouts.get(o) <= 0.0)) continue;
                    timeouts.remove(o);
                }
            }
        };
        runnable.runTaskTimerAsynchronously((Plugin)Main.plugin, 0L, 1L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, Utilities::checkForUpdates, 200L);
    }

    static void stopTasks() {
        Bukkit.getScheduler().cancelTasks((Plugin)Main.plugin);
    }

    static void startMetrics() {
        Metrics metrics = new Metrics((Plugin)Main.plugin, 3655);
        metrics.addCustomChart(new Metrics.SingleLineChart("definedCommandBlocks", () -> blocks.getKeys(false).size()));
        metrics.addCustomChart(new Metrics.SimplePie("pluginBannerEnabled", () -> config.getString("general.pluginbanner")));
        metrics.addCustomChart(new Metrics.SimplePie("colourfulConsoleEnabled", () -> config.getString("general.colourfulconsole")));
        metrics.addCustomChart(new Metrics.SimplePie("updateCheckEnabled", () -> config.getString("updates.check")));
        metrics.addCustomChart(new Metrics.SimplePie("updateNotificationEnabled", () -> config.getString("updates.notify")));
        metrics.addCustomChart(new Metrics.SimplePie("vaultVersion", () -> {
            Plugin p = Bukkit.getPluginManager().getPlugin("Vault");
            if (!(p instanceof Vault)) {
                return "None";
            }
            return Bukkit.getServer().getPluginManager().getPlugin("Vault").getDescription().getVersion();
        }));
    }

    static void done() {
        Utilities.consoleMsg("CommandBlocks v1.4.0 has been enabled");
    }

    private static void checkForUpdates() {
        if (config.getBoolean("updates.check")) {
            UpdateCheck.of(Main.plugin).resourceId(62720).handleResponse((versionResponse, version) -> {
                switch (versionResponse) {
                    case FOUND_NEW: {
                        Utilities.consoleMsg("A new release of CommandBlocks, v" + version + ", is available! You are still on v1.4.0.");
                        Utilities.consoleMsg("To download this update, head over to https://www.spigotmc.org/resources/62720/updates in your browser.");
                        updateVersion = version;
                        updateAvailable = true;
                        break;
                    }
                    case LATEST: {
                        updateAvailable = false;
                        break;
                    }
                    case UNAVAILABLE: {
                        updateAvailable = false;
                    }
                }
            }).check();
        }
    }

    static boolean updateAvailable() {
        return updateAvailable;
    }

    static String updateVersion() {
        return updateVersion;
    }

    public static void reloadConfigFile() {
        if (configFile == null) {
            configFile = new File(Main.plugin.getDataFolder(), "config.yml");
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    static void saveConfigFile() {
        if (config == null || configFile == null) {
            return;
        }
        try {
            config.save(configFile);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + configFile, ex);
        }
    }

    public static void reloadBlocksFile() {
        if (blocksFile == null) {
            blocksFile = new File(Main.plugin.getDataFolder(), "blocks.yml");
        }
        blocks = YamlConfiguration.loadConfiguration((File)blocksFile);
    }

    public static void saveBlocksFile() {
        if (blocks == null || blocksFile == null) {
            return;
        }
        try {
            blocks.save(blocksFile);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + blocksFile, ex);
        }
    }

    public static void msg(CommandSender s, String msg) {
        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
        if (!(s instanceof Player) && !config.getBoolean("general.colourfulconsole")) {
            msg = ChatColor.stripColor((String)msg);
        }
        s.sendMessage(msg);
    }

    public static void consoleMsg(String msg) {
        msg = ChatColor.translateAlternateColorCodes((char)'&', (String)("[CommandBlocks] " + msg));
        if (!config.getBoolean("general.colourfulconsole")) {
            msg = ChatColor.stripColor((String)msg);
        }
        Bukkit.getServer().getConsoleSender().sendMessage(msg);
    }

    private static void consoleBanner(String message) {
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    static {
        timeouts = new ConcurrentHashMap();
        configFile = new File(Main.plugin.getDataFolder(), "config.yml");
        blocksFile = new File(Main.plugin.getDataFolder(), "blocks.yml");
        config = YamlConfiguration.loadConfiguration((File)new File(Main.plugin.getDataFolder(), "config.yml"));
        blocks = YamlConfiguration.loadConfiguration((File)new File(Main.plugin.getDataFolder(), "blocks.yml"));
    }
}

