/*
 * Decompiled with CFR 0.152.
 */
package com.geitenijs.commandblocks.commands;

import com.geitenijs.commandblocks.Utilities;
import com.geitenijs.commandblocks.commands.Command_Create;
import com.geitenijs.commandblocks.commands.Command_Help;
import com.geitenijs.commandblocks.commands.Command_List;
import com.geitenijs.commandblocks.commands.Command_Main;
import com.geitenijs.commandblocks.commands.Command_Reload;
import com.geitenijs.commandblocks.commands.Command_Remove;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CommandWrapper
implements CommandExecutor,
TabCompleter {
    private final CommandExecutor MainCommand = new Command_Main();
    private final CommandExecutor HelpCommand = new Command_Help();
    private final CommandExecutor ReloadCommand = new Command_Reload();
    private final CommandExecutor ListCommand = new Command_List();
    private final CommandExecutor CreateCommand = new Command_Create();
    private final CommandExecutor RemoveCommand = new Command_Remove();
    private final TabCompleter MainTab = new Command_Main();
    private final TabCompleter HelpTab = new Command_Help();
    private final TabCompleter ReloadTab = new Command_Reload();
    private final TabCompleter ListTab = new Command_List();
    private final TabCompleter CreateTab = new Command_Create();
    private final TabCompleter RemoveTab = new Command_Remove();

    static ArrayList<String> filterTabs(ArrayList<String> list, String[] origArgs) {
        if (origArgs.length == 0) {
            return list;
        }
        Iterator<String> itel = list.iterator();
        String label = origArgs[origArgs.length - 1].toLowerCase();
        while (itel.hasNext()) {
            String name = itel.next();
            if (name.toLowerCase().startsWith(label)) continue;
            itel.remove();
        }
        return list;
    }

    static String[] getArgs(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length - 1; ++i) {
            String s = args[i];
            if (s.trim().isEmpty()) continue;
            newArgs.add(s);
        }
        return newArgs.toArray(new String[0]);
    }

    public boolean onCommand(CommandSender s, Command c, String label, String[] args) {
        if (c.getName().equalsIgnoreCase("commandblocks") || c.getName().equalsIgnoreCase("cb")) {
            if (args.length == 0) {
                return this.MainCommand.onCommand(s, c, label, args);
            }
            if (args[0].equalsIgnoreCase("help")) {
                if (s.hasPermission("commandblocks.help")) {
                    return this.HelpCommand.onCommand(s, c, label, args);
                }
                Utilities.msg(s, "&c&lC&8&lB &7&l\u00bb &cYou don't have permission to do that.");
            } else if (args[0].equalsIgnoreCase("reload")) {
                if (s.hasPermission("commandblocks.reload")) {
                    return this.ReloadCommand.onCommand(s, c, label, args);
                }
                Utilities.msg(s, "&c&lC&8&lB &7&l\u00bb &cYou don't have permission to do that.");
            } else if (args[0].equalsIgnoreCase("list")) {
                if (s.hasPermission("commandblocks.list")) {
                    return this.ListCommand.onCommand(s, c, label, args);
                }
                Utilities.msg(s, "&c&lC&8&lB &7&l\u00bb &cYou don't have permission to do that.");
            } else if (args[0].equalsIgnoreCase("create")) {
                if (s.hasPermission("commandblocks.create")) {
                    return this.CreateCommand.onCommand(s, c, label, args);
                }
                Utilities.msg(s, "&c&lC&8&lB &7&l\u00bb &cYou don't have permission to do that.");
            } else if (args[0].equalsIgnoreCase("remove")) {
                if (s.hasPermission("commandblocks.remove")) {
                    return this.RemoveCommand.onCommand(s, c, label, args);
                }
                Utilities.msg(s, "&c&lC&8&lB &7&l\u00bb &cYou don't have permission to do that.");
            } else {
                Utilities.msg(s, "&c&lC&8&lB &7&l\u00bb &cThat command does not exist.");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender s, Command c, String label, String[] args) {
        if (c.getName().equalsIgnoreCase("commandblocks") || c.getName().equalsIgnoreCase("cb")) {
            if (args.length == 1) {
                if (s.hasPermission("commandblocks.help")) {
                    return this.MainTab.onTabComplete(s, c, label, args);
                }
            } else if (args[0].equalsIgnoreCase("help")) {
                if (s.hasPermission("commandblocks.help")) {
                    return this.HelpTab.onTabComplete(s, c, label, args);
                }
            } else if (args[0].equalsIgnoreCase("reload")) {
                if (s.hasPermission("commandblocks.reload")) {
                    return this.ReloadTab.onTabComplete(s, c, label, args);
                }
            } else if (args[0].equalsIgnoreCase("list")) {
                if (s.hasPermission("commandblocks.list")) {
                    return this.ListTab.onTabComplete(s, c, label, args);
                }
            } else if (args[0].equalsIgnoreCase("create")) {
                if (s.hasPermission("commandblocks.create")) {
                    return this.CreateTab.onTabComplete(s, c, label, args);
                }
            } else if (args[0].equalsIgnoreCase("remove") && s.hasPermission("commandblocks.remove")) {
                return this.RemoveTab.onTabComplete(s, c, label, args);
            }
        }
        return null;
    }
}

