/*
 * Decompiled with CFR 0.152.
 */
package com.geitenijs.commandblocks.updatechecker;

import com.geitenijs.commandblocks.updatechecker.VersionResponse;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateCheck {
    private static final String SPIGOT_URL = "https://api.spigotmc.org/legacy/update.php?resource=%d";
    private final JavaPlugin javaPlugin;
    private final String currentVersion;
    private int resourceId = -1;
    private BiConsumer<VersionResponse, String> versionResponse;

    private UpdateCheck(@Nonnull JavaPlugin javaPlugin) {
        this.javaPlugin = Objects.requireNonNull(javaPlugin, "javaPlugin");
        this.currentVersion = "1.4.0";
    }

    public static UpdateCheck of(@Nonnull JavaPlugin javaPlugin) {
        return new UpdateCheck(javaPlugin);
    }

    public UpdateCheck resourceId(int resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public UpdateCheck handleResponse(@Nonnull BiConsumer<VersionResponse, String> versionResponse) {
        this.versionResponse = versionResponse;
        return this;
    }

    public void check() {
        Objects.requireNonNull(this.javaPlugin, "javaPlugin");
        Objects.requireNonNull(this.currentVersion, "currentVersion");
        Preconditions.checkState((this.resourceId != -1 ? 1 : 0) != 0, (Object)"resource id not set");
        Objects.requireNonNull(this.versionResponse, "versionResponse");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.javaPlugin, () -> {
            try {
                HttpsURLConnection httpURLConnection = (HttpsURLConnection)new URL(String.format(SPIGOT_URL, this.resourceId)).openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
                String fetchedVersion = Resources.toString((URL)httpURLConnection.getURL(), (Charset)Charset.defaultCharset());
                boolean latestVersion = fetchedVersion.equalsIgnoreCase(this.currentVersion);
                Bukkit.getScheduler().runTask((Plugin)this.javaPlugin, () -> this.versionResponse.accept(latestVersion ? VersionResponse.LATEST : VersionResponse.FOUND_NEW, latestVersion ? this.currentVersion : fetchedVersion));
            }
            catch (IOException ex) {
                Bukkit.getScheduler().runTask((Plugin)this.javaPlugin, () -> this.versionResponse.accept(VersionResponse.UNAVAILABLE, null));
            }
        });
    }
}

