package team.creative.itemphysiclite.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import team.creative.itemphysiclite.ItemEntityRenderStateExtender;
import team.creative.itemphysiclite.ItemPhysicLite;

@Mixin(ItemEntityRenderer.class)
public abstract class ItemEntityRendererMixin extends EntityRenderer<ItemEntity, ItemEntityRenderState> {
    
    @Shadow
    @Final
    private RandomSource random;
    
    protected ItemEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }
    
    @Inject(method = "render(Lnet/minecraft/client/renderer/entity/state/ItemEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V",
            at = @At("HEAD"), cancellable = true, require = 1)
    private void render(ItemEntityRenderState state, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (ItemPhysicLite.render(state, poseStack, multiBufferSource, i, this.random)) {
            super.render(state, poseStack, multiBufferSource, i);
            ci.cancel();
        }
    }
    
    @Inject(method = "extractRenderState(Lnet/minecraft/world/entity/item/ItemEntity;Lnet/minecraft/client/renderer/entity/state/ItemEntityRenderState;F)V", at = @At("TAIL"),
            require = 1)
    public void injectExtract(ItemEntity item, ItemEntityRenderState state, float partialTicks, CallbackInfo info) {
        ((ItemEntityRenderStateExtender) state).extractPhysic(item);
    }
}
