/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysiclite;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionfc;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.itemphysiclite.ItemEntityRenderStateExtender;
import team.creative.itemphysiclite.ItemPhysicLiteConfig;
import team.creative.itemphysiclite.mixin.EntityAccessor;
import team.creative.itemphysiclite.mixin.ItemStackRenderStateAccessor;
import team.creative.itemphysiclite.mixin.LayerRenderStateAccessor;

@Mod(value="itemphysiclite", dist={Dist.CLIENT})
public class ItemPhysicLite
implements ClientLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"itemphysiclite");
    public static final String MODID = "itemphysiclite";
    public static ItemPhysicLiteConfig CONFIG;
    public static long lastTickTime;
    private static final double RANDOM_Y_OFFSET_SCALE = 0.007957747154594767;

    public static boolean submit(ItemEntityRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera, RandomSource rand) {
        if (state.ageInTicks < 1.0f) {
            return false;
        }
        pose.pushPose();
        rand.setSeed((long)state.seed);
        int j = ItemPhysicLite.getModelCount(state.count);
        boolean gui3d = ((ItemEntityRenderStateExtender)state).isBlock();
        ItemTransform transform = ((LayerRenderStateAccessor)((ItemStackRenderStateAccessor)state.item).callFirstLayer()).getTransform();
        pose.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
        pose.mulPose((Quaternionfc)Axis.ZP.rotation(((ItemEntityRenderStateExtender)state).getYRot()));
        Minecraft mc = Minecraft.getInstance();
        if (state.ageInTicks != 0.0f && (gui3d || mc.options != null)) {
            if (gui3d) {
                pose.translate(0.0, -0.2, -0.08);
            } else if (((ItemEntityRenderStateExtender)state).hasAdditionalOffset()) {
                pose.translate(0.0, 0.0, -0.14 - (double)state.bobOffset * 0.007957747154594767);
            } else {
                pose.translate(0.0, 0.0, -0.04 - (double)state.bobOffset * 0.007957747154594767);
            }
            double height = transform.scale().y();
            if (gui3d) {
                pose.translate(0.0, height, 0.0);
            }
            pose.mulPose((Quaternionfc)Axis.YP.rotation(((ItemEntityRenderStateExtender)state).getXRot()));
            if (gui3d) {
                pose.translate(0.0, -height, 0.0);
            }
        }
        if (!gui3d) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            pose.translate(f7, f8, f9);
        }
        float f = transform.scale().x();
        float f1 = transform.scale().y();
        float f2 = transform.scale().z();
        for (int k = 0; k < j; ++k) {
            pose.pushPose();
            if (k > 0 && gui3d) {
                float f11 = (rand.nextFloat() * 2.0f - 1.0f) * f;
                float f13 = (rand.nextFloat() * 2.0f - 1.0f) * f1;
                float f10 = (rand.nextFloat() * 2.0f - 1.0f) * f2;
                pose.translate(f11, f13, f10);
            }
            state.item.submit(pose, collector, state.lightCoords, OverlayTexture.NO_OVERLAY, state.outlineColor);
            pose.popPose();
            if (gui3d) continue;
            pose.translate(0.0f * f, 0.0f * f1, 0.09375f * f2);
        }
        pose.popPose();
        return true;
    }

    public static int getModelCount(int count) {
        if (count > 48) {
            return 5;
        }
        if (count > 32) {
            return 4;
        }
        if (count > 16) {
            return 3;
        }
        if (count > 1) {
            return 2;
        }
        return 1;
    }

    public static Fluid calculateFluid(ItemEntity item) {
        return ItemPhysicLite.calculateFluid(item, false);
    }

    public static Fluid calculateFluid(ItemEntity item, boolean below) {
        FluidState state;
        Fluid fluid;
        if (item.level() == null) {
            return null;
        }
        double d0 = item.position().y;
        BlockPos pos = item.blockPosition();
        if (below) {
            pos = pos.below();
        }
        if ((fluid = (state = item.level().getFluidState(pos)).getType()) == null || fluid.getTickDelay((LevelReader)item.level()) == 0) {
            return null;
        }
        if (below) {
            return fluid;
        }
        double filled = state.getHeight((BlockGetter)item.level(), pos);
        if (d0 - (double)pos.getY() - 0.2 <= filled) {
            return fluid;
        }
        return null;
    }

    public static Vec3 getStuckSpeedMultiplier(Entity entity) {
        return ((EntityAccessor)entity).getStuckSpeedMultiplier();
    }

    public static float getViscosity(Fluid fluid, Level level) {
        if (fluid == null) {
            return 0.0f;
        }
        return CreativeCore.loader().getFluidViscosityMultiplier(fluid, level);
    }

    public ItemPhysicLite() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerClient((ClientLoader)this);
    }

    public void onInitializeClient() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerClientRenderGui(x -> {
            lastTickTime = System.nanoTime();
        });
        CONFIG = new ItemPhysicLiteConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG, ConfigSynchronization.CLIENT, false);
    }
}

