/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysiclite.mixin;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.world.entity.item.ItemEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import team.creative.itemphysiclite.ClientPhysic;
import team.creative.itemphysiclite.ItemEntityRenderStateExtender;
import team.creative.itemphysiclite.ItemPhysicLite;
import team.creative.itemphysiclite.mixin.ItemStackRenderStateAccessor;
import team.creative.itemphysiclite.mixin.LayerRenderStateAccessor;

@Mixin(value={ItemEntityRenderState.class})
public class ItemEntityRenderStateMixin
implements ItemEntityRenderStateExtender {
    @Unique
    public float rotX;
    @Unique
    public float rotY;
    @Unique
    public boolean skipRendering;
    @Unique
    public boolean additionalOffset;
    @Unique
    public boolean isBlock;

    @Override
    public float getXRot() {
        return this.rotX;
    }

    @Override
    public float getYRot() {
        return this.rotY;
    }

    @Override
    public boolean hasAdditionalOffset() {
        return this.additionalOffset;
    }

    @Override
    public boolean isBlock() {
        return this.isBlock;
    }

    @Override
    public void extractPhysic(ItemEntity entity) {
        ItemEntityRenderState state = (ItemEntityRenderState)this;
        RenderType renderType = ((LayerRenderStateAccessor)((ItemStackRenderStateAccessor)state.item).callFirstLayer()).getRenderType();
        this.isBlock = state.item.usesBlockLight() && (renderType == null || renderType.getName().equals("item_entity_translucent_cull"));
        ClientPhysic.calculateRotation(entity, state);
        this.additionalOffset = ItemPhysicLite.CONFIG.blockRequireOffset.is(entity.level().getBlockState(entity.blockPosition())) || ItemPhysicLite.CONFIG.blockBelowRequireOffset.is(entity.level().getBlockState(entity.blockPosition().below()));
        this.rotX = entity.getXRot();
        this.rotY = entity.getYRot();
    }
}

