/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.living;

import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;

public class LivingEntityTypeBuilderJS<B extends LivingEntity> {
    private final BaseLivingEntityBuilder<?> builder;

    public <T extends BaseLivingEntityBuilder<B>> LivingEntityTypeBuilderJS(T builder) {
        this.builder = builder;
    }

    public EntityType<B> get() {
        BaseLivingEntityBuilder<?> js = this.builder;
        EntityType.Builder builder = EntityType.Builder.of(js.factory(), (MobCategory)js.mobCategory);
        builder.sized(js.width, js.height).clientTrackingRange(js.clientTrackingRange).updateInterval(js.updateInterval);
        if (js.spawnFarFromPlayer) {
            builder.canSpawnFarFromPlayer();
        }
        if (js.fireImmune) {
            builder.fireImmune();
        }
        if (!js.save) {
            builder.noSave();
        }
        if (js.immuneTo != null && js.immuneTo.length > 0) {
            Block[] blocks = new Block[js.immuneTo.length];
            for (int i = 0; i < js.immuneTo.length; ++i) {
                blocks[i] = (Block)BuiltInRegistries.BLOCK.get(js.immuneTo[i]);
            }
            builder.immuneTo(blocks);
        }
        if (!js.summonable) {
            builder.noSummon();
        }
        return builder.build(js.id.toString());
    }
}

