/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.builders.nonliving.entityjs;

import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.EntityTypeBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.ProjectileAnimatableJS;
import net.liopyu.entityjs.item.ProjectileItemBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;

public class ProjectileAnimatableJSBuilder
extends BaseEntityBuilder<ProjectileAnimatableJS> {
    public transient Consumer<ContextUtils.ProjectileEntityHitContext> onHitEntity;
    public transient Consumer<ContextUtils.ProjectileBlockHitContext> onHitBlock;
    public transient Predicate<Entity> canHitEntity;
    public transient Consumer<ContextUtils.CollidingProjectileEntityContext> onEntityCollision;
    public transient ProjectileItemBuilder item;
    public transient boolean noItem;
    public boolean canShootFromDispenser = true;

    public ProjectileAnimatableJSBuilder(ResourceLocation i) {
        super(i);
        this.facesTrajectory = true;
        this.item = (ProjectileItemBuilder)new ProjectileItemBuilder(this.id, this).canThrow(true).texture(i.getNamespace() + ":item/" + i.getPath());
    }

    @Info(value="Sets whether or not the projectile can be shot from dispenser blocks, if noItem is set to true this will not register DispenserBehavior.")
    public ProjectileAnimatableJSBuilder setCanShootFromDispenser(boolean canShootFromDispenser) {
        this.canShootFromDispenser = canShootFromDispenser;
        return this;
    }

    @Override
    public EntityType.EntityFactory<ProjectileAnimatableJS> factory() {
        return (type, level) -> new ProjectileAnimatableJS(this, (EntityType<? extends ThrowableItemProjectile>)type, level);
    }

    @Override
    public AttributeSupplier.Builder getAttributeBuilder() {
        return null;
    }

    @Info(value="Indicates that no projectile item should be created for this entity type")
    public ProjectileAnimatableJSBuilder noItem() {
        this.noItem = true;
        return this;
    }

    @Info(value="Creates the arrow item for this entity type")
    public ProjectileAnimatableJSBuilder item(Consumer<ProjectileItemBuilder> item) {
        this.item = new ProjectileItemBuilder(this.id, this);
        item.accept(this.item);
        return this;
    }

    public void createAdditionalObjects(AdditionalObjectRegistry registry) {
        if (!this.noItem) {
            registry.add(Registries.ITEM, (BuilderBase)this.item);
            projectileItems.put((EntityType)this.get(), (Item)this.item.get());
        }
    }

    @Override
    public EntityType<ProjectileAnimatableJS> createObject() {
        return new EntityTypeBuilder(this).get();
    }

    @Info(value="Sets a callback function to be executed when the projectile\ncollides with an entity.\n\nExample usage:\n```javascript\narrowEntityBuilder.onEntityCollision(context => {\n    const { entity, target } = context\n    console.log(entity)\n});\n```\n")
    public ProjectileAnimatableJSBuilder onEntityCollision(Consumer<ContextUtils.CollidingProjectileEntityContext> consumer) {
        this.onEntityCollision = consumer;
        return this;
    }

    @Info(value="Sets a callback function to be executed when the projectile hits an entity.\nThe provided Consumer accepts a {@link ContextUtils.ProjectileEntityHitContext} parameter,\nrepresenting the context of the projectile's interaction with a specific entity.\n\nExample usage:\n```javascript\nprojectileBuilder.onHitEntity(context -> {\n    // Custom logic to handle the projectile hitting an entity.\n    // Access information about the entity and projectile using the provided context.\n});\n```\n")
    public ProjectileAnimatableJSBuilder onHitEntity(Consumer<ContextUtils.ProjectileEntityHitContext> consumer) {
        this.onHitEntity = consumer;
        return this;
    }

    @Info(value="Sets a callback function to be executed when the projectile hits a block.\nThe provided Consumer accepts a {@link ContextUtils.ProjectileBlockHitContext} parameter,\nrepresenting the context of the projectile's interaction with a specific block.\n\nExample usage:\n```javascript\nprojectileBuilder.onHitBlock(context -> {\n    // Custom logic to handle the projectile hitting a block.\n    // Access information about the block and projectile using the provided context.\n});\n```\n")
    public ProjectileAnimatableJSBuilder onHitBlock(Consumer<ContextUtils.ProjectileBlockHitContext> consumer) {
        this.onHitBlock = consumer;
        return this;
    }

    @Info(value="Sets a function to determine if the projectile entity can hit a specific entity.\n\n@param canHitEntity The predicate to check if the arrow can hit the entity.\n\nExample usage:\n```javascript\nprojectileEntityBuilder.canHitEntity(entity -> {\n    // Custom logic to determine if the projectile can hit the specified entity\n    // Return true if the arrow can hit, false otherwise.\n});\n```\n")
    public ProjectileAnimatableJSBuilder canHitEntity(Predicate<Entity> function) {
        this.canHitEntity = function;
        return this;
    }
}

