/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.living.vanilla;

import com.mojang.serialization.Dynamic;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.Cast;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.builders.living.vanilla.ParrotJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.entities.living.entityjs.TameableMobJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntityJS;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ParrotEntityJS
extends Parrot
implements IAnimatableJS {
    private final AnimatableInstanceCache getAnimatableInstanceCache;
    protected final ParrotJSBuilder builder;
    private final PartEntityJS<?>[] partEntities;
    protected boolean thisJumping = false;

    public String entityName() {
        return this.getType().toString();
    }

    public ParrotEntityJS(ParrotJSBuilder builder, EntityType<? extends Parrot> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.getAnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        ArrayList<PartEntityJS<ParrotEntityJS>> tempPartEntities = new ArrayList<PartEntityJS<ParrotEntityJS>>();
        for (ContextUtils.PartEntityParams params : builder.partEntityParamsList) {
            PartEntityJS<ParrotEntityJS> partEntity = new PartEntityJS<ParrotEntityJS>(this, params.name, params.width, params.height, params.builder);
            tempPartEntities.add(partEntity);
        }
        this.partEntities = tempPartEntities.toArray(new PartEntityJS[0]);
        this.navigation = this.createNavigation(pLevel);
        this.lookControl = this.createLookControl();
        this.moveControl = this.createMoveControl();
        this.jumpControl = this.createJumpControl();
    }

    private MoveControl createMoveControl() {
        if (this.builder.setMoveControl != null) {
            Object obj = this.builder.setMoveControl.apply(this);
            if (obj != null) {
                return (MoveControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMoveControl from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a MoveControl object. Defaulting to super method.");
        }
        return this.moveControl;
    }

    private LookControl createLookControl() {
        if (this.builder.setLookControl != null) {
            Object obj = this.builder.setLookControl.apply(this);
            if (obj != null) {
                return (LookControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setLookControl from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a LookControl object. Defaulting to super method.");
        }
        return this.lookControl;
    }

    private JumpControl createJumpControl() {
        if (this.builder.setJumpControl != null) {
            Object obj = this.builder.setJumpControl.apply(this);
            if (obj != null) {
                return (JumpControl)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setJumpControl from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a JumpControl object. Defaulting to super method.");
        }
        return this.jumpControl;
    }

    public void setId(int entityId) {
        super.setId(entityId);
        for (int i = 0; i < this.partEntities.length; ++i) {
            PartEntityJS<?> partEntity = this.partEntities[i];
            if (partEntity == null) continue;
            partEntity.setId(entityId + i + 1);
        }
    }

    public void tickPart(String partName, double offsetX, double offsetY, double offsetZ) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        for (PartEntityJS<?> partEntity : this.partEntities) {
            if (!partEntity.name.equals(partName)) continue;
            partEntity.movePart(x + offsetX, y + offsetY, z + offsetZ, partEntity.getYRot(), partEntity.getXRot());
            return;
        }
        EntityJSHelperClass.logWarningMessageOnce("Part with name " + partName + " not found for entity: " + this.entityName());
    }

    public boolean isMultipartEntity() {
        return this.partEntities != null;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
    }

    public PartEntity<?>[] getParts() {
        return Objects.requireNonNullElseGet(this.partEntities, () -> new PartEntity[0]);
    }

    @Override
    public BaseLivingEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.getAnimatableInstanceCache;
    }

    public Brain.Provider<?> brainProvider() {
        if (EventHandlers.buildBrainProvider.hasListeners()) {
            BuildBrainProviderEventJS event = new BuildBrainProviderEventJS();
            EventHandlers.buildBrainProvider.post(event, (Object)this.getTypeId());
            return event.provide();
        }
        return super.brainProvider();
    }

    protected Brain<ParrotEntityJS> makeBrain(Dynamic<?> p_21069_) {
        if (EventHandlers.buildBrain.hasListeners()) {
            Brain brain = (Brain)Cast.to((Object)this.brainProvider().makeBrain(p_21069_));
            EventHandlers.buildBrain.post(new BuildBrainEventJS(brain), (Object)this.getTypeId());
            return brain;
        }
        return (Brain)Cast.to((Object)super.makeBrain(p_21069_));
    }

    protected void registerGoals() {
        if (EventHandlers.addGoalTargets.hasListeners()) {
            EventHandlers.addGoalTargets.post(new AddGoalTargetsEventJS<ParrotEntityJS>(this, this.targetSelector), (Object)this.getTypeId());
        }
        if (EventHandlers.addGoalSelectors.hasListeners()) {
            EventHandlers.addGoalSelectors.post(new AddGoalSelectorsEventJS<ParrotEntityJS>(this, this.goalSelector), (Object)this.getTypeId());
        }
    }

    public boolean tamableFood(ItemStack pStack) {
        boolean isTamableFoodPredicate;
        if (this.builder.tamableFood == null && this.builder.tamableFoodPredicate == null) {
            return this.isFood(pStack);
        }
        boolean isTamableFood = this.builder.tamableFood != null && this.builder.tamableFood.test(pStack);
        boolean bl = isTamableFoodPredicate = this.builder.tamableFoodPredicate != null && this.tamableFoodPredicate(pStack);
        return isTamableFood || isTamableFoodPredicate;
    }

    public boolean tamableFoodPredicate(ItemStack pStack) {
        if (this.builder.tamableFoodPredicate == null) {
            return false;
        }
        ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(pStack, (LivingEntity)this);
        Boolean obj = this.builder.tamableFoodPredicate.test(context);
        if (obj instanceof Boolean) {
            Boolean b = obj;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for tamableFoodPredicate from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to false.");
        return false;
    }

    public void tame(Player pPlayer) {
        ContextUtils.PlayerEntityContext context;
        if (this.builder.tameOverride != null) {
            this.setTame(true, true);
            context = new ContextUtils.PlayerEntityContext(pPlayer, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.tameOverride, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: tameOverride.");
            if (pPlayer instanceof ServerPlayer) {
                CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)pPlayer, (Animal)this);
            }
        } else {
            super.tame(pPlayer);
        }
        if (this.builder.onTamed != null) {
            context = new ContextUtils.PlayerEntityContext(pPlayer, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onTamed, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onTamed.");
        }
    }

    public boolean wantsToAttack(LivingEntity pTarget, LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof Ghast)) {
            if (pTarget instanceof TameableMobJS) {
                TameableMobJS mobjs = (TameableMobJS)pTarget;
                return !mobjs.isTame() || mobjs.getOwner() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).canHarmPlayer((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).isTamed()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).isTame();
        }
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        if (this.builder.setBreedOffspring != null) {
            ResourceLocation resourceLocation;
            EntityType breedOffspringType;
            ContextUtils.BreedableEntityContext context = new ContextUtils.BreedableEntityContext((AgeableMob)this, ageableMob, serverLevel);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBreedOffspring.apply(context), "resourcelocation");
            if (obj instanceof ResourceLocation && (breedOffspringType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation = (ResourceLocation)obj)) != null) {
                Entity breedOffspringEntity = breedOffspringType.create((Level)serverLevel);
                if (breedOffspringEntity instanceof TamableAnimal) {
                    TamableAnimal animal = (TamableAnimal)breedOffspringEntity;
                    UUID uuid = this.getOwnerUUID();
                    if (uuid != null) {
                        animal.setOwnerUUID(uuid);
                        animal.setTame(true, true);
                    }
                    return (AgeableMob)breedOffspringEntity;
                }
                if (breedOffspringEntity instanceof AgeableMob) {
                    return (AgeableMob)breedOffspringEntity;
                }
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid resource location or Entity Type for breedOffspring: " + String.valueOf(obj) + ". Must return a TamableAnimal/AgableMob ResourceLocation. Defaulting to super method: " + String.valueOf(this.builder.get()));
        }
        return (AgeableMob)((EntityType)this.builder.get()).create((Level)serverLevel);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.setOrderedToSit(false);
        }
        return super.hurt(pSource, pAmount);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326347_) {
        super.defineSynchedData(p_326347_);
    }

    protected void spawnTamingParticles(boolean pTamed) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!pTamed) {
            particleoptions = ParticleTypes.SMOKE;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)particleoptions, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public boolean isFood(ItemStack pStack) {
        return this.builder.isFood != null && this.builder.isFood.test(pStack) || this.isFoodPredicate(pStack);
    }

    public boolean isFoodPredicate(ItemStack pStack) {
        if (this.builder.isFoodPredicate == null) {
            return pStack.is(ItemTags.PARROT_FOOD);
        }
        ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(pStack, (LivingEntity)this);
        Boolean obj = this.builder.isFoodPredicate.test(context);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFoodPredicate from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + pStack.is(ItemTags.PARROT_FOOD));
        return pStack.is(ItemTags.PARROT_FOOD);
    }

    public boolean canBreed() {
        if (this.builder.canBreed == null) {
            return super.canBreed();
        }
        Boolean obj = this.builder.canBreed.test(this);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBreed from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.canBreed());
        return super.canBreed();
    }

    public boolean canMate(Animal pOtherAnimal) {
        if (this.builder.canMate == null) {
            return super.canMate(pOtherAnimal);
        }
        ContextUtils.EntityAnimalContext context = new ContextUtils.EntityAnimalContext((Animal)this, pOtherAnimal);
        Boolean obj = this.builder.canMate.test(context);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canMate from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canMate(pOtherAnimal));
        return super.canMate(pOtherAnimal);
    }

    public void spawnChildFromBreeding(ServerLevel pLevel, Animal pMate) {
        if (this.builder.onSpawnChildFromBreeding != null) {
            ContextUtils.LevelAnimalContext context = new ContextUtils.LevelAnimalContext(pMate, (Animal)this, pLevel);
            EntityJSHelperClass.consumerCallback(this.builder.onSpawnChildFromBreeding, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSpawnChildFromBreeding.");
            super.spawnChildFromBreeding(pLevel, pMate);
        } else {
            super.spawnChildFromBreeding(pLevel, pMate);
        }
    }

    private InteractionResult superMobInteract(Player p_27584_, InteractionHand p_27585_) {
        ItemStack itemstack = p_27584_.getItemInHand(p_27585_);
        if (this.isFood(itemstack)) {
            int i = this.getAge();
            if (!this.level().isClientSide && i == 0 && this.canFallInLove()) {
                this.usePlayerItem(p_27584_, p_27585_, itemstack);
                this.setInLove(p_27584_);
                return InteractionResult.SUCCESS;
            }
            if (this.isBaby()) {
                this.usePlayerItem(p_27584_, p_27585_, itemstack);
                this.ageUp(ParrotEntityJS.getSpeedUpSecondsWhenFeeding((int)(-i)), true);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        if (this.builder.onInteract != null) {
            ContextUtils.MobInteractContext context = new ContextUtils.MobInteractContext((LivingEntity)this, pPlayer, pHand);
            EntityJSHelperClass.consumerCallback(this.builder.onInteract, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onInteract.");
        }
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!this.isTame() && this.tamableFood(itemstack)) {
            itemstack.consume(1, (LivingEntity)pPlayer);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PARROT_EAT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            }
            if (!this.level().isClientSide) {
                if (this.random.nextInt(10) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)pPlayer)) {
                    this.tame(pPlayer);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (!itemstack.is(ItemTags.PARROT_POISONOUS_FOOD)) {
            if (!this.isFlying() && this.isTame() && this.isOwnedBy((LivingEntity)pPlayer)) {
                if (!this.level().isClientSide) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            return this.superMobInteract(pPlayer, pHand);
        }
        itemstack.consume(1, (LivingEntity)pPlayer);
        this.addEffect(new MobEffectInstance(MobEffects.POISON, 900));
        if (pPlayer.isCreative() || !this.isInvulnerable()) {
            this.hurt(this.damageSources().playerAttack(pPlayer), Float.MAX_VALUE);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    public boolean doHurtTarget(Entity pEntity) {
        if (this.builder != null && this.builder.onHurtTarget != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHurtTarget, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurtTarget.");
        }
        return super.doHurtTarget(pEntity);
    }

    public void onJump() {
        if (this.builder.onLivingJump != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onLivingJump, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingJump.");
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.canJump() && this.onGround() && this.getNavigation().isInProgress() && this.shouldJump()) {
            this.jump();
        }
        if (this.builder.aiStep != null) {
            EntityJSHelperClass.consumerCallback(this.builder.aiStep, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: aiStep.");
        }
    }

    protected void tickDeath() {
        if (this.builder.tickDeath != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tickDeath, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tickDeath.");
        } else {
            super.tickDeath();
        }
    }

    public void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        if (this.builder.onTargetChanged != null) {
            ContextUtils.TargetChangeContext context = new ContextUtils.TargetChangeContext(target, (Mob)this);
            EntityJSHelperClass.consumerCallback(this.builder.onTargetChanged, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onTargetChanged.");
        }
    }

    public void ate() {
        super.ate();
        if (this.builder.ate != null) {
            EntityJSHelperClass.consumerCallback(this.builder.ate, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: ate.");
        }
    }

    protected PathNavigation createNavigation(Level pLevel) {
        if (this.builder == null || this.builder.createNavigation == null) {
            return super.createNavigation(pLevel);
        }
        ContextUtils.EntityLevelContext context = new ContextUtils.EntityLevelContext(pLevel, (LivingEntity)this);
        Object obj = this.builder.createNavigation.apply(context);
        if (obj instanceof PathNavigation) {
            PathNavigation p = (PathNavigation)obj;
            return p;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for createNavigation from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be PathNavigation. Defaulting to super method.");
        return super.createNavigation(pLevel);
    }

    public boolean canBeLeashed() {
        if (this.builder.canBeLeashed != null) {
            Boolean obj = this.builder.canBeLeashed.test(this);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeLeashed from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canBeLeashed());
        }
        return super.canBeLeashed();
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        if (this.builder.removeWhenFarAway == null) {
            return super.removeWhenFarAway(pDistanceToClosestPlayer);
        }
        ContextUtils.EntityDistanceToPlayerContext context = new ContextUtils.EntityDistanceToPlayerContext(pDistanceToClosestPlayer, (LivingEntity)this);
        Boolean obj = this.builder.removeWhenFarAway.test(context);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for removeWhenFarAway from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.removeWhenFarAway(pDistanceToClosestPlayer));
        return super.removeWhenFarAway(pDistanceToClosestPlayer);
    }

    protected double followLeashSpeed() {
        return Objects.requireNonNullElseGet(this.builder.followLeashSpeed, () -> super.followLeashSpeed());
    }

    public int getAmbientSoundInterval() {
        if (this.builder.ambientSoundInterval != null) {
            return (Integer)this.builder.ambientSoundInterval;
        }
        return super.getAmbientSoundInterval();
    }

    public boolean canJump() {
        return Objects.requireNonNullElse(this.builder.canJump, true);
    }

    public void jump() {
        double jumpPower = this.getJumpPower() + this.getJumpBoostPower();
        Vec3 currentVelocity = this.getDeltaMovement();
        this.setDeltaMovement(currentVelocity.x, jumpPower, currentVelocity.z);
        this.hasImpulse = true;
        if (this.isSprinting()) {
            float yawRadians = this.getYRot() * ((float)Math.PI / 180);
            this.setDeltaMovement(this.getDeltaMovement().add(-Math.sin(yawRadians) * 0.2, 0.0, Math.cos(yawRadians) * 0.2));
        }
        this.hasImpulse = true;
        this.onJump();
        CommonHooks.onLivingJump((LivingEntity)this);
    }

    public boolean shouldJump() {
        BlockPos forwardPos = this.blockPosition().relative(this.getDirection());
        return this.level().loadedAndEntityCanStandOn(forwardPos, (Entity)this) && (double)this.maxUpStep() < this.level().getBlockState(forwardPos).getShape((BlockGetter)this.level(), forwardPos).max(Direction.Axis.Y);
    }

    public HumanoidArm getMainArm() {
        if (this.builder.mainArm != null) {
            return (HumanoidArm)this.builder.mainArm;
        }
        return super.getMainArm();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader levelReader) {
        if (this.builder.walkTargetValue == null) {
            return super.getWalkTargetValue(pos, levelReader);
        }
        ContextUtils.EntityBlockPosLevelContext context = new ContextUtils.EntityBlockPosLevelContext(pos, levelReader, (LivingEntity)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.walkTargetValue.apply(context), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for walkTargetValue from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.walkTargetValue.apply(context)) + ". Must be a float. Defaulting to " + super.getWalkTargetValue(pos, levelReader));
        return super.getWalkTargetValue(pos, levelReader);
    }

    protected boolean shouldStayCloseToLeashHolder() {
        if (this.builder.shouldStayCloseToLeashHolder == null) {
            return super.shouldStayCloseToLeashHolder();
        }
        Boolean value = this.builder.shouldStayCloseToLeashHolder.test(this);
        if (value instanceof Boolean) {
            Boolean b = value;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldStayCloseToLeashHolder from entity: " + this.entityName() + ". Value: " + String.valueOf(value) + ". Must be a boolean. Defaulting to " + super.shouldStayCloseToLeashHolder());
        return super.shouldStayCloseToLeashHolder();
    }

    public boolean canFireProjectileWeaponPredicate(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeaponPredicate != null) {
            ContextUtils.EntityProjectileWeaponContext context = new ContextUtils.EntityProjectileWeaponContext(projectileWeapon, (LivingEntity)this);
            Boolean obj = this.builder.canFireProjectileWeaponPredicate.test(context);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFireProjectileWeaponPredicate from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to false.");
        }
        return false;
    }

    public boolean canFireProjectileWeapons(ProjectileWeaponItem projectileWeapon) {
        if (this.builder.canFireProjectileWeapon != null) {
            return this.builder.canFireProjectileWeapon.test(projectileWeapon.getDefaultInstance()) && projectileWeapon instanceof ProjectileWeaponItem;
        }
        return super.canFireProjectileWeapon(projectileWeapon);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem projectileWeapon) {
        if (this.canFireProjectileWeapons(projectileWeapon) || this.canFireProjectileWeaponPredicate(projectileWeapon)) {
            return this.canFireProjectileWeapons(projectileWeapon) && this.canFireProjectileWeaponPredicate(projectileWeapon);
        }
        return super.canFireProjectileWeapon(projectileWeapon);
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        if (this.builder.setAmbientSound != null) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setAmbientSound);
        }
        return super.getAmbientSound();
    }

    public boolean canHoldItem(ItemStack stack) {
        if (this.builder.canHoldItem != null) {
            ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(stack, (LivingEntity)this);
            Boolean obj = this.builder.canHoldItem.test(context);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canHoldItem from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canHoldItem(stack));
        }
        return super.canHoldItem(stack);
    }

    protected boolean shouldDespawnInPeaceful() {
        return Objects.requireNonNullElseGet(this.builder.shouldDespawnInPeaceful, () -> super.shouldDespawnInPeaceful());
    }

    public boolean isPersistenceRequired() {
        return Objects.requireNonNullElseGet(this.builder.isPersistenceRequired, () -> super.isPersistenceRequired());
    }

    public AABB getAttackBoundingBox() {
        if (this.builder.getAttackBoundingBox != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.getAttackBoundingBox.apply(this), "aabb");
            if (obj != null) {
                return (AABB)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for getAttackBoundingBox from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.getAttackBoundingBox.apply(this)) + ". Must be an AABB. Defaulting to " + String.valueOf(super.getAttackBoundingBox()));
        }
        return super.getAttackBoundingBox();
    }

    public boolean isAlliedTo(Entity pEntity) {
        if (this.builder.isAlliedTo != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (LivingEntity)this);
            try {
                Boolean obj = this.builder.isAlliedTo.test(context);
                if (obj instanceof Boolean) {
                    Boolean b = obj;
                    return b;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAlliedTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isAlliedTo(pEntity));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Invalid return value for isAlliedTo from entity: " + this.entityName() + ". Must be a boolean. Defaulting to " + super.isAlliedTo(pEntity), e);
                return super.isAlliedTo(pEntity);
            }
        }
        return super.isAlliedTo(pEntity);
    }

    public void travel(Vec3 pTravelVector) {
        LivingEntity livingentity = this.getControllingPassenger();
        if (this.isAlive() && this.isVehicle() && this.builder.canSteer.booleanValue() && livingentity != null) {
            if (this.getControllingPassenger() instanceof Player && this.builder.mountJumpingEnabled) {
                if (this.ableToJump()) {
                    this.setThisJumping(true);
                }
                if (this.thisJumping) {
                    this.setThisJumping(false);
                    double jumpPower = this.getJumpPower() + this.getJumpBoostPower();
                    Vec3 currentVelocity = this.getDeltaMovement();
                    double newVelocityX = currentVelocity.x;
                    double newVelocityY = currentVelocity.y + jumpPower;
                    double newVelocityZ = currentVelocity.z;
                    this.setDeltaMovement(newVelocityX, newVelocityY, newVelocityZ);
                    this.onJump();
                    CommonHooks.onLivingJump((LivingEntity)this);
                }
            }
            LivingEntity passenger = this.getControllingPassenger();
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
            this.setYRot(passenger.getYRot());
            this.setXRot(passenger.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            float x = passenger.xxa * 0.5f;
            float z = passenger.zza;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
            super.travel(new Vec3((double)x, pTravelVector.y, (double)z));
        } else {
            super.travel(pTravelVector);
        }
        if (this.builder.travel != null) {
            ContextUtils.Vec3Context context = new ContextUtils.Vec3Context(pTravelVector, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.travel, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: travel.");
        }
    }

    public void tick() {
        super.tick();
        if (this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.builder.defaultGoals.booleanValue()) {
            super.registerGoals();
        }
        if (this.builder.onAddedToWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    protected void doAutoAttackOnTouch(@NotNull LivingEntity target) {
        super.doAutoAttackOnTouch(target);
        if (this.builder.doAutoAttackOnTouch != null) {
            ContextUtils.AutoAttackContext context = new ContextUtils.AutoAttackContext((LivingEntity)this, target);
            EntityJSHelperClass.consumerCallback(this.builder.doAutoAttackOnTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: doAutoAttackOnTouch.");
        }
    }

    protected int decreaseAirSupply(int p_21303_) {
        if (this.builder.onDecreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onDecreaseAirSupply, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply.");
        }
        return super.decreaseAirSupply(p_21303_);
    }

    protected int increaseAirSupply(int p_21307_) {
        if (this.builder.onIncreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onIncreaseAirSupply, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onIncreaseAirSupply.");
        }
        return super.increaseAirSupply(p_21307_);
    }

    protected void blockedByShield(@NotNull LivingEntity p_21246_) {
        super.blockedByShield(p_21246_);
        if (this.builder.onBlockedByShield != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, p_21246_);
            EntityJSHelperClass.consumerCallback(this.builder.onBlockedByShield, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply.");
        }
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack previous, ItemStack current) {
        super.onEquipItem(slot, previous, current);
        if (this.builder.onEquipItem != null) {
            ContextUtils.EntityEquipmentContext context = new ContextUtils.EntityEquipmentContext(slot, previous, current, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEquipItem, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEquipItem.");
        }
    }

    public void onEffectAdded(@NotNull MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (this.builder.onEffectAdded != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEffectAdded, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectAdded.");
        } else {
            super.onEffectAdded(effectInstance, entity);
        }
    }

    protected void onEffectRemoved(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.onEffectRemoved != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEffectRemoved, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectRemoved.");
        } else {
            super.onEffectRemoved(effectInstance);
        }
    }

    public void heal(float amount) {
        super.heal(amount);
        if (this.builder.onLivingHeal != null) {
            ContextUtils.EntityHealContext context = new ContextUtils.EntityHealContext((LivingEntity)this, amount);
            EntityJSHelperClass.consumerCallback(this.builder.onLivingHeal, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingHeal.");
        }
    }

    public void die(@NotNull DamageSource damageSource) {
        super.die(damageSource);
        if (this.builder.onDeath != null) {
            ContextUtils.DeathContext context = new ContextUtils.DeathContext((LivingEntity)this, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onDeath, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDeath.");
        }
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean allowDrops) {
        if (this.builder.dropCustomDeathLoot != null) {
            ContextUtils.EntityLootContext context = new ContextUtils.EntityLootContext(serverLevel, damageSource, allowDrops, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.dropCustomDeathLoot, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: dropCustomDeathLoot.");
        } else {
            super.dropCustomDeathLoot(serverLevel, damageSource, allowDrops);
        }
    }

    protected void onFlap() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.onFlap();
    }

    public boolean ableToJump() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.getInstance().options.keyJump.isDown() && this.onGround();
        }
        return false;
    }

    public void setThisJumping(boolean value) {
        this.thisJumping = value;
    }

    public LivingEntity getControllingPassenger() {
        LivingEntity entity;
        Entity var2 = this.getFirstPassenger();
        LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
        return var10000;
    }

    @Info(value="Calls a triggerable animation to be played anywhere.\n")
    public void triggerAnimation(String controllerName, String animName) {
        this.triggerAnim(controllerName, animName);
    }

    public boolean canCollideWith(Entity pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.CollidingEntityContext context = new ContextUtils.CollidingEntityContext((LivingEntity)this, pEntity);
            try {
                Boolean obj = this.builder.canCollideWith.test(context);
                if (obj instanceof Boolean) {
                    Boolean b = obj;
                    return b;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canCollideWith(pEntity));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canCollideWith. Defaulting to " + super.canCollideWith(pEntity), e);
                return super.canCollideWith(pEntity);
            }
        }
        return super.canCollideWith(pEntity);
    }

    protected float getBlockSpeedFactor() {
        if (this.builder.blockSpeedFactor != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + String.valueOf(this.builder.get()) + ". Value: " + String.valueOf(this.builder.blockSpeedFactor.apply(this)) + ". Must be a float. Defaulting to " + super.getBlockSpeedFactor());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: blockSpeedFactor. Defaulting to " + super.getBlockSpeedFactor(), e);
            }
        }
        return super.getBlockSpeedFactor();
    }

    protected float getBlockJumpFactor() {
        if (this.builder.setBlockJumpFactor != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setBlockJumpFactor.apply(this)) + ". Must be a float. Defaulting to " + super.getBlockJumpFactor());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: setBlockJumpFactor. Defaulting to " + super.getBlockJumpFactor(), e);
            }
        }
        return super.getBlockJumpFactor();
    }

    protected boolean canAddPassenger(@NotNull Entity entity) {
        if (this.builder.canAddPassenger != null) {
            ContextUtils.PassengerEntityContext context = new ContextUtils.PassengerEntityContext(entity, (LivingEntity)this);
            try {
                Boolean obj = this.builder.canAddPassenger.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.canAddPassenger(entity));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canAddPassenger. Defaulting to " + super.canAddPassenger(entity), e);
            }
        }
        return super.canAddPassenger(entity);
    }

    protected boolean shouldDropLoot() {
        if (this.builder.shouldDropLoot != null) {
            try {
                Boolean obj = this.builder.shouldDropLoot.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropLoot from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + super.shouldDropLoot());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: shouldDropLoot. Defaulting to " + super.shouldDropLoot(), e);
            }
        }
        return super.shouldDropLoot();
    }

    protected boolean isAffectedByFluids() {
        if (this.builder.isAffectedByFluids != null) {
            try {
                Boolean obj = this.builder.isAffectedByFluids.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByFluids from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isAffectedByFluids());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isAffectedByFluids. Defaulting to " + super.isAffectedByFluids(), e);
            }
        }
        return super.isAffectedByFluids();
    }

    protected boolean isImmobile() {
        if (this.builder.isImmobile != null) {
            try {
                Boolean obj = this.builder.isImmobile.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isImmobile from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isImmobile());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isImmobile. Defaulting to " + super.isImmobile(), e);
            }
        }
        return super.isImmobile();
    }

    protected boolean isFlapping() {
        if (this.builder.isFlapping != null) {
            try {
                Boolean obj = this.builder.isFlapping.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFlapping());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isFlapping. Defaulting to " + super.isFlapping(), e);
            }
        }
        return super.isFlapping();
    }

    public int calculateFallDamage(float fallDistance, float pDamageMultiplier) {
        if (this.builder.calculateFallDamage != null) {
            ContextUtils.CalculateFallDamageContext context = new ContextUtils.CalculateFallDamageContext(fallDistance, pDamageMultiplier, (LivingEntity)this);
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.calculateFallDamage.apply(context), "integer");
                if (obj != null) {
                    return (Integer)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for calculateFallDamage from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.calculateFallDamage.apply(context)) + ". Must be an int, defaulting to " + super.calculateFallDamage(fallDistance, pDamageMultiplier));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: calculateFallDamage. Defaulting to " + super.calculateFallDamage(fallDistance, pDamageMultiplier), e);
            }
        }
        return super.calculateFallDamage(fallDistance, pDamageMultiplier);
    }

    protected float nextStep() {
        if (this.builder.nextStep != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.nextStep.apply(this)) + ". Must be a float, defaulting to " + super.nextStep());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: nextStep. Defaulting to " + super.nextStep(), e);
            }
        }
        return super.nextStep();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource p_21239_) {
        if (this.builder.setHurtSound != null) {
            ContextUtils.HurtContext context = new ContextUtils.HurtContext((LivingEntity)this, p_21239_);
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setHurtSound.apply(context), "resourcelocation");
                if (obj != null) {
                    return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)obj));
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setHurtSound from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setHurtSound.apply(context)) + ". Must be a ResourceLocation or String. Defaulting to \"minecraft:entity.generic.hurt\"");
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: setHurtSound. Defaulting to \"minecraft:entity.generic.hurt\"", e);
            }
        }
        return super.getHurtSound(p_21239_);
    }

    public boolean canAttackType(@NotNull EntityType<?> entityType) {
        if (this.builder.canAttackType != null) {
            ContextUtils.EntityTypeEntityContext context = new ContextUtils.EntityTypeEntityContext((LivingEntity)this, entityType);
            try {
                Boolean obj = this.builder.canAttackType.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttackType from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canAttackType(entityType));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canAttackType. Defaulting to " + super.canAttackType(entityType), e);
            }
        }
        return super.canAttackType(entityType);
    }

    public float getScale() {
        if (this.builder.scale != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.scale.apply(this), "float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for scale from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.scale.apply(this)) + ". Must be a float. Defaulting to " + super.getScale());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: scale. Defaulting to " + super.getScale(), e);
            }
        }
        return super.getScale();
    }

    public boolean shouldDropExperience() {
        if (this.builder.shouldDropExperience != null) {
            try {
                Boolean obj = this.builder.shouldDropExperience.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropExperience from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.shouldDropExperience());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: shouldDropExperience. Defaulting to " + super.shouldDropExperience(), e);
            }
        }
        return super.shouldDropExperience();
    }

    public double getVisibilityPercent(@Nullable Entity p_20969_) {
        if (this.builder.visibilityPercent != null) {
            ContextUtils.VisualContext context = new ContextUtils.VisualContext(p_20969_, (LivingEntity)this);
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.visibilityPercent.apply(context), "double");
                if (obj != null) {
                    return (Double)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for visibilityPercent from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.visibilityPercent.apply(context)) + ". Must be a double. Defaulting to " + super.getVisibilityPercent(p_20969_));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: visibilityPercent. Defaulting to " + super.getVisibilityPercent(p_20969_), e);
            }
        }
        return super.getVisibilityPercent(p_20969_);
    }

    public boolean canAttack(@NotNull LivingEntity entity) {
        if (this.builder.canAttack != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((LivingEntity)this, entity);
            try {
                Boolean obj = this.builder.canAttack.test(context);
                if (obj instanceof Boolean) {
                    return obj != false && super.canAttack(entity);
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttack from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canAttack(entity));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canAttack. Defaulting to " + super.canAttack(entity), e);
            }
        }
        return super.canAttack(entity);
    }

    public boolean canBeAffected(@NotNull MobEffectInstance effectInstance) {
        if (this.builder.canBeAffected != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (LivingEntity)this);
            try {
                Boolean result = this.builder.canBeAffected.test(context);
                if (result instanceof Boolean) {
                    return result;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeAffected from entity: " + this.entityName() + ". Value: " + String.valueOf(result) + ". Must be a boolean. Defaulting to " + super.canBeAffected(effectInstance));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canBeAffected. Defaulting to " + super.canBeAffected(effectInstance), e);
            }
        }
        return super.canBeAffected(effectInstance);
    }

    public boolean isInvertedHealAndHarm() {
        if (this.builder.invertedHealAndHarm != null) {
            try {
                Boolean obj = this.builder.invertedHealAndHarm.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for invertedHealAndHarm from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvertedHealAndHarm());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: invertedHealAndHarm. Defaulting to " + super.isInvertedHealAndHarm(), e);
            }
        }
        return super.isInvertedHealAndHarm();
    }

    public boolean onClimbable() {
        if (this.builder.onClimbable != null) {
            try {
                Boolean obj = this.builder.onClimbable.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for onClimbable from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super.onClimbable(): " + super.onClimbable());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: onClimbable. Defaulting to " + super.onClimbable(), e);
            }
        }
        return super.onClimbable();
    }

    public float getJumpBoostPower() {
        if (this.builder.jumpBoostPower != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.jumpBoostPower.apply(this), "float");
                if (obj != null) {
                    return ((Float)obj).floatValue();
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for jumpBoostPower from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.jumpBoostPower.apply(this)) + ". Must be a float. Defaulting to " + super.getJumpBoostPower());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: jumpBoostPower. Defaulting to " + super.getJumpBoostPower(), e);
            }
        }
        return super.getJumpBoostPower();
    }

    public boolean canStandOnFluid(@NotNull FluidState fluidState) {
        if (this.builder.canStandOnFluid != null) {
            ContextUtils.EntityFluidStateContext context = new ContextUtils.EntityFluidStateContext((LivingEntity)this, fluidState);
            try {
                Boolean obj = this.builder.canStandOnFluid.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canStandOnFluid from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canStandOnFluid(fluidState));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canStandOnFluid. Defaulting to " + super.canStandOnFluid(fluidState), e);
            }
        }
        return super.canStandOnFluid(fluidState);
    }

    public boolean isSensitiveToWater() {
        if (this.builder.isSensitiveToWater != null) {
            try {
                Boolean obj = this.builder.isSensitiveToWater.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSensitiveToWater from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isSensitiveToWater());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isSensitiveToWater. Defaulting to " + super.isSensitiveToWater(), e);
            }
        }
        return super.isSensitiveToWater();
    }

    public boolean hasLineOfSight(@NotNull Entity entity) {
        if (this.builder.hasLineOfSight != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(entity, (LivingEntity)this);
            try {
                Boolean obj = this.builder.hasLineOfSight.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for hasLineOfSight from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.hasLineOfSight(entity));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: hasLineOfSight. Defaulting to " + super.hasLineOfSight(entity), e);
            }
        }
        return super.hasLineOfSight(entity);
    }

    public boolean isAffectedByPotions() {
        if (this.builder.isAffectedByPotions != null) {
            try {
                Boolean obj = this.builder.isAffectedByPotions.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByPotions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isAffectedByPotions());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isAffectedByPotions. Defaulting to " + super.isAffectedByPotions(), e);
            }
        }
        return super.isAffectedByPotions();
    }

    public boolean attackable() {
        if (this.builder.isAttackable != null) {
            try {
                Boolean obj = this.builder.isAttackable.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.attackable());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isAttackable. Defaulting to " + super.attackable(), e);
            }
        }
        return super.attackable();
    }

    public boolean canTakeItem(@NotNull ItemStack itemStack) {
        if (this.builder.canTakeItem != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((LivingEntity)this, itemStack, this.level());
            try {
                Boolean obj = this.builder.canTakeItem.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTakeItem from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTakeItem(itemStack));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canTakeItem. Defaulting to " + super.canTakeItem(itemStack), e);
            }
        }
        return super.canTakeItem(itemStack);
    }

    public boolean isSleeping() {
        if (this.builder.isSleeping != null) {
            try {
                Boolean obj = this.builder.isSleeping.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSleeping from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isSleeping());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isSleeping. Defaulting to " + super.isSleeping(), e);
            }
        }
        return super.isSleeping();
    }

    public boolean shouldRiderFaceForward(@NotNull Player player) {
        if (this.builder.shouldRiderFaceForward != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(player, (LivingEntity)this);
            try {
                Boolean obj = this.builder.shouldRiderFaceForward.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldRiderFaceForward from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.shouldRiderFaceForward(player));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: shouldRiderFaceForward. Defaulting to " + super.shouldRiderFaceForward(player), e);
            }
        }
        return super.shouldRiderFaceForward(player);
    }

    public boolean canFreeze() {
        if (this.builder.canFreeze != null) {
            try {
                Boolean obj = this.builder.canFreeze.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canFreeze());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canFreeze. Defaulting to " + super.canFreeze(), e);
            }
        }
        return super.canFreeze();
    }

    public boolean isFreezing() {
        if (this.builder.isFreezing != null) {
            try {
                Boolean obj = this.builder.isFreezing.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isFreezing());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isFreezing. Defaulting to " + super.isFreezing(), e);
            }
        }
        return super.isFreezing();
    }

    public boolean isCurrentlyGlowing() {
        if (this.builder.isCurrentlyGlowing != null) {
            try {
                Boolean obj = this.builder.isCurrentlyGlowing.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isCurrentlyGlowing());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: isCurrentlyGlowing. Defaulting to " + super.isCurrentlyGlowing(), e);
            }
        }
        return super.isCurrentlyGlowing();
    }

    public boolean canDisableShield() {
        if (this.builder.canDisableShield != null) {
            try {
                Boolean obj = this.builder.canDisableShield.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canDisableShield from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canDisableShield());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canDisableShield. Defaulting to " + super.canDisableShield(), e);
            }
        }
        return super.canDisableShield();
    }

    protected int getBaseExperienceReward() {
        if (this.builder.experienceReward != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.experienceReward.apply(this), "integer");
                if (obj != null) {
                    return (Integer)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for experienceReward from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.experienceReward.apply(this)) + ". Must be an integer. Defaulting to " + super.getBaseExperienceReward());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: experienceReward. Defaulting to " + super.getBaseExperienceReward(), e);
            }
        }
        return super.getBaseExperienceReward();
    }

    public boolean dampensVibrations() {
        if (this.builder.dampensVibrations != null) {
            try {
                Boolean obj = this.builder.dampensVibrations.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.dampensVibrations());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: dampensVibrations. Defaulting to " + super.dampensVibrations(), e);
            }
        }
        return super.dampensVibrations();
    }

    public boolean showVehicleHealth() {
        if (this.builder.showVehicleHealth != null) {
            try {
                Boolean obj = this.builder.showVehicleHealth.test(this);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.showVehicleHealth());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: showVehicleHealth. Defaulting to " + super.showVehicleHealth(), e);
            }
        }
        return super.showVehicleHealth();
    }

    public boolean canChangeDimensions(Level to, Level from) {
        if (this.builder.canChangeDimensions != null) {
            ContextUtils.ChangeDimensionsContext context = new ContextUtils.ChangeDimensionsContext((Entity)this, to, from);
            try {
                Boolean obj = this.builder.canChangeDimensions.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canChangeDimensions(to, from));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canChangeDimensions. Defaulting to " + super.canChangeDimensions(to, from), e);
            }
        }
        return super.canChangeDimensions(to, from);
    }

    public boolean mayInteract(@NotNull Level p_146843_, @NotNull BlockPos p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.MayInteractContext context = new ContextUtils.MayInteractContext(p_146843_, p_146844_, (LivingEntity)this);
            try {
                Boolean obj = this.builder.mayInteract.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.mayInteract(p_146843_, p_146844_));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: mayInteract. Defaulting to " + super.mayInteract(p_146843_, p_146844_), e);
            }
        }
        return super.mayInteract(p_146843_, p_146844_);
    }

    public boolean canTrample(@NotNull BlockState state, @NotNull BlockPos pos, float fallDistance) {
        if (this.builder.canTrample != null) {
            ContextUtils.CanTrampleContext context = new ContextUtils.CanTrampleContext(state, pos, fallDistance, (LivingEntity)this);
            try {
                Boolean obj = this.builder.canTrample.test(context);
                if (obj instanceof Boolean) {
                    return obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canTrample(state, pos, fallDistance));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: canTrample. Defaulting to " + super.canTrample(state, pos, fallDistance), e);
            }
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public int getMaxFallDistance() {
        if (this.builder.setMaxFallDistance != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
                if (obj != null) {
                    return (Integer)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + String.valueOf(this.builder.setMaxFallDistance.apply(this)) + ". Must be an integer. Defaulting to " + super.getMaxFallDistance());
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Exception in " + this.entityName() + " builder for field: setMaxFallDistance. Defaulting to " + super.getMaxFallDistance(), e);
            }
        }
        return super.getMaxFallDistance();
    }

    protected float getSoundVolume() {
        return Objects.requireNonNullElseGet(this.builder.setSoundVolume, () -> Float.valueOf(super.getSoundVolume())).floatValue();
    }

    protected float getWaterSlowDown() {
        return Objects.requireNonNullElseGet(this.builder.setWaterSlowDown, () -> Float.valueOf(super.getWaterSlowDown())).floatValue();
    }

    public boolean isPushable() {
        return this.builder.isPushable;
    }

    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((Entity)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.positionRider(pPassenger, pCallback);
    }

    protected boolean isAlwaysExperienceDropper() {
        return this.builder.isAlwaysExperienceDropper;
    }

    protected boolean repositionEntityAfterLoad() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.repositionEntityAfterLoad());
    }

    protected SoundEvent getSwimSplashSound() {
        if (this.builder.setSwimSplashSound == null) {
            return super.getSwimSplashSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSplashSound));
    }

    protected SoundEvent getSwimSound() {
        if (this.builder.setSwimSound == null) {
            return super.getSwimSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setSwimSound));
    }

    protected SoundEvent getDeathSound() {
        if (this.builder.setDeathSound == null) {
            return super.getDeathSound();
        }
        return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.setDeathSound));
    }

    @NotNull
    public LivingEntity.Fallsounds getFallSounds() {
        if (this.builder.fallSounds != null) {
            return new LivingEntity.Fallsounds(Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.smallFallSound)), Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.largeFallSound)));
        }
        return super.getFallSounds();
    }

    @NotNull
    public SoundEvent getEatingSound(@NotNull ItemStack itemStack) {
        if (this.builder.eatingSound != null) {
            return Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)this.builder.eatingSound));
        }
        return super.getEatingSound(itemStack);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, @NotNull DamageSource damageSource) {
        if (this.builder.onLivingFall != null) {
            ContextUtils.EntityFallDamageContext context = new ContextUtils.EntityFallDamageContext((LivingEntity)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onLivingFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.causeFallDamage(distance, damageMultiplier, damageSource);
    }

    public void setSprinting(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.setSprinting(sprinting);
    }

    public void stopRiding() {
        if (this.builder.onStopRiding != null && this.isPassenger()) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
        super.stopRiding();
    }

    protected void removePassenger(Entity p_20352_) {
        if (this.builder.onRemovePassenger != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovePassenger, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovePassenger.");
        }
        super.removePassenger(p_20352_);
    }

    public void rideTick() {
        super.rideTick();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void onItemPickup(@NotNull ItemEntity p_21054_) {
        super.onItemPickup(p_21054_);
        if (this.builder.onItemPickup != null) {
            ContextUtils.EntityItemEntityContext context = new ContextUtils.EntityItemEntityContext((LivingEntity)this, p_21054_);
            EntityJSHelperClass.consumerCallback(this.builder.onItemPickup, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onItemPickup.");
        }
    }

    public void onEnterCombat() {
        if (this.builder.onEnterCombat != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onEnterCombat, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEnterCombat.");
        } else {
            super.onEnterCombat();
        }
    }

    public void onLeaveCombat() {
        if (this.builder.onLeaveCombat != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onLeaveCombat, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLeaveCombat.");
        }
        super.onLeaveCombat();
    }

    public void startSleeping(@NotNull BlockPos blockPos) {
        if (this.builder.onStartSleeping != null) {
            ContextUtils.EntityBlockPosContext context = new ContextUtils.EntityBlockPosContext((LivingEntity)this, blockPos);
            EntityJSHelperClass.consumerCallback(this.builder.onStartSleeping, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStartSleeping.");
        }
        super.startSleeping(blockPos);
    }

    public void stopSleeping() {
        if (this.builder.onStopSleeping != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopSleeping, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopSleeping.");
        }
        super.stopSleeping();
    }

    public ItemStack eat(Level level, ItemStack itemStack, FoodProperties properties) {
        if (this.builder.eat != null) {
            ContextUtils.FoodItemLevelContext context = new ContextUtils.FoodItemLevelContext((LivingEntity)this, itemStack, level, properties);
            EntityJSHelperClass.consumerCallback(this.builder.eat, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: eat.");
            return itemStack;
        }
        return super.eat(level, itemStack);
    }

    public void onClientRemoval() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.onClientRemoval();
    }

    public void actuallyHurt(DamageSource pDamageSource, float pDamageAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityDamageContext context = new ContextUtils.EntityDamageContext(pDamageSource, pDamageAmount, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        super.actuallyHurt(pDamageSource, pDamageAmount);
    }

    public void lavaHurt() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.lavaHurt();
    }

    public void playerTouch(Player p_20081_) {
        if (this.builder.playerTouch != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(p_20081_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        } else {
            super.playerTouch(p_20081_);
        }
    }

    public void thunderHit(ServerLevel p_19927_, LightningBolt p_19928_) {
        if (this.builder.thunderHit != null) {
            super.thunderHit(p_19927_, p_19928_);
            ContextUtils.ThunderHitContext context = new ContextUtils.ThunderHitContext(p_19927_, p_19928_, (LivingEntity)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean isInvulnerableTo(DamageSource p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.DamageContext context = new ContextUtils.DamageContext((LivingEntity)this, p_20122_);
            Boolean obj = this.builder.isInvulnerableTo.test(context);
            if (obj instanceof Boolean) {
                return obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.isInvulnerableTo(p_20122_));
        }
        return super.isInvulnerableTo(p_20122_);
    }

    public void onRemovedFromLevel() {
        if (this.builder != null && this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
        super.onRemovedFromLevel();
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        super.lerpTo(x, y, z, yaw, pitch, posRotationIncrements);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, (Entity)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (Entity)this);
            Boolean obj = this.builder.shouldRenderAtSqrDistance.test(context);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + super.shouldRenderAtSqrDistance(distance));
        }
        return super.shouldRenderAtSqrDistance(distance);
    }

    public boolean canBeCollidedWith() {
        if (this.builder.canBeCollidedWith == null) {
            return super.canBeCollidedWith();
        }
        Boolean obj = this.builder.canBeCollidedWith.test(this);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeCollidedWith from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + super.canBeCollidedWith());
        return super.canBeCollidedWith();
    }

    protected boolean canRide(Entity pVehicle) {
        if (this.builder.canRide == null) {
            return super.canRide(pVehicle);
        }
        ContextUtils.PassengerVehicleContext context = new ContextUtils.PassengerVehicleContext(pVehicle, (LivingEntity)this);
        Boolean obj = this.builder.canRide.test(context);
        if (obj instanceof Boolean) {
            return obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canRide from entity: " + this.entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method.");
        return super.canRide(pVehicle);
    }
}

