/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.events;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.liopyu.entityjs.util.implementation.EACAccess;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;

public class AttributeCreationEventJS
implements KubeEvent {
    private final EntityAttributeCreationEvent event;

    public AttributeCreationEventJS(EntityAttributeCreationEvent event) {
        this.event = event;
    }

    public Map<EntityType<? extends LivingEntity>, AttributeSupplier> getMap() {
        return ((EACAccess)this.event).entityJs$getMap();
    }

    @Info(value="Modifies the given entity type's default attributes", params={@Param(name="entityType", value="The entity type whose default attributes are to be modified"), @Param(name="attributes", value="A consumer for modifying the default attributes and their values")})
    public void create(EntityType<? extends LivingEntity> entityType, Consumer<AttributeCreationHelper> attributes) {
        Map<EntityType<? extends LivingEntity>, AttributeSupplier> internalMap = ((EACAccess)this.event).entityJs$getMap();
        AttributeSupplier existing = internalMap.get(entityType);
        AttributeSupplier.Builder builder = existing == null ? new AttributeSupplier.Builder() : new AttributeSupplier.Builder(existing);
        AttributeCreationHelper helper = new AttributeCreationHelper(builder);
        attributes.accept(helper);
        internalMap.put(entityType, builder.build());
    }

    @Info(value="Returns a list of all entity types available in the attribute map")
    public List<EntityType<? extends LivingEntity>> getAllTypes() {
        return new ArrayList<EntityType<? extends LivingEntity>>(((EACAccess)this.event).entityJs$getMap().keySet());
    }

    @Info(value="Returns a list of all attributes the given entity type has by default")
    public List<Attribute> getAttributes(EntityType<? extends LivingEntity> entityType) {
        ArrayList<Attribute> present = new ArrayList<Attribute>();
        AttributeSupplier supplier = ((EACAccess)this.event).entityJs$getMap().get(entityType);
        if (supplier != null) {
            for (Holder attr : BuiltInRegistries.ATTRIBUTE.holders().toList()) {
                if (!supplier.hasAttribute(attr)) continue;
                present.add((Attribute)attr.value());
            }
        }
        return present;
    }

    public static class AttributeCreationHelper {
        @HideFromJS
        private final AttributeSupplier.Builder builder;

        public AttributeCreationHelper(AttributeSupplier.Builder builder) {
            this.builder = builder;
        }

        @Info(value="Adds the given attribute with default value")
        public void add(Attribute attribute) {
            ResourceLocation id = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
            if (id != null) {
                Optional holder = BuiltInRegistries.ATTRIBUTE.getHolder(id);
                if (holder != null) {
                    this.builder.add((Holder)holder.get());
                } else {
                    this.builder.add(Holder.direct((Object)attribute));
                }
            } else {
                this.builder.add(Holder.direct((Object)attribute));
            }
        }

        @Info(value="Adds the given attribute with default value", params={@Param(name="attribute", value="Attribute or resource location string"), @Param(name="value", value="Default value for the attribute")})
        public void add(Attribute attribute, int value) {
            ResourceLocation id = BuiltInRegistries.ATTRIBUTE.getKey((Object)attribute);
            if (id != null) {
                Optional holder = BuiltInRegistries.ATTRIBUTE.getHolder(id);
                if (holder.isPresent()) {
                    this.builder.add((Holder)holder.get(), (double)value);
                } else {
                    this.builder.add(Holder.direct((Object)attribute), (double)value);
                }
            } else {
                this.builder.add(Holder.direct((Object)attribute));
            }
        }
    }
}

