/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.events;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.builders.modification.ModifyLivingEntityBuilder;
import net.liopyu.entityjs.builders.modification.ModifyMobBuilder;
import net.liopyu.entityjs.builders.modification.ModifyPathfinderMobBuilder;
import net.liopyu.entityjs.builders.modification.ModifyProjectileBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.Projectile;

public class EntityModificationEventJS
implements KubeEvent {
    public static final Map<EntityType<?>, EntityModificationEventJS> eventMap = new HashMap();
    private final Object builder;
    private final EntityType<?> entityType;
    public static final Map<ResourceLocation, Consumer<ModifyEntityBuilder>> createCustomMap = new HashMap<ResourceLocation, Consumer<ModifyEntityBuilder>>();

    private EntityModificationEventJS(EntityType<?> entityType, Entity entity) {
        this.entityType = entityType;
        this.builder = this.determineModificationType(entityType, entity);
    }

    public static EntityModificationEventJS getOrCreate(EntityType<?> entityType, Entity entity) {
        return eventMap.computeIfAbsent(entityType, t -> new EntityModificationEventJS((EntityType<?>)t, entity));
    }

    @HideFromJS
    public Object getBuilder() {
        return this.builder;
    }

    @Info(value="Entity type modification event. Allows modification of methods for any existing entity. \n \nThis event determines the entity's type and uses the appropriate builder for modification. \n \nBuilders: \n    - ModifyPathfinderMobBuilder: For entities extending {@link PathfinderMob} \n    - ModifyMobBuilder: For entities extending {@link Mob} \n    - ModifyLivingEntityBuilder: For entities extending {@link LivingEntity} \n    - ModifyEntityBuilder: For entities extending {@link Entity} \n \nExample usage: \n```javascript\nEntityJSEvents.modifyEntity(event => {\n    event.modify(\"minecraft:zombie\", builder => {\n        builder.onRemovedFromWorld(entity => {\n            // Execute code when the zombie is removed from the world.\n        })\n    })\n})\n```\n", params={@Param(name="entityType", value="The entity type to modify"), @Param(name="modifyBuilder", value="A consumer to modify the entity type.")})
    public void modify(EntityType<?> entityType, Consumer<? extends ModifyEntityBuilder> modifyBuilder) {
        if (entityType != this.entityType) {
            return;
        }
        if (this.builder instanceof ModifyProjectileBuilder) {
            modifyBuilder.accept((ModifyProjectileBuilder)this.builder);
        } else if (this.builder instanceof ModifyPathfinderMobBuilder) {
            modifyBuilder.accept((ModifyPathfinderMobBuilder)this.builder);
        } else if (this.builder instanceof ModifyMobBuilder) {
            modifyBuilder.accept((ModifyMobBuilder)this.builder);
        } else if (this.builder instanceof ModifyLivingEntityBuilder) {
            modifyBuilder.accept((ModifyLivingEntityBuilder)this.builder);
        } else if (this.builder instanceof ModifyEntityBuilder) {
            modifyBuilder.accept((ModifyEntityBuilder)this.builder);
        } else {
            throw new IllegalArgumentException("Unsupported builder type or consumer type.");
        }
    }

    public ModifyEntityBuilder determineModificationType(EntityType<?> type, Entity entity) {
        if (entity instanceof PathfinderMob) {
            return new ModifyPathfinderMobBuilder(type);
        }
        if (entity instanceof Mob) {
            return new ModifyMobBuilder(type);
        }
        if (entity instanceof LivingEntity) {
            return new ModifyLivingEntityBuilder(type);
        }
        if (entity instanceof Projectile) {
            return new ModifyProjectileBuilder(type);
        }
        return new ModifyEntityBuilder(type);
    }
}

