/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventTargetType;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.event.TargetedEventHandler;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.script.data.VirtualDataPack;
import dev.latvian.mods.kubejs.util.Cast;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.BaseNonAnimatableEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileAnimatableJSBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.TridentJSBuilder;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.AttributeCreationEventJS;
import net.liopyu.entityjs.events.BiomeSpawnsEventJS;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.events.ModifyAttributeEventJS;
import net.liopyu.entityjs.events.RegisterSpawnPlacementsEventJS;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class EventHandlers {
    public static EventTargetType<ResourceKey<EntityType<?>>> TARGET = EventTargetType.registryKey((ResourceKey)Registries.ENTITY_TYPE, EntityType.class);
    public static final EventGroup EntityJSEvents = EventGroup.of((String)"EntityJSEvents");
    public static final TargetedEventHandler<ResourceKey<EntityType<?>>> addGoalTargets = EntityJSEvents.server("addGoals", () -> AddGoalTargetsEventJS.class).requiredTarget(TARGET);
    public static final TargetedEventHandler<ResourceKey<EntityType<?>>> addGoalSelectors = EntityJSEvents.server("addGoalSelectors", () -> AddGoalSelectorsEventJS.class).requiredTarget(TARGET);
    public static final TargetedEventHandler<ResourceKey<EntityType<?>>> buildBrain = EntityJSEvents.server("buildBrain", () -> BuildBrainEventJS.class).requiredTarget(TARGET);
    public static final TargetedEventHandler<ResourceKey<EntityType<?>>> buildBrainProvider = EntityJSEvents.server("buildBrainProvider", () -> BuildBrainProviderEventJS.class).requiredTarget(TARGET);
    public static final EventHandler biomeSpawns = EntityJSEvents.server("biomeSpawns", () -> BiomeSpawnsEventJS.class);
    public static final EventHandler createAttributes = EntityJSEvents.startup("createAttributes", () -> AttributeCreationEventJS.class);
    public static final EventHandler editAttributes = EntityJSEvents.startup("attributes", () -> ModifyAttributeEventJS.class);
    public static final EventHandler spawnPlacement = EntityJSEvents.startup("spawnPlacement", () -> RegisterSpawnPlacementsEventJS.class);
    public static final EventHandler modifyEntity = EntityJSEvents.startup("modifyEntity", () -> EntityModificationEventJS.class);

    public static void init(IEventBus modBus) {
        modBus.addListener(EventHandlers::registerDispenserBehavior);
        modBus.addListener(EventHandlers::attributeCreation);
        modBus.addListener(EventHandlers::attributeRegistry);
        modBus.addListener(EventHandlers::attributeModification);
        modBus.addListener(EventPriority.LOW, EventHandlers::registerSpawnPlacements);
    }

    private static void attributeRegistry(EntityAttributeCreationEvent event) {
        if (createAttributes.hasListeners()) {
            createAttributes.post((KubeEvent)new AttributeCreationEventJS(event));
        }
    }

    private static void registerDispenserBehavior(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Item item;
            BuilderBase builder;
            for (BaseNonAnimatableEntityBuilder<?> baseNonAnimatableEntityBuilder : BaseNonAnimatableEntityBuilder.thisList) {
                if (!(baseNonAnimatableEntityBuilder instanceof ArrowEntityJSBuilder)) continue;
                builder = (ArrowEntityJSBuilder)baseNonAnimatableEntityBuilder;
                if (builder.noItem || !builder.canShootFromDispenser) continue;
                item = (Item)BuiltInRegistries.ITEM.get(builder.item.id);
                DispenserBlock.registerProjectileBehavior((ItemLike)item);
            }
            for (ProjectileEntityBuilder projectileEntityBuilder : ProjectileEntityBuilder.thisList) {
                ProjectileEntityJSBuilder b = (ProjectileEntityJSBuilder)projectileEntityBuilder;
                if (b.noItem || !b.canShootFromDispenser) continue;
                item = (Item)BuiltInRegistries.ITEM.get(b.item.id);
                DispenserBlock.registerProjectileBehavior((ItemLike)item);
            }
            for (BaseEntityBuilder baseEntityBuilder : BaseEntityBuilder.thisList) {
                if (baseEntityBuilder instanceof TridentJSBuilder) {
                    builder = (TridentJSBuilder)baseEntityBuilder;
                    if (builder.noItem || !builder.canShootFromDispenser) continue;
                    Item item2 = (Item)BuiltInRegistries.ITEM.get(builder.item.id);
                    DispenserBlock.registerProjectileBehavior((ItemLike)item2);
                    continue;
                }
                if (!(baseEntityBuilder instanceof ProjectileAnimatableJSBuilder)) continue;
                ProjectileAnimatableJSBuilder builder2 = (ProjectileAnimatableJSBuilder)baseEntityBuilder;
                if (builder2.noItem || !builder2.canShootFromDispenser) continue;
                Item item2 = (Item)BuiltInRegistries.ITEM.get(builder2.item.id);
                DispenserBlock.registerProjectileBehavior((ItemLike)item2);
            }
        });
    }

    private static void attributeCreation(EntityAttributeCreationEvent event) {
        for (BaseLivingEntityBuilder<?> baseLivingEntityBuilder : BaseLivingEntityBuilder.thisList) {
            event.put((EntityType)baseLivingEntityBuilder.get(), baseLivingEntityBuilder.getAttributeBuilder().build());
        }
        for (CustomEntityJSBuilder customEntityJSBuilder : CustomEntityJSBuilder.thisList) {
            event.put((EntityType)customEntityJSBuilder.get(), customEntityJSBuilder.getAttributeBuilder().build());
        }
    }

    private static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        for (BaseLivingEntityBuilder<?> builder : BaseLivingEntityBuilder.spawnList) {
            event.register((EntityType)Cast.to((Object)builder.get()), builder.placementType, builder.heightMap, builder.spawnPredicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }
        if (spawnPlacement.hasListeners()) {
            spawnPlacement.post((KubeEvent)new RegisterSpawnPlacementsEventJS(event));
        }
    }

    private static void attributeModification(EntityAttributeModificationEvent event) {
        if (editAttributes.hasListeners()) {
            editAttributes.post((KubeEvent)new ModifyAttributeEventJS(event));
        }
    }

    public static void postDataEvent(VirtualDataPack pack, MultiPackResourceManager multiManager) {
        if (pack == null || multiManager != null) {
            // empty if block
        }
    }
}

