/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.data;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public final class NbtConvert {
    public static Tag toTag(EntitySerializerType type, Object o) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EntitySerializerType.BYTE -> ByteTag.valueOf((byte)((Number)o).byteValue());
            case EntitySerializerType.INT -> IntTag.valueOf((int)((Number)o).intValue());
            case EntitySerializerType.LONG -> LongTag.valueOf((long)((Number)o).longValue());
            case EntitySerializerType.FLOAT -> FloatTag.valueOf((float)((Number)o).floatValue());
            case EntitySerializerType.STRING -> StringTag.valueOf((String)String.valueOf(o));
            case EntitySerializerType.BOOLEAN -> ByteTag.valueOf((byte)((byte)((Boolean)o != false ? 1 : 0)));
            case EntitySerializerType.COMPOUND_TAG -> {
                if (o instanceof CompoundTag) {
                    CompoundTag ct = (CompoundTag)o;
                    yield ct.copy();
                }
                yield NbtConvert.toCompound(o);
            }
            case EntitySerializerType.UUID -> NbtUtils.createUUID((UUID)((UUID)o));
            case EntitySerializerType.VECTOR3 -> NbtConvert.toVec3(NbtConvert.vec3x(o), NbtConvert.vec3y(o), NbtConvert.vec3z(o));
            case EntitySerializerType.QUATERNION -> NbtConvert.toQuat((Quaternionf)o);
        };
    }

    public static Object fromTag(EntitySerializerType type, Tag tag) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EntitySerializerType.BYTE -> ((ByteTag)tag).getAsByte();
            case EntitySerializerType.INT -> ((IntTag)tag).getAsInt();
            case EntitySerializerType.LONG -> ((LongTag)tag).getAsLong();
            case EntitySerializerType.FLOAT -> Float.valueOf(((FloatTag)tag).getAsFloat());
            case EntitySerializerType.STRING -> ((StringTag)tag).getAsString();
            case EntitySerializerType.BOOLEAN -> ((ByteTag)tag).getAsByte() != 0;
            case EntitySerializerType.COMPOUND_TAG -> ((CompoundTag)tag).copy();
            case EntitySerializerType.UUID -> NbtUtils.loadUUID((Tag)tag);
            case EntitySerializerType.VECTOR3 -> {
                CompoundTag c = (CompoundTag)tag;
                yield new Vector3f(c.getFloat("x"), c.getFloat("y"), c.getFloat("z"));
            }
            case EntitySerializerType.QUATERNION -> {
                CompoundTag c = (CompoundTag)tag;
                yield new Quaternionf(c.getFloat("x"), c.getFloat("y"), c.getFloat("z"), c.getFloat("w"));
            }
        };
    }

    private static CompoundTag toCompound(Object o) {
        CompoundTag ct = new CompoundTag();
        if (o instanceof Map) {
            Map m = (Map)o;
            for (Map.Entry e : m.entrySet()) {
                ct.put(String.valueOf(e.getKey()), NbtConvert.wrapAny(e.getValue()));
            }
        }
        return ct;
    }

    private static Tag wrapAny(Object o) {
        if (o instanceof Tag) {
            Tag t = (Tag)o;
            return t.copy();
        }
        if (o instanceof String) {
            String s = (String)o;
            return StringTag.valueOf((String)s);
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return IntTag.valueOf((int)i);
        }
        if (o instanceof Long) {
            Long l = (Long)o;
            return LongTag.valueOf((long)l);
        }
        if (o instanceof Float) {
            Float f = (Float)o;
            return FloatTag.valueOf((float)f.floatValue());
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            return FloatTag.valueOf((float)d.floatValue());
        }
        if (o instanceof Short) {
            Short s = (Short)o;
            return ShortTag.valueOf((short)s);
        }
        if (o instanceof Byte) {
            Byte b = (Byte)o;
            return ByteTag.valueOf((byte)b);
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return ByteTag.valueOf((byte)((byte)(b != false ? 1 : 0)));
        }
        if (o instanceof UUID) {
            UUID u = (UUID)o;
            return NbtUtils.createUUID((UUID)u);
        }
        if (o instanceof Vector3f) {
            Vector3f v3 = (Vector3f)o;
            return NbtConvert.toVec3(v3.x(), v3.y(), v3.z());
        }
        if (o instanceof Vector3d) {
            Vector3d v3d = (Vector3d)o;
            return NbtConvert.toVec3((float)v3d.x(), (float)v3d.y(), (float)v3d.z());
        }
        if (o instanceof Vec3) {
            Vec3 v = (Vec3)o;
            return NbtConvert.toVec3((float)v.x, (float)v.y, (float)v.z);
        }
        if (o instanceof Vec3i) {
            Vec3i vi = (Vec3i)o;
            return NbtConvert.toVec3(vi.getX(), vi.getY(), vi.getZ());
        }
        if (o instanceof List) {
            List list = (List)o;
            ListTag lt = new ListTag();
            for (Object e : list) {
                lt.add((Object)NbtConvert.wrapAny(e));
            }
            return lt;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return NbtConvert.toCompound(map);
        }
        return StringTag.valueOf((String)String.valueOf(o));
    }

    private static CompoundTag toVec3(float x, float y, float z) {
        CompoundTag c = new CompoundTag();
        c.putFloat("x", x);
        c.putFloat("y", y);
        c.putFloat("z", z);
        return c;
    }

    private static CompoundTag toQuat(Quaternionf q) {
        CompoundTag c = new CompoundTag();
        c.putFloat("x", q.x());
        c.putFloat("y", q.y());
        c.putFloat("z", q.z());
        c.putFloat("w", q.w());
        return c;
    }

    private static float vec3x(Object o) {
        List l;
        int[] a3;
        double[] a2;
        float[] a;
        if (o instanceof Vector3f) {
            Vector3f v = (Vector3f)o;
            return v.x();
        }
        if (o instanceof Vector3d) {
            Vector3d v = (Vector3d)o;
            return (float)v.x();
        }
        if (o instanceof Vec3) {
            Vec3 v = (Vec3)o;
            return (float)v.x;
        }
        if (o instanceof Vec3i) {
            Vec3i v = (Vec3i)o;
            return v.getX();
        }
        if (o instanceof float[] && (a = (float[])o).length >= 3) {
            return a[0];
        }
        if (o instanceof double[] && (a2 = (double[])o).length >= 3) {
            return (float)a2[0];
        }
        if (o instanceof int[] && (a3 = (int[])o).length >= 3) {
            return a3[0];
        }
        if (o instanceof List && (l = (List)o).size() >= 3) {
            return NbtConvert.num(l.get(0));
        }
        return 0.0f;
    }

    private static float vec3y(Object o) {
        List l;
        int[] a3;
        double[] a2;
        float[] a;
        if (o instanceof Vector3f) {
            Vector3f v = (Vector3f)o;
            return v.y();
        }
        if (o instanceof Vector3d) {
            Vector3d v = (Vector3d)o;
            return (float)v.y();
        }
        if (o instanceof Vec3) {
            Vec3 v = (Vec3)o;
            return (float)v.y;
        }
        if (o instanceof Vec3i) {
            Vec3i v = (Vec3i)o;
            return v.getY();
        }
        if (o instanceof float[] && (a = (float[])o).length >= 3) {
            return a[1];
        }
        if (o instanceof double[] && (a2 = (double[])o).length >= 3) {
            return (float)a2[1];
        }
        if (o instanceof int[] && (a3 = (int[])o).length >= 3) {
            return a3[1];
        }
        if (o instanceof List && (l = (List)o).size() >= 3) {
            return NbtConvert.num(l.get(1));
        }
        return 0.0f;
    }

    private static float vec3z(Object o) {
        List l;
        int[] a3;
        double[] a2;
        float[] a;
        if (o instanceof Vector3f) {
            Vector3f v = (Vector3f)o;
            return v.z();
        }
        if (o instanceof Vector3d) {
            Vector3d v = (Vector3d)o;
            return (float)v.z();
        }
        if (o instanceof Vec3) {
            Vec3 v = (Vec3)o;
            return (float)v.z;
        }
        if (o instanceof Vec3i) {
            Vec3i v = (Vec3i)o;
            return v.getZ();
        }
        if (o instanceof float[] && (a = (float[])o).length >= 3) {
            return a[2];
        }
        if (o instanceof double[] && (a2 = (double[])o).length >= 3) {
            return (float)a2[2];
        }
        if (o instanceof int[] && (a3 = (int[])o).length >= 3) {
            return a3[2];
        }
        if (o instanceof List && (l = (List)o).size() >= 3) {
            return NbtConvert.num(l.get(2));
        }
        return 0.0f;
    }

    private static float num(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.floatValue();
        }
        if (o instanceof String) {
            String s = (String)o;
            try {
                return Float.parseFloat(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0f;
    }
}

