/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client;

import dev.latvian.mods.kubejs.util.Cast;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.builders.misc.CustomEntityBuilder;
import net.liopyu.entityjs.builders.misc.CustomEntityJSBuilder;
import net.liopyu.entityjs.builders.nonliving.BaseEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ProjectileEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.BoatEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderEntityBuilder;
import net.liopyu.entityjs.client.living.CustomKubeJSEntityRenderer;
import net.liopyu.entityjs.client.living.KubeJSEntityRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSArrowEntityRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSBoatRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSEnderEyeRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSNLEntityRenderer;
import net.liopyu.entityjs.client.nonliving.KubeJSProjectileEntityRenderer;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public class ClientEventHandlers {
    public static void init(IEventBus modBus) {
        modBus.addListener(ClientEventHandlers::registerEntityRenders);
    }

    private static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        for (BaseLivingEntityBuilder<?> baseLivingEntityBuilder : BaseLivingEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)Cast.to((Object)baseLivingEntityBuilder.get()), renderManager -> new KubeJSEntityRenderer(renderManager, builder));
        }
        for (ArrowEntityBuilder arrowEntityBuilder : ArrowEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)Cast.to((Object)arrowEntityBuilder.get()), renderManager -> new KubeJSArrowEntityRenderer(renderManager, arrowEntityBuilder));
        }
        for (ProjectileEntityBuilder projectileEntityBuilder : ProjectileEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)Cast.to((Object)projectileEntityBuilder.get()), renderManager -> new KubeJSProjectileEntityRenderer(renderManager, projectileEntityBuilder));
        }
        for (EyeOfEnderEntityBuilder eyeOfEnderEntityBuilder : EyeOfEnderEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)Cast.to((Object)eyeOfEnderEntityBuilder.get()), renderManager -> new KubeJSEnderEyeRenderer(renderManager, eyeOfEnderEntityBuilder));
        }
        for (BaseEntityBuilder baseEntityBuilder : BaseEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)Cast.to((Object)baseEntityBuilder.get()), renderManager -> new KubeJSNLEntityRenderer(renderManager, baseEntityBuilder));
        }
        for (BoatEntityBuilder boatEntityBuilder : BoatEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)Cast.to((Object)boatEntityBuilder.get()), renderManager -> new KubeJSBoatRenderer(renderManager, boatEntityBuilder));
        }
        for (CustomEntityJSBuilder customEntityJSBuilder : CustomEntityBuilder.thisList) {
            event.registerEntityRenderer((EntityType)Cast.to((Object)customEntityJSBuilder.get()), renderManager -> new CustomKubeJSEntityRenderer(renderManager, customEntityJSBuilder));
        }
    }
}

