/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.Objects;
import java.util.Optional;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.data.ClientCache;
import net.liopyu.entityjs.util.data.InitDecl;
import net.liopyu.entityjs.util.data.NbtConvert;
import net.liopyu.entityjs.util.data.Net;
import net.liopyu.entityjs.util.data.SavedDataJS;
import net.liopyu.entityjs.util.data.ServerCache;
import net.liopyu.entityjs.util.implementation.IEntityJS;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, remap=true)
public class EntityMixin
implements IEntityJS {
    @Unique
    private Object entityJs$builder;
    @Unique
    private Object entityJs$entityObject = this;
    @Unique
    private EntityJSHelperClass.EntityMovementTracker entityJs$movementTracker;
    private boolean entityJs$isMoving = false;
    @Unique
    private boolean entityJs$definedOnce;

    @Unique
    private Entity entityJs$getLivingEntity() {
        return (Entity)this;
    }

    @Unique
    private String entityJs$entityName() {
        return this.entityJs$getLivingEntity().getType().toString();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=true)
    private void entityjs$onEntityInit(EntityType<?> pEntityType, Level pLevel, CallbackInfo ci) {
        EntityType entityType = this.entityJs$getLivingEntity().getType();
        EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, this.entityJs$getLivingEntity());
        this.entityJs$builder = eventJS.getBuilder();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EventHandlers.modifyEntity.post((KubeEvent)eventJS);
        }
        this.entityJs$movementTracker = new EntityJSHelperClass.EntityMovementTracker();
    }

    @Override
    @Unique
    public void entityJs$addSyncedData(EntitySerializerType type, String name, Object initial) {
        LivingEntity self = (LivingEntity)this;
        Tag t = NbtConvert.toTag(type, initial);
        if (self.level().isClientSide) {
            ClientCache.setType(self.getUUID(), name, type.ordinal());
            ClientCache.set(self.getUUID(), name, t);
            Net.sendEnsureToServer(self.getUUID(), name, type, t);
        } else {
            ServerCache.ensure((Entity)self, name, t, type);
        }
    }

    @Override
    @Unique
    public void entityJs$setSyncedData(String name, Object value) {
        Entity self = (Entity)this;
        EntitySerializerType type = self.level().isClientSide ? ClientCache.getType(self.getUUID(), name).orElse(EntitySerializerType.STRING) : SavedDataJS.get((ServerLevel)self.level()).getType(self.getUUID(), name).orElse(EntitySerializerType.STRING);
        Tag t = NbtConvert.toTag(type, value);
        if (self.level().isClientSide) {
            ClientCache.set(self.getUUID(), name, t);
            Net.sendSetToServer(self.getUUID(), name, t);
        } else {
            ServerCache.set(self, name, t);
        }
    }

    @Override
    @Unique
    public Object entityJs$getSyncedData(String name) {
        Entity self = (Entity)this;
        if (self.level().isClientSide) {
            Optional<EntitySerializerType> opt = ClientCache.getType(self.getUUID(), name);
            Tag tag = ClientCache.get(self.getUUID(), name);
            return opt.isPresent() && tag != null ? NbtConvert.fromTag(opt.get(), tag) : tag;
        }
        Optional<EntitySerializerType> opt = SavedDataJS.get((ServerLevel)self.level()).getType(self.getUUID(), name);
        Tag tag = ServerCache.get(self, name);
        return opt.isPresent() && tag != null ? NbtConvert.fromTag(opt.get(), tag) : tag;
    }

    public void entityJs$defineSynchedData() {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.defineSyncedData != null) {
                builder.defineSyncedData.accept(this.entityJs$getLivingEntity());
            }
        }
    }

    @Inject(method={"ignoreExplosion"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    public void entityJs$ignoreExplosion(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.ignoreExplosion != null) {
                Object obj = builder.ignoreExplosion.apply((Entity)this);
                if (obj instanceof Boolean) {
                    Boolean b = (Boolean)obj;
                    cir.setReturnValue((Object)b);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid ignoreExplosion return value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method.");
                }
            }
        }
    }

    @Override
    public boolean entityJs$isMoving() {
        return this.entityJs$isMoving;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    public void entityJs$tick(CallbackInfo ci) {
        Object object;
        this.entityJs$isMoving = this.entityJs$movementTracker.isMoving(this.entityJs$getLivingEntity());
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.tick != null) {
                EntityJSHelperClass.consumerCallback(builder.tick, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: tick.");
            }
        }
    }

    @Inject(method={"lerpTo"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.lerpTo != null) {
                ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.lerpTo, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: lerpTo.");
            }
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void move(MoverType pType, Vec3 pPos, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.move != null) {
                ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.move, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: move.");
            }
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void playerTouch(Player pPlayer, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (this.entityJs$builder != null && builder.playerTouch != null) {
                ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(pPlayer, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.playerTouch, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: playerTouch.");
            }
        }
    }

    @Inject(method={"onRemovedFromLevel"}, at={@At(value="HEAD", ordinal=0)}, remap=false, cancellable=true)
    public void onRemovedFromWorld(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onRemovedFromWorld != null) {
                EntityJSHelperClass.consumerCallback(builder.onRemovedFromWorld, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onRemovedFromWorld.");
            }
        }
    }

    @Inject(method={"thunderHit"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.thunderHit != null) {
                ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(pLevel, pLightning, this.entityJs$getLivingEntity());
                EntityJSHelperClass.consumerCallback(builder.thunderHit, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: thunderHit.");
            }
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onFall != null) {
                ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext(this.entityJs$getLivingEntity(), pMultiplier, pFallDistance, pSource);
                EntityJSHelperClass.consumerCallback(builder.onFall, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onLivingFall.");
            }
        }
    }

    @Inject(method={"onAddedToLevel"}, at={@At(value="HEAD", ordinal=0)}, remap=false, cancellable=true)
    public void onAddedToWorld(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onAddedToWorld != null && !this.entityJs$getLivingEntity().level().isClientSide()) {
                EntityJSHelperClass.consumerCallback(builder.onAddedToWorld, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onAddedToWorld.");
            }
        }
        if (!(this.entityJs$getLivingEntity() instanceof IAnimatableJS) && (object = this.entityJs$getLivingEntity()) instanceof Mob) {
            Mob m = (Mob)object;
            if (EventHandlers.addGoalTargets.hasListeners()) {
                EventHandlers.addGoalTargets.post(new AddGoalTargetsEventJS<Mob>(m, m.goalSelector), this.entityJs$getTypeId());
            }
            if (EventHandlers.addGoalSelectors.hasListeners()) {
                EventHandlers.addGoalSelectors.post(new AddGoalSelectorsEventJS<Mob>(m, m.goalSelector), this.entityJs$getTypeId());
            }
        }
        Entity self = (Entity)this;
        if (this.entityJs$definedOnce) {
            return;
        }
        if (self.level().isClientSide) {
            return;
        }
        Object object2 = this.entityJs$builder;
        if (!(object2 instanceof ModifyEntityBuilder)) {
            return;
        }
        ModifyEntityBuilder b = (ModifyEntityBuilder)object2;
        if (b.defineSyncedData == null) {
            return;
        }
        InitDecl.begin(self);
        b.defineSyncedData.accept(this.entityJs$getLivingEntity());
        this.entityJs$definedOnce = true;
        ((ServerLevel)self.level()).getServer().execute(() -> InitDecl.finalizeFor(self));
    }

    @Unique
    public ResourceKey<EntityType<?>> entityJs$getTypeId() {
        return (ResourceKey)Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getResourceKey((Object)this.entityJs$getLivingEntity().getType())).get();
    }

    @Inject(method={"setSprinting"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void setSprinting(boolean pSprinting, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onSprint != null) {
                EntityJSHelperClass.consumerCallback(builder.onSprint, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onSprint.");
            }
        }
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void stopRiding(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onStopRiding != null) {
                EntityJSHelperClass.consumerCallback(builder.onStopRiding, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onStopRiding.");
            }
        }
    }

    @Inject(method={"rideTick"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void rideTick(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.rideTick != null) {
                EntityJSHelperClass.consumerCallback(builder.rideTick, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: rideTick.");
            }
        }
    }

    @Inject(method={"onClientRemoval"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void onClientRemoval(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onClientRemoval != null) {
                EntityJSHelperClass.consumerCallback(builder.onClientRemoval, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onClientRemoval.");
            }
        }
    }

    @Inject(method={"lavaHurt"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void lavaHurt(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.lavaHurt != null) {
                EntityJSHelperClass.consumerCallback(builder.lavaHurt, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: lavaHurt.");
            }
        }
    }

    @Inject(method={"onFlap"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void onFlap(CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onFlap != null) {
                EntityJSHelperClass.consumerCallback(builder.onFlap, this.entityJs$getLivingEntity(), "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onFlap.");
            }
        }
    }

    @Inject(method={"shouldRenderAtSqrDistance"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void shouldRenderAtSqrDistance(double pDistance, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.shouldRenderAtSqrDistance != null) {
                ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(pDistance, this.entityJs$getLivingEntity());
                Boolean obj = builder.shouldRenderAtSqrDistance.test(context);
                if (obj instanceof Boolean) {
                    Boolean b = obj;
                    cir.setReturnValue((Object)b);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for arrow builder: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to super method: " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"isAttackable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isAttackable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.isAttackable == null) {
                return;
            }
            cir.setReturnValue((Object)builder.isAttackable);
        }
    }

    @Inject(method={"getControllingPassenger"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getControllingPassenger(CallbackInfoReturnable<LivingEntity> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.controlledByFirstPassenger != null) {
                LivingEntity entity;
                if (!builder.controlledByFirstPassenger.booleanValue()) {
                    return;
                }
                Entity var2 = this.entityJs$getLivingEntity().getFirstPassenger();
                LivingEntity var10000 = var2 instanceof LivingEntity ? (entity = (LivingEntity)var2) : null;
                cir.setReturnValue((Object)var10000);
            }
        }
    }

    @Inject(method={"canCollideWith"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canCollideWith(Entity pEntity, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.canCollideWith != null) {
                ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext(this.entityJs$getLivingEntity(), pEntity);
                Boolean obj = builder.canCollideWith.test(context);
                if (obj instanceof Boolean) {
                    Boolean b = obj;
                    cir.setReturnValue((Object)b);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"getBlockJumpFactor"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getBlockJumpFactor(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.setBlockJumpFactor == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.setBlockJumpFactor.apply(this.entityJs$getLivingEntity()), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(builder.setBlockJumpFactor.apply(this.entityJs$getLivingEntity())) + ". Must be a float. Defaulting to " + String.valueOf(cir.getReturnValue()));
            }
        }
    }

    @Inject(method={"isPickable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isPickable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.isPickable == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.isPickable.test(this.entityJs$getLivingEntity()), "boolean");
            if (obj != null) {
                cir.setReturnValue((Object)((Boolean)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isPickable from entity: " + this.entityJs$entityName() + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
            }
        }
    }

    @Inject(method={"isPushable"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isPushable(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.isPushable == null) {
                return;
            }
            cir.setReturnValue((Object)builder.isPushable);
        }
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    public void push(Entity pEntity, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onEntityCollision != null) {
                ContextUtils.CollidingProjectileEntityContext context = new ContextUtils.CollidingProjectileEntityContext(this.entityJs$getLivingEntity(), pEntity);
                EntityJSHelperClass.consumerCallback(builder.onEntityCollision, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onEntityCollision.");
            }
        }
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.blockSpeedFactor == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.blockSpeedFactor.apply(this.entityJs$getLivingEntity()), "float");
            if (obj != null) {
                cir.setReturnValue((Object)Float.valueOf(((Float)obj).floatValue()));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(builder.blockSpeedFactor.apply(this.entityJs$getLivingEntity())) + ". Must be a float, defaulting to " + String.valueOf(cir.getReturnValue()));
            }
        }
    }

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void positionRider(Entity pPassenger, Entity.MoveFunction pCallback, CallbackInfo ci) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.positionRider != null) {
                ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext(this.entityJs$getLivingEntity(), pPassenger, pCallback);
                EntityJSHelperClass.consumerCallback(builder.positionRider, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: positionRider.");
                ci.cancel();
            }
        }
    }

    @Inject(method={"canAddPassenger"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void canAddPassenger(Entity pPassenger, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.canAddPassenger == null) {
                return;
            }
            ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(pPassenger, this.entityJs$getLivingEntity());
            Boolean obj = builder.canAddPassenger.test(context);
            if (obj instanceof Boolean) {
                cir.setReturnValue((Object)obj);
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean, defaulting to " + String.valueOf(cir.getReturnValue()));
            }
        }
    }

    @Inject(method={"isFlapping"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void isFlapping(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.isFlapping != null) {
                Boolean obj = builder.isFlapping.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"repositionEntityAfterLoad"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void repositionEntityAfterLoad(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.repositionEntityAfterLoad == null) {
                return;
            }
            cir.setReturnValue((Object)builder.repositionEntityAfterLoad);
        }
    }

    @Inject(method={"getSwimSplashSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getSwimSplashSound(CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.setSwimSplashSound == null) {
                return;
            }
            cir.setReturnValue((Object)Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)builder.setSwimSplashSound)));
        }
    }

    @Inject(method={"getSwimSound"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    protected void getSwimSound(CallbackInfoReturnable<SoundEvent> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.setSwimSound == null) {
                return;
            }
            cir.setReturnValue((Object)Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)builder.setSwimSound)));
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.canFreeze != null) {
                Boolean obj = builder.canFreeze.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"canChangeDimensions"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    private void entityjs$canChangeDimensions(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.canChangeDimensions != null) {
                Boolean obj = builder.canChangeDimensions.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"isFreezing"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isFreezing(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.isFreezing != null) {
                Boolean obj = builder.isFreezing.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isCurrentlyGlowing(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (this.entityJs$builder != null && builder.isCurrentlyGlowing != null && !this.entityJs$getLivingEntity().level().isClientSide()) {
                Boolean obj = builder.isCurrentlyGlowing.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"dampensVibrations"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void dampensVibrations(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.dampensVibrations != null) {
                Boolean obj = builder.dampensVibrations.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"showVehicleHealth"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void showVehicleHealth(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.showVehicleHealth != null) {
                Boolean obj = builder.showVehicleHealth.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void isInvulnerableTo(DamageSource pSource, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.isInvulnerableTo != null) {
                ContextUtils.EDamageContext context = new ContextUtils.EDamageContext(this.entityJs$getLivingEntity(), pSource);
                Boolean obj = builder.isInvulnerableTo.test(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"canChangeDimensions"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void canChangeDimensions(CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.canChangeDimensions != null) {
                Boolean obj = builder.canChangeDimensions.test(this.entityJs$getLivingEntity());
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void onInteract(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.onInteract != null) {
                ContextUtils.EntityInteractContext context = new ContextUtils.EntityInteractContext(this.entityJs$getLivingEntity(), pPlayer, pHand);
                EntityJSHelperClass.consumerCallback(builder.onInteract, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onInteract.");
            }
        }
    }

    @Inject(method={"mayInteract"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void mayInteract(Level pLevel, BlockPos pPos, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.mayInteract != null) {
                ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(pLevel, pPos, this.entityJs$getLivingEntity());
                Boolean obj = builder.mayInteract.test(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"canTrample"}, at={@At(value="HEAD", ordinal=0)}, remap=false, cancellable=true)
    public void canTrample(BlockState state, BlockPos pos, float fallDistance, CallbackInfoReturnable<Boolean> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.canTrample != null) {
                ContextUtils.ECanTrampleContext context = new ContextUtils.ECanTrampleContext(state, pos, fallDistance, this.entityJs$getLivingEntity());
                Boolean obj = builder.canTrample.test(context);
                if (obj instanceof Boolean) {
                    cir.setReturnValue((Object)obj);
                } else {
                    EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTrample from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(obj) + ". Must be a boolean. Defaulting to " + String.valueOf(cir.getReturnValue()));
                }
            }
        }
    }

    @Inject(method={"getMaxFallDistance"}, at={@At(value="HEAD", ordinal=0)}, remap=true, cancellable=true)
    public void getMaxFallDistance(CallbackInfoReturnable<Integer> cir) {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyEntityBuilder) {
            ModifyEntityBuilder builder = (ModifyEntityBuilder)object;
            if (builder.setMaxFallDistance == null) {
                return;
            }
            Object obj = EntityJSHelperClass.convertObjectToDesired(builder.setMaxFallDistance.apply(this.entityJs$getLivingEntity()), "integer");
            if (obj != null) {
                cir.setReturnValue((Object)((Integer)obj));
            } else {
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityJs$entityName() + ". Value: " + String.valueOf(builder.setMaxFallDistance.apply(this.entityJs$getLivingEntity())) + ". Must be an integer. Defaulting to " + String.valueOf(cir.getReturnValue()));
            }
        }
    }
}

