/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util;

import dev.latvian.mods.kubejs.script.ConsoleJS;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import software.bernie.geckolib.animation.Animation;

public class EntityJSHelperClass {
    public static final Set<String> errorMessagesLogged = new HashSet<String>();
    public static final Set<String> warningMessagesLogged = new HashSet<String>();

    public static void logErrorMessageOnce(String errorMessage) {
        if (!errorMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.error((Object)errorMessage);
            errorMessagesLogged.add(errorMessage);
        }
    }

    public static void logWarningMessageOnce(String errorMessage) {
        if (!warningMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.warn((Object)errorMessage);
            warningMessagesLogged.add(errorMessage);
        }
    }

    public static void logErrorMessageOnceCatchable(String errorMessage, Throwable e) {
        if (!errorMessagesLogged.contains(errorMessage)) {
            ConsoleJS.STARTUP.error(errorMessage, e);
            errorMessagesLogged.add(errorMessage);
        }
    }

    public static <T> boolean consumerCallback(Consumer<T> consumer, T value, String errorMessage) {
        try {
            consumer.accept(value);
        }
        catch (Throwable e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable(errorMessage, e);
            return false;
        }
        return true;
    }

    public static Object convertObjectToDesired(Object input, String outputType) {
        return switch (outputType.toLowerCase()) {
            case "integer" -> EntityJSHelperClass.convertToInteger(input);
            case "double" -> EntityJSHelperClass.convertToDouble(input);
            case "float" -> EntityJSHelperClass.convertToFloat(input);
            case "boolean" -> EntityJSHelperClass.convertToBoolean(input);
            case "interactionresult" -> EntityJSHelperClass.convertToInteractionResult(input);
            case "resourcelocation" -> EntityJSHelperClass.convertToResourceLocation(input);
            case "looptype" -> EntityJSHelperClass.convertToLoopType(input);
            case "aabb" -> EntityJSHelperClass.convertToBoundingBox(input);
            default -> input;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType convertToRenderType(Object input, Object defaultValue) {
        Object object = input;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderType.class, String.class}, (Object)object, n)) {
            case -1 -> (RenderType)defaultValue;
            case 0 -> {
                RenderType renderType;
                yield renderType = (RenderType)object;
            }
            case 1 -> {
                String string = (String)object;
                yield RenderType.entityCutout((ResourceLocation)ResourceLocation.parse((String)string));
            }
            default -> null;
        };
    }

    private static AABB convertToBoundingBox(Object input) {
        if (input instanceof AABB) {
            return (AABB)input;
        }
        return null;
    }

    private static Animation.LoopType convertToLoopType(Object input) {
        if (input instanceof Animation.LoopType) {
            return (Animation.LoopType)input;
        }
        if (input instanceof String) {
            String stringValue;
            return switch (stringValue = ((String)input).toUpperCase()) {
                case "LOOP" -> Animation.LoopType.LOOP;
                case "PLAY_ONCE" -> Animation.LoopType.PLAY_ONCE;
                case "HOLD_ON_LAST_FRAME" -> Animation.LoopType.HOLD_ON_LAST_FRAME;
                default -> Animation.LoopType.DEFAULT;
            };
        }
        return Animation.LoopType.DEFAULT;
    }

    private static ResourceLocation convertToResourceLocation(Object input) {
        if (input instanceof ResourceLocation) {
            return (ResourceLocation)input;
        }
        if (input instanceof String) {
            return ResourceLocation.parse((String)((String)input));
        }
        return null;
    }

    private static InteractionResult convertToInteractionResult(Object input) {
        if (input instanceof InteractionResult) {
            return (InteractionResult)input;
        }
        if (input instanceof String) {
            String stringValue;
            switch (stringValue = ((String)input).toLowerCase()) {
                case "success": {
                    return InteractionResult.SUCCESS;
                }
                case "consume": {
                    return InteractionResult.CONSUME;
                }
                case "pass": {
                    return InteractionResult.PASS;
                }
                case "fail": {
                    return InteractionResult.FAIL;
                }
                case "consume_partial": {
                    return InteractionResult.CONSUME_PARTIAL;
                }
            }
        }
        return null;
    }

    private static Boolean convertToBoolean(Object input) {
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof String) {
            String stringValue = ((String)input).toLowerCase();
            if ("true".equals(stringValue)) {
                return true;
            }
            if ("false".equals(stringValue)) {
                return false;
            }
        }
        return null;
    }

    private static Integer convertToInteger(Object input) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (input instanceof Double || input instanceof Float) {
            return ((Number)input).intValue();
        }
        return null;
    }

    private static Double convertToDouble(Object input) {
        if (input instanceof Double) {
            return (Double)input;
        }
        if (input instanceof Integer || input instanceof Float) {
            return ((Number)input).doubleValue();
        }
        return null;
    }

    private static Float convertToFloat(Object input) {
        if (input instanceof Float) {
            return (Float)input;
        }
        if (input instanceof Integer || input instanceof Double) {
            return Float.valueOf(((Number)input).floatValue());
        }
        return null;
    }

    public static SpawnPlacementType getSpawnPlacementType(SpawnPlacementTypeEnum typeEnum) {
        switch (typeEnum.ordinal()) {
            case 2: {
                return SpawnPlacementTypes.IN_LAVA;
            }
            case 3: {
                return SpawnPlacementTypes.ON_GROUND;
            }
            case 1: {
                return SpawnPlacementTypes.IN_WATER;
            }
            case 0: {
                return SpawnPlacementTypes.NO_RESTRICTIONS;
            }
        }
        return SpawnPlacementTypes.NO_RESTRICTIONS;
    }

    public static boolean isLegacyKubeJS() {
        String v = ModList.get().getModContainerById("kubejs").map(c -> c.getModInfo().getVersion().toString()).orElse("0.0.0");
        return v.startsWith("2101.7.1");
    }

    public static enum SpawnPlacementTypeEnum {
        NO_RESTRICTIONS,
        IN_WATER,
        IN_LAVA,
        ON_GROUND;

    }

    public static class EntityMovementTracker {
        private double prevX = 0.0;
        private double prevY = 0.0;
        private double prevZ = 0.0;

        public boolean isMoving(Entity entity) {
            double currentX = entity.getX();
            double currentY = entity.getY();
            double currentZ = entity.getZ();
            boolean moving = currentX != this.prevX || currentY != this.prevY || currentZ != this.prevZ;
            this.prevX = currentX;
            this.prevY = currentY;
            this.prevZ = currentZ;
            return moving;
        }
    }
}

