/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.ai;

import java.util.Optional;
import net.liopyu.entityjs.builders.misc.LookControlJSBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.phys.Vec3;

public class LookControlJS
extends LookControl {
    private final LookControlJSBuilder builder;

    private String entityName() {
        return this.mob.getType().toString();
    }

    public LookControlJS(Mob mob, LookControlJSBuilder builder) {
        super(mob);
        this.builder = builder;
    }

    public void setWantedZ(double wantedZ) {
        this.wantedZ = wantedZ;
    }

    public void setWantedY(double wantedY) {
        this.wantedY = wantedY;
    }

    public void setWantedX(double wantedX) {
        this.wantedX = wantedX;
    }

    public void setLookAtCooldown(int lookAtCooldown) {
        this.lookAtCooldown = lookAtCooldown;
    }

    public void setxMaxRotAngle(float xMaxRotAngle) {
        this.xMaxRotAngle = xMaxRotAngle;
    }

    public void setyMaxRotSpeed(float yMaxRotSpeed) {
        this.yMaxRotSpeed = yMaxRotSpeed;
    }

    public int getLookAtCooldown() {
        return this.lookAtCooldown;
    }

    public float getxMaxRotAngle() {
        return this.xMaxRotAngle;
    }

    public float getyMaxRotSpeed() {
        return this.yMaxRotSpeed;
    }

    public Mob getMob() {
        return this.mob;
    }

    public LookControlJSBuilder getBuilder() {
        return this.builder;
    }

    public void setLookAt(Vec3 pLookVector) {
        if (this.builder.setLookAtVec3 != null) {
            EntityJSHelperClass.consumerCallback(this.builder.setLookAtVec3, this.mob, "[EntityJS]: Error in " + this.entityName() + " Look Control builder for field: setLookAtVec3.");
        } else {
            super.setLookAt(pLookVector);
        }
    }

    public void setLookAt(Entity pEntity) {
        if (this.builder.setLookAtEntity != null) {
            EntityJSHelperClass.consumerCallback(this.builder.setLookAtEntity, this.mob, "[EntityJS]: Error in " + this.entityName() + " Look Control builder for field: setLookAtEntity.");
        } else {
            super.setLookAt(pEntity);
        }
    }

    public void setLookAt(Entity pEntity, float pDeltaYaw, float pDeltaPitch) {
        if (this.builder.setLookAtEntityWithRotation != null) {
            EntityJSHelperClass.consumerCallback(this.builder.setLookAtEntityWithRotation, this.mob, "[EntityJS]: Error in " + this.entityName() + " Look Control builder for field: setLookAtEntityWithRotation.");
        } else {
            super.setLookAt(pEntity, pDeltaYaw, pDeltaPitch);
        }
    }

    public void setLookAt(double pX, double pY, double pZ) {
        if (this.builder.setLookAtCoords != null) {
            EntityJSHelperClass.consumerCallback(this.builder.setLookAtCoords, this.mob, "[EntityJS]: Error in " + this.entityName() + " Look Control builder for field: setLookAtCoords.");
        } else {
            super.setLookAt(pX, pY, pZ);
        }
    }

    public void tick() {
        if (this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this.mob, "[EntityJS]: Error in " + this.entityName() + " Look Control builder for field: tick.");
        } else {
            super.tick();
        }
    }

    protected void clampHeadRotationToBody() {
        if (this.builder.clampHeadRotationToBody != null) {
            EntityJSHelperClass.consumerCallback(this.builder.clampHeadRotationToBody, this.mob, "[EntityJS]: Error in " + this.entityName() + " Look Control builder for field: clampHeadRotationToBody.");
        } else {
            super.clampHeadRotationToBody();
        }
    }

    protected boolean resetXRotOnTick() {
        if (this.builder.resetXRotOnTick != null) {
            Boolean obj = this.builder.resetXRotOnTick.apply(this.mob);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for resetXRotOnTick from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.resetXRotOnTick();
    }

    public boolean isLookingAtTarget() {
        if (this.builder.isLookingAtTarget != null) {
            Boolean obj = this.builder.isLookingAtTarget.apply(this.mob);
            if (obj instanceof Boolean) {
                Boolean b = obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isLookingAtTarget from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.isLookingAtTarget();
    }

    public double getWantedX() {
        if (this.builder.setWantedX != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setWantedX.apply(this.mob), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setWantedX from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.getWantedX();
    }

    public double getWantedY() {
        if (this.builder.setWantedY != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setWantedY.apply(this.mob), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setWantedY from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.getWantedY();
    }

    public double getWantedZ() {
        if (this.builder.setWantedZ != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setWantedZ.apply(this.mob), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setWantedZ from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.getWantedZ();
    }

    public Optional<Float> getXRotD() {
        if (this.builder.getXRotD != null) {
            ContextUtils.RotationContext context = new ContextUtils.RotationContext(this.wantedX, this.wantedY, this.wantedZ, this.mob);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.getXRotD.apply(context), "float");
            if (obj != null) {
                return Optional.of(Float.valueOf(((Float)obj).floatValue()));
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for getXRotD from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.getXRotD();
    }

    public Optional<Float> getYRotD() {
        if (this.builder.getYRotD != null) {
            ContextUtils.RotationContext context = new ContextUtils.RotationContext(this.wantedX, this.wantedY, this.wantedZ, this.mob);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.getYRotD.apply(context), "float");
            if (obj != null) {
                return Optional.of(Float.valueOf(((Float)obj).floatValue()));
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for getYRotD from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.getYRotD();
    }

    public float rotateTowards(float pFrom, float pTo, float pMaxDelta) {
        if (this.builder.rotateTowards != null) {
            ContextUtils.RotationTowardsContext context = new ContextUtils.RotationTowardsContext(pFrom, pTo, pMaxDelta);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.rotateTowards.apply(context), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for rotateTowards from entity:" + this.entityName() + " Look Control builder. Value: " + String.valueOf(obj) + ". Defaulting to super method.");
        }
        return super.rotateTowards(pFrom, pTo, pMaxDelta);
    }
}

