/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.liopyu.entityjs.util.data.Net;
import net.liopyu.entityjs.util.data.SavedDataJS;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public final class InitDecl {
    private static final Map<UUID, Session> SESSIONS = new HashMap<UUID, Session>();

    public static void begin(Entity e) {
        SESSIONS.put(e.getUUID(), new Session());
    }

    public static void declare(Entity e, String name, EntitySerializerType type) {
        Session s = SESSIONS.get(e.getUUID());
        if (s != null) {
            s.declared.put(name, type);
            s.used = true;
        }
    }

    public static void finalizeFor(Entity e) {
        Session s = SESSIONS.remove(e.getUUID());
        Level level = e.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        UUID id = e.getUUID();
        Map<String, Tag> vals = SavedDataJS.get(sl).getAll(id);
        Map<String, Integer> types = SavedDataJS.get(sl).getTypes(id);
        if (s != null && s.used) {
            Net.sendAllTracking(e, id, vals, types);
        }
        if (e instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)e;
            Net.sendAllTo(sp, id, vals, types);
        }
    }

    private static final class Session {
        final Map<String, EntitySerializerType> declared = new HashMap<String, EntitySerializerType>();
        boolean used = false;

        private Session() {
        }
    }
}

