/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.living;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.client.living.model.EntityModelJS;
import net.liopyu.entityjs.client.living.model.GeoLayerJS;
import net.liopyu.entityjs.client.living.model.GeoLayerJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntity;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

@Environment(value=EnvType.CLIENT)
public class KubeJSEntityRenderer<T extends class_1309>
extends GeoEntityRenderer<T> {
    private final BaseLivingEntityBuilder<T> builder;

    public KubeJSEntityRenderer(class_5617.class_5618 renderManager, BaseLivingEntityBuilder<T> builder) {
        super(renderManager, new EntityModelJS<T>(builder));
        this.builder = builder;
        this.scaleHeight = this.getScaleHeight();
        this.scaleWidth = this.getScaleWidth();
        for (GeoLayerJSBuilder<T> geoBuilder : builder.layerList) {
            GeoLayerJS layerPart = geoBuilder.build(this, builder);
            this.addRenderLayer(layerPart);
        }
    }

    public String entityName() {
        return ((class_1309)this.animatable).method_5864().toString();
    }

    public float getScaleHeight() {
        return this.builder.scaleHeight;
    }

    public float getScaleWidth() {
        return this.builder.scaleWidth;
    }

    public void scaleModelForRender(float widthScale, float heightScale, class_4587 poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (this.builder.scaleModelForRender != null && this.animatable != null) {
            ContextUtils.ScaleModelRenderContext<T> context = new ContextUtils.ScaleModelRenderContext<T>(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
            EntityJSHelperClass.consumerCallback(this.builder.scaleModelForRender, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: scaleModelForRender.");
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        } else {
            super.scaleModelForRender(widthScale, heightScale, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        }
    }

    public class_2960 getTextureLocation(T entity) {
        return (class_2960)this.builder.textureResource.apply(entity);
    }

    public class_1921 getRenderType(T animatable, class_2960 texture, class_4597 bufferSource, float partialTick) {
        return switch (((IAnimatableJS)animatable).getBuilder().renderType) {
            default -> throw new IncompatibleClassChangeError();
            case BaseLivingEntityBuilder.RenderType.SOLID -> class_1921.method_23572((class_2960)texture);
            case BaseLivingEntityBuilder.RenderType.CUTOUT -> class_1921.method_23576((class_2960)texture);
            case BaseLivingEntityBuilder.RenderType.TRANSLUCENT -> class_1921.method_23580((class_2960)texture);
        };
    }

    public void render(T animatable, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        for (PartEntity<?> part : ((IAnimatableJS)animatable).getParts()) {
            if (!class_310.method_1551().method_1561().method_3958() || animatable.method_5767() || class_310.method_1551().method_1555()) continue;
            class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
            poseStack.method_22903();
            double offsetX = part.method_23317() - animatable.method_23317();
            double offsetY = part.method_23318() - animatable.method_23318();
            double offsetZ = part.method_23321() - animatable.method_23321();
            poseStack.method_22904(offsetX, offsetY, offsetZ);
            class_898.method_3956((class_4587)poseStack, (class_4588)vertexConsumer, part, (float)0.0f);
            poseStack.method_22909();
        }
        if (this.builder.render != null && this.animatable != null) {
            ContextUtils.RenderContext<T> context = new ContextUtils.RenderContext<T>(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: render.");
            super.method_3936(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        } else {
            super.method_3936(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    protected void applyRotations(T animatable, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        class_4050 pose = animatable.method_18376();
        if (this.isShaking((class_1297)animatable)) {
            rotationYaw += (float)(Math.cos((double)((class_1309)animatable).field_6012 * 3.25) * Math.PI * 0.4);
        }
        if (pose != class_4050.field_18078) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - rotationYaw));
        }
        if (((class_1309)animatable).field_6213 > 0 && this.builder.defaultDeathPose.booleanValue()) {
            float deathRotation = ((float)((class_1309)animatable).field_6213 + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(Math.min(class_3532.method_15355((float)deathRotation), 1.0f) * this.getDeathMaxRotation((class_1297)animatable)));
        } else if (animatable.method_6123()) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f - animatable.method_36455()));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(((float)((class_1309)animatable).field_6012 + partialTick) * -75.0f));
        } else if (pose == class_4050.field_18078) {
            class_2350 bedOrientation = animatable.method_18401();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(bedOrientation != null ? RenderUtils.getDirectionAngle((class_2350)bedOrientation) : rotationYaw));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(this.getDeathMaxRotation((class_1297)animatable)));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
        } else if (animatable.method_16914() || animatable instanceof class_1657) {
            String name = animatable.method_5477().getString();
            if (animatable instanceof class_1657) {
                class_1657 player = (class_1657)animatable;
                if (!player.method_7348(class_1664.field_7559)) {
                    return;
                }
            } else {
                name = class_124.method_539((String)name);
            }
            if (name != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
                poseStack.method_46416(0.0f, animatable.method_17682() + 0.1f, 0.0f);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            }
            if (name != null && (name.equalsIgnoreCase("liopyu") || name.equalsIgnoreCase("toomuchmail"))) {
                poseStack.method_46416(0.0f, animatable.method_17682() + 0.1f, 0.0f);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            }
        }
    }
}

