/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.living.vanilla;

import com.mojang.serialization.Dynamic;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Objects;
import net.liopyu.entityjs.builders.living.BaseLivingEntityBuilder;
import net.liopyu.entityjs.builders.living.vanilla.IronGolemJSBuilder;
import net.liopyu.entityjs.entities.living.entityjs.IAnimatableJS;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntity;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntityJS;
import net.liopyu.entityjs.events.AddGoalSelectorsEventJS;
import net.liopyu.entityjs.events.AddGoalTargetsEventJS;
import net.liopyu.entityjs.events.BuildBrainEventJS;
import net.liopyu.entityjs.events.BuildBrainProviderEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.ModKeybinds;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1439;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2604;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4538;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@class_6328
public class IronGolemEntityJS
extends class_1439
implements IAnimatableJS {
    private final IronGolemJSBuilder builder;
    private final AnimatableInstanceCache animationFactory;
    public final PartEntityJS<?>[] partEntities;
    private boolean isRemovedFromWorld = false;
    private boolean isAddedToWorld = false;
    protected boolean thisJumping = false;

    public String entityName() {
        return this.method_5864().toString();
    }

    public IronGolemEntityJS(IronGolemJSBuilder builder, class_1299<? extends class_1439> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        ArrayList<PartEntityJS<IronGolemEntityJS>> tempPartEntities = new ArrayList<PartEntityJS<IronGolemEntityJS>>();
        for (ContextUtils.PartEntityParams params : builder.partEntityParamsList) {
            PartEntityJS<IronGolemEntityJS> partEntity = new PartEntityJS<IronGolemEntityJS>(this, params.name, params.width, params.height, params.builder);
            tempPartEntities.add(partEntity);
        }
        this.partEntities = tempPartEntities.toArray(new PartEntityJS[0]);
        this.field_6189 = this.method_5965(pLevel);
    }

    public class_5131 method_6127() {
        for (BaseLivingEntityBuilder<?> b : BaseLivingEntityBuilder.thisList) {
            if (b.get() != this.method_5864()) continue;
            return new class_5131(b.getAttributeBuilder().method_26866());
        }
        return super.method_6127();
    }

    public void method_5838(int entityId) {
        super.method_5838(entityId);
        for (int i = 0; i < this.partEntities.length; ++i) {
            PartEntityJS<?> partEntity = this.partEntities[i];
            if (partEntity == null) continue;
            partEntity.method_5838(entityId + i + 1);
        }
    }

    public void tickPart(String partName, double offsetX, double offsetY, double offsetZ) {
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        for (PartEntityJS<?> partEntity : this.partEntities) {
            if (!partEntity.name.equals(partName)) continue;
            partEntity.movePart(x + offsetX, y + offsetY, z + offsetZ, partEntity.method_36454(), partEntity.method_36455());
            return;
        }
        EntityJSHelperClass.logWarningMessageOnce("Part with name " + partName + " not found for entity: " + this.entityName());
    }

    public void method_31471(class_2604 pPacket) {
        super.method_31471(pPacket);
    }

    @Override
    public PartEntity<?>[] getParts() {
        return Objects.requireNonNullElseGet(this.partEntities, () -> new PartEntity[0]);
    }

    @Override
    public BaseLivingEntityBuilder<?> getBuilder() {
        return this.builder;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    public class_4095.class_5303<?> method_28306() {
        if (EventHandlers.buildBrainProvider.hasListeners()) {
            BuildBrainProviderEventJS event = new BuildBrainProviderEventJS();
            EventHandlers.buildBrainProvider.post(event, (Object)this.getTypeId());
            return event.provide();
        }
        return super.method_28306();
    }

    protected class_4095<IronGolemEntityJS> method_18867(Dynamic<?> p_21069_) {
        if (EventHandlers.buildBrain.hasListeners()) {
            class_4095 brain = (class_4095)UtilsJS.cast((Object)this.method_28306().method_28335(p_21069_));
            EventHandlers.buildBrain.post(new BuildBrainEventJS(brain), (Object)this.getTypeId());
            return brain;
        }
        return (class_4095)UtilsJS.cast((Object)super.method_18867(p_21069_));
    }

    protected void method_5959() {
        if (EventHandlers.addGoalTargets.hasListeners()) {
            EventHandlers.addGoalTargets.post(new AddGoalTargetsEventJS<IronGolemEntityJS>(this, this.field_6185), (Object)this.getTypeId());
        }
        if (EventHandlers.addGoalSelectors.hasListeners()) {
            EventHandlers.addGoalSelectors.post(new AddGoalSelectorsEventJS<IronGolemEntityJS>(this, this.field_6201), (Object)this.getTypeId());
        }
    }

    public boolean method_6121(class_1297 pEntity) {
        if (this.builder != null && this.builder.onHurtTarget != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHurtTarget, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurtTarget.");
        }
        return super.method_6121(pEntity);
    }

    public void onJump() {
        if (this.builder.onLivingJump != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onLivingJump, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingJump.");
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.canJump() && this.method_24828() && this.method_5942().method_23966() && this.shouldJump()) {
            this.jump();
        }
        if (this.builder.aiStep != null) {
            EntityJSHelperClass.consumerCallback(this.builder.aiStep, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: aiStep.");
        }
    }

    protected void method_6108() {
        if (this.builder.tickDeath != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tickDeath, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tickDeath.");
        } else {
            super.method_6108();
        }
    }

    protected void method_5995() {
        super.method_5995();
        if (this.builder.tickLeash != null) {
            class_1657 $$0 = (class_1657)this.method_5933();
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext($$0, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.tickLeash, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: tickLeash.");
        }
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        if (this.builder.onTargetChanged != null) {
            ContextUtils.TargetChangeContext context = new ContextUtils.TargetChangeContext(target, (class_1308)this);
            EntityJSHelperClass.consumerCallback(this.builder.onTargetChanged, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onTargetChanged.");
        }
    }

    public void method_5983() {
        super.method_5983();
        if (this.builder.ate != null) {
            EntityJSHelperClass.consumerCallback(this.builder.ate, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: ate.");
        }
    }

    protected class_1408 method_5965(class_1937 pLevel) {
        if (this.builder == null || this.builder.createNavigation == null) {
            return new class_1409((class_1308)this, pLevel);
        }
        ContextUtils.EntityLevelContext context = new ContextUtils.EntityLevelContext(pLevel, (class_1309)this);
        Object obj = this.builder.createNavigation.apply(context);
        if (obj instanceof class_1408) {
            class_1408 p = (class_1408)obj;
            return p;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for createNavigation from entity: " + this.entityName() + ". Value: " + obj + ". Must be PathNavigation. Defaulting to super method.");
        return new class_1409((class_1308)this, pLevel);
    }

    public boolean method_5931(class_1657 pPlayer) {
        if (this.builder.canBeLeashed != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(pPlayer, (class_1309)this);
            Object obj = this.builder.canBeLeashed.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeLeashed from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5931(pPlayer));
        }
        return super.method_5931(pPlayer);
    }

    public boolean method_5974(double pDistanceToClosestPlayer) {
        if (this.builder.removeWhenFarAway == null) {
            return super.method_5974(pDistanceToClosestPlayer);
        }
        ContextUtils.EntityDistanceToPlayerContext context = new ContextUtils.EntityDistanceToPlayerContext(pDistanceToClosestPlayer, (class_1309)this);
        Object obj = this.builder.removeWhenFarAway.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for removeWhenFarAway from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5974(pDistanceToClosestPlayer));
        return super.method_5974(pDistanceToClosestPlayer);
    }

    protected double method_6148() {
        return Objects.requireNonNullElseGet(this.builder.followLeashSpeed, () -> super.method_6148());
    }

    public int method_5970() {
        if (this.builder.ambientSoundInterval != null) {
            return (Integer)this.builder.ambientSoundInterval;
        }
        return super.method_5970();
    }

    public double method_5678() {
        if (this.builder.myRidingOffset == null) {
            return super.method_5678();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.myRidingOffset.apply(this), "double");
        if (obj != null) {
            return (Double)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for myRidingOffset from entity: " + this.entityName() + ". Value: " + this.builder.myRidingOffset.apply(this) + ". Must be a double. Defaulting to " + super.method_5678());
        return super.method_5678();
    }

    public class_1310 method_6046() {
        return this.builder.mobType;
    }

    protected class_1665 getArrow(class_1799 pArrowStack, float pVelocity) {
        return class_1675.method_18813((class_1309)this, (class_1799)pArrowStack, (float)pVelocity);
    }

    public boolean canJump() {
        return Objects.requireNonNullElse(this.builder.canJump, true);
    }

    public void jump() {
        double jumpPower = this.method_6106() + this.method_37416();
        class_243 currentVelocity = this.method_18798();
        this.method_18800(currentVelocity.field_1352, jumpPower, currentVelocity.field_1350);
        this.field_6007 = true;
        if (this.method_5624()) {
            float yawRadians = this.method_36454() * ((float)Math.PI / 180);
            this.method_18799(this.method_18798().method_1031(-Math.sin(yawRadians) * 0.2, 0.0, Math.cos(yawRadians) * 0.2));
        }
        this.field_6007 = true;
        this.onJump();
    }

    public boolean shouldJump() {
        class_2338 forwardPos = this.method_24515().method_10093(this.method_5735());
        return this.method_37908().method_8515(forwardPos, (class_1297)this) && (double)this.method_49476() < this.method_37908().method_8320(forwardPos).method_26218((class_1922)this.method_37908(), forwardPos).method_1105(class_2350.class_2351.field_11052);
    }

    public class_1306 method_6068() {
        if (this.builder.mainArm != null) {
            return (class_1306)this.builder.mainArm;
        }
        return super.method_6068();
    }

    public float method_6144(class_2338 pos, class_4538 levelReader) {
        if (this.builder.walkTargetValue == null) {
            return super.method_6144(pos, levelReader);
        }
        ContextUtils.EntityBlockPosLevelContext context = new ContextUtils.EntityBlockPosLevelContext(pos, levelReader, (class_1309)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.walkTargetValue.apply(context), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for walkTargetValue from entity: " + this.entityName() + ". Value: " + this.builder.walkTargetValue.apply(context) + ". Must be a float. Defaulting to " + super.method_6144(pos, levelReader));
        return super.method_6144(pos, levelReader);
    }

    protected boolean method_43689() {
        if (this.builder.shouldStayCloseToLeashHolder == null) {
            return super.method_43689();
        }
        Object value = this.builder.shouldStayCloseToLeashHolder.apply(this);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldStayCloseToLeashHolder from entity: " + this.entityName() + ". Value: " + value + ". Must be a boolean. Defaulting to " + super.method_43689());
        return super.method_43689();
    }

    public boolean canFireProjectileWeaponPredicate(class_1811 projectileWeapon) {
        if (this.builder.canFireProjectileWeaponPredicate != null) {
            ContextUtils.EntityProjectileWeaponContext context = new ContextUtils.EntityProjectileWeaponContext(projectileWeapon, (class_1309)this);
            Object obj = this.builder.canFireProjectileWeaponPredicate.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFireProjectileWeaponPredicate from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to false.");
        }
        return false;
    }

    public boolean canFireProjectileWeapons(class_1811 projectileWeapon) {
        if (this.builder.canFireProjectileWeapon != null) {
            return this.builder.canFireProjectileWeapon.method_8093(projectileWeapon.method_7854()) && projectileWeapon instanceof class_1811;
        }
        return super.method_25938(projectileWeapon);
    }

    public boolean method_25938(class_1811 projectileWeapon) {
        if (this.canFireProjectileWeapons(projectileWeapon) || this.canFireProjectileWeaponPredicate(projectileWeapon)) {
            return this.canFireProjectileWeapons(projectileWeapon) && this.canFireProjectileWeaponPredicate(projectileWeapon);
        }
        return super.method_25938(projectileWeapon);
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.builder.setAmbientSound != null) {
            return (class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setAmbientSound);
        }
        return super.method_5994();
    }

    public boolean method_5939(class_1799 stack) {
        if (this.builder.canHoldItem != null) {
            ContextUtils.EntityItemStackContext context = new ContextUtils.EntityItemStackContext(stack, (class_1309)this);
            Object obj = this.builder.canHoldItem.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canHoldItem from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5939(stack));
        }
        return super.method_5939(stack);
    }

    protected boolean method_23734() {
        return Objects.requireNonNullElseGet(this.builder.shouldDespawnInPeaceful, () -> super.method_23734());
    }

    public boolean method_5947() {
        return Objects.requireNonNullElseGet(this.builder.isPersistenceRequired, () -> super.method_5947());
    }

    public double method_33191(class_1309 entity) {
        if (this.builder.meleeAttackRangeSqr != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.meleeAttackRangeSqr.apply(this), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for meleeAttackRangeSqr from entity: " + this.entityName() + ". Value: " + this.builder.meleeAttackRangeSqr.apply(this) + ". Must be a double. Defaulting to " + super.method_33191(entity));
        }
        return super.method_33191(entity);
    }

    public boolean method_5722(class_1297 pEntity) {
        if (this.builder.isAlliedTo != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(pEntity, (class_1309)this);
            Object obj = this.builder.isAlliedTo.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAlliedTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5722(pEntity));
        }
        return super.method_5722(pEntity);
    }

    public void method_6091(class_243 pTravelVector) {
        class_1309 livingentity = this.method_5642();
        if (this.method_5805() && this.method_5782() && this.builder.canSteer.booleanValue() && livingentity != null) {
            if (this.method_5642() instanceof class_1657 && this.builder.mountJumpingEnabled) {
                if (this.ableToJump()) {
                    this.setThisJumping(true);
                }
                if (this.thisJumping) {
                    this.setThisJumping(false);
                    double jumpPower = this.method_6106() + this.method_37416();
                    class_243 currentVelocity = this.method_18798();
                    double newVelocityX = currentVelocity.field_1352;
                    double newVelocityY = currentVelocity.field_1351 + jumpPower;
                    double newVelocityZ = currentVelocity.field_1350;
                    this.method_18800(newVelocityX, newVelocityY, newVelocityZ);
                    this.onJump();
                }
            }
            class_1309 passenger = this.method_5642();
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
            this.method_36456(passenger.method_36454());
            this.method_36457(passenger.method_36455() * 0.5f);
            this.method_5710(this.method_36454(), this.method_36455());
            this.field_6241 = this.field_6283 = this.method_36454();
            float x = passenger.field_6212 * 0.5f;
            float z = passenger.field_6250;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            this.method_6125((float)this.method_26825(class_5134.field_23719));
            super.method_6091(new class_243((double)x, pTravelVector.field_1351, (double)z));
        } else {
            super.method_6091(pTravelVector);
        }
        if (this.builder.travel != null) {
            ContextUtils.Vec3Context context = new ContextUtils.Vec3Context(pTravelVector, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.travel, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: travel.");
        }
    }

    public void method_5773() {
        if (!this.isAddedToWorld && !this.method_31481()) {
            this.onAddedToWorld();
            this.isAddedToWorld = true;
            this.isRemovedFromWorld = false;
        } else if (this.method_31481() && !this.isRemovedFromWorld) {
            this.onRemovedFromWorld();
            this.isAddedToWorld = false;
            this.isRemovedFromWorld = true;
        }
        super.method_5773();
        if (this.builder.tick != null && !this.method_37908().method_8608()) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
    }

    public void onAddedToWorld() {
        if (this.builder.defaultGoals.booleanValue()) {
            super.method_5959();
        }
        if (this.builder.onAddedToWorld != null && !this.method_37908().method_8608()) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    protected void method_5997(@NotNull class_1309 target) {
        super.method_5997(target);
        if (this.builder.doAutoAttackOnTouch != null) {
            ContextUtils.AutoAttackContext context = new ContextUtils.AutoAttackContext((class_1309)this, target);
            EntityJSHelperClass.consumerCallback(this.builder.doAutoAttackOnTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: doAutoAttackOnTouch.");
        }
    }

    protected int method_6130(int p_21303_) {
        if (this.builder.onDecreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onDecreaseAirSupply, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply.");
        }
        return super.method_6130(p_21303_);
    }

    protected int method_6064(int p_21307_) {
        if (this.builder.onIncreaseAirSupply != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onIncreaseAirSupply, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onIncreaseAirSupply.");
        }
        return super.method_6064(p_21307_);
    }

    protected void method_6060(@NotNull class_1309 p_21246_) {
        super.method_6060(p_21246_);
        if (this.builder.onBlockedByShield != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((class_1309)this, p_21246_);
            EntityJSHelperClass.consumerCallback(this.builder.onBlockedByShield, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDecreaseAirSupply.");
        }
    }

    public void method_6116(class_1304 slot, class_1799 previous, class_1799 current) {
        super.method_6116(slot, previous, current);
        if (this.builder != null && this.builder.onEquipItem != null) {
            ContextUtils.EntityEquipmentContext context = new ContextUtils.EntityEquipmentContext(slot, previous, current, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEquipItem, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEquipItem.");
        }
    }

    public void method_6020(@NotNull class_1293 effectInstance, @Nullable class_1297 entity) {
        if (this.builder.onEffectAdded != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEffectAdded, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectAdded.");
        } else {
            super.method_6020(effectInstance, entity);
        }
    }

    protected void method_6129(@NotNull class_1293 effectInstance) {
        if (this.builder.onEffectRemoved != null) {
            ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.onEffectRemoved, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEffectRemoved.");
        } else {
            super.method_6129(effectInstance);
        }
    }

    public void method_6025(float amount) {
        super.method_6025(amount);
        if (this.builder.onLivingHeal != null) {
            ContextUtils.EntityHealContext context = new ContextUtils.EntityHealContext((class_1309)this, amount);
            EntityJSHelperClass.consumerCallback(this.builder.onLivingHeal, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingHeal.");
        }
    }

    public void method_6078(@NotNull class_1282 damageSource) {
        super.method_6078(damageSource);
        if (this.builder.onDeath != null) {
            ContextUtils.DeathContext context = new ContextUtils.DeathContext((class_1309)this, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onDeath, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onDeath.");
        }
    }

    protected void method_6099(@NotNull class_1282 damageSource, int lootingMultiplier, boolean allowDrops) {
        if (this.builder.dropCustomDeathLoot != null) {
            ContextUtils.EntityLootContext context = new ContextUtils.EntityLootContext(damageSource, lootingMultiplier, allowDrops, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.dropCustomDeathLoot, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: dropCustomDeathLoot.");
        } else {
            super.method_6099(damageSource, lootingMultiplier, allowDrops);
        }
    }

    protected void method_5801() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.method_5801();
    }

    public boolean ableToJump() {
        return ModKeybinds.mount_jump.method_1434() && this.method_24828();
    }

    public void setThisJumping(boolean value) {
        this.thisJumping = value;
    }

    public class_1309 method_5642() {
        class_1309 entity;
        class_1297 var2 = this.method_31483();
        class_1309 var10000 = var2 instanceof class_1309 ? (entity = (class_1309)var2) : null;
        return var10000;
    }

    @Info(value="Calls a triggerable animation to be played anywhere.\n")
    public void triggerAnimation(String controllerName, String animName) {
        this.triggerAnim(controllerName, animName);
    }

    public boolean method_30949(class_1297 pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.CollidingEntityContext context = new ContextUtils.CollidingEntityContext((class_1309)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_30949(pEntity));
        }
        return super.method_30949(pEntity);
    }

    protected float method_6107() {
        return Objects.requireNonNullElseGet(this.builder.setSoundVolume, () -> Float.valueOf(super.method_6107())).floatValue();
    }

    protected float method_6120() {
        return Objects.requireNonNullElseGet(this.builder.setWaterSlowDown, () -> Float.valueOf(super.method_6120())).floatValue();
    }

    protected float method_23313() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.method_23313();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + this.builder.setBlockJumpFactor.apply(this) + ". Must be a float. Defaulting to " + super.method_23313());
        return super.method_23313();
    }

    protected float method_18394(class_4050 pPose, class_4048 pDimensions) {
        if (this.builder == null || this.builder.setStandingEyeHeight == null) {
            return super.method_18394(pPose, pDimensions);
        }
        ContextUtils.EntityPoseDimensionsContext context = new ContextUtils.EntityPoseDimensionsContext(pPose, pDimensions, (class_1309)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setStandingEyeHeight.apply(context), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setStandingEyeHeight from entity: " + this.entityName() + ". Value: " + this.builder.setStandingEyeHeight.apply(context) + ". Must be a float. Defaulting to " + super.method_18394(pPose, pDimensions));
        return super.method_18394(pPose, pDimensions);
    }

    public boolean method_5810() {
        return this.builder.isPushable;
    }

    protected float method_23326() {
        if (this.builder.blockSpeedFactor == null) {
            return super.method_23326();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (this.builder.blockSpeedFactor == null) {
            return super.method_23326();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.builder.get() + ". Value: " + this.builder.blockSpeedFactor.apply(this) + ". Must be a float, defaulting to " + super.method_23326());
        return super.method_23326();
    }

    protected void method_5865(class_1297 pPassenger, class_1297.class_4738 pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((class_1297)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.method_5865(pPassenger, pCallback);
    }

    protected boolean method_5818(@NotNull class_1297 entity) {
        if (this.builder.canAddPassenger == null) {
            return super.method_5818(entity);
        }
        ContextUtils.PassengerEntityContext context = new ContextUtils.PassengerEntityContext(entity, (class_1309)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.method_5818(entity));
        return super.method_5818(entity);
    }

    protected boolean method_27071() {
        if (this.builder.shouldDropLoot != null) {
            Object obj = this.builder.shouldDropLoot.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropLoot from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.method_27071());
        }
        return super.method_27071();
    }

    protected boolean method_29920() {
        if (this.builder.isAffectedByFluids != null) {
            Object obj = this.builder.isAffectedByFluids.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByFluids from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_29920());
        }
        return super.method_29920();
    }

    protected boolean method_6071() {
        return this.builder.isAlwaysExperienceDropper;
    }

    protected boolean method_6062() {
        if (this.builder.isImmobile != null) {
            Object obj = this.builder.isImmobile.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isImmobile from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_6062());
        }
        return super.method_6062();
    }

    protected boolean method_5776() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5776());
        }
        return super.method_5776();
    }

    public int method_23329(float fallDistance, float pDamageMultiplier) {
        if (this.builder.calculateFallDamage == null) {
            return super.method_23329(fallDistance, pDamageMultiplier);
        }
        ContextUtils.CalculateFallDamageContext context = new ContextUtils.CalculateFallDamageContext(fallDistance, pDamageMultiplier, (class_1309)this);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.calculateFallDamage.apply(context), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for calculateFallDamage from entity: " + this.entityName() + ". Value: " + this.builder.calculateFallDamage.apply(context) + ". Must be an int, defaulting to " + super.method_23329(fallDistance, pDamageMultiplier));
        return super.method_23329(fallDistance, pDamageMultiplier);
    }

    protected boolean method_5638() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.method_5638());
    }

    protected float method_5867() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + this.builder.nextStep.apply(this) + ". Must be a float, defaulting to " + super.method_5867());
        }
        return super.method_5867();
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 p_21239_) {
        if (this.builder.setHurtSound == null) {
            return super.method_6011(p_21239_);
        }
        ContextUtils.HurtContext context = new ContextUtils.HurtContext((class_1309)this, p_21239_);
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setHurtSound.apply(context), "resourcelocation");
        if (obj != null) {
            return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)obj));
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setHurtSound from entity: " + this.entityName() + ". Value: " + this.builder.setHurtSound.apply(context) + ". Must be a ResourceLocation or String. Defaulting to \"minecraft:entity.generic.hurt\"");
        return super.method_6011(p_21239_);
    }

    protected class_3414 method_5625() {
        if (this.builder.setSwimSplashSound == null) {
            return super.method_5625();
        }
        return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setSwimSplashSound));
    }

    protected class_3414 method_5737() {
        if (this.builder.setSwimSound == null) {
            return super.method_5737();
        }
        return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setSwimSound));
    }

    public boolean method_5973(@NotNull class_1299<?> entityType) {
        if (this.builder.canAttackType != null) {
            ContextUtils.EntityTypeEntityContext context = new ContextUtils.EntityTypeEntityContext((class_1309)this, entityType);
            Object obj = this.builder.canAttackType.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttackType from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5973(entityType));
        }
        return super.method_5973(entityType);
    }

    public float method_17825() {
        if (this.builder.scale == null) {
            return super.method_17825();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.scale.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for scale from entity: " + this.entityName() + ". Value: " + this.builder.scale.apply(this) + ". Must be a float. Defaulting to " + super.method_17825());
        return super.method_17825();
    }

    public boolean method_6054() {
        if (this.builder.shouldDropExperience != null) {
            Object obj = this.builder.shouldDropExperience.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for shouldDropExperience from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_6054());
        }
        return super.method_6054();
    }

    public double method_18390(@Nullable class_1297 p_20969_) {
        if (this.builder.visibilityPercent != null) {
            ContextUtils.VisualContext context = new ContextUtils.VisualContext(p_20969_, (class_1309)this);
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.visibilityPercent.apply(context), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for visibilityPercent from entity: " + this.entityName() + ". Value: " + this.builder.visibilityPercent.apply(context) + ". Must be a double. Defaulting to " + super.method_18390(p_20969_));
            return super.method_18390(p_20969_);
        }
        return super.method_18390(p_20969_);
    }

    public boolean method_18395(@NotNull class_1309 entity) {
        if (this.builder.canAttack != null) {
            ContextUtils.LivingEntityContext context = new ContextUtils.LivingEntityContext((class_1309)this, entity);
            Object obj = this.builder.canAttack.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj != false && super.method_18395(entity);
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAttack from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_18395(entity));
        }
        return super.method_18395(entity);
    }

    public boolean method_6049(@NotNull class_1293 effectInstance) {
        if (this.builder.canBeAffected == null) {
            return super.method_6049(effectInstance);
        }
        ContextUtils.OnEffectContext context = new ContextUtils.OnEffectContext(effectInstance, (class_1309)this);
        Object result = this.builder.canBeAffected.apply(context);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canBeAffected from entity: " + this.entityName() + ". Value: " + result + ". Must be a boolean. Defaulting to " + super.method_6049(effectInstance));
        return super.method_6049(effectInstance);
    }

    public boolean method_5999() {
        if (this.builder.invertedHealAndHarm == null) {
            return super.method_5999();
        }
        Object obj = this.builder.invertedHealAndHarm.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for invertedHealAndHarm from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5999());
        return super.method_5999();
    }

    protected class_3414 method_6002() {
        if (this.builder.setDeathSound == null) {
            return super.method_6002();
        }
        return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setDeathSound));
    }

    @NotNull
    public class_1309.class_6823 method_39760() {
        if (this.builder.fallSounds != null) {
            return new class_1309.class_6823(Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.smallFallSound)), Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.largeFallSound)));
        }
        return super.method_39760();
    }

    @NotNull
    public class_3414 method_18869(@NotNull class_1799 itemStack) {
        if (this.builder.eatingSound != null) {
            return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.eatingSound));
        }
        return super.method_18869(itemStack);
    }

    public boolean method_6101() {
        if (this.builder.onClimbable == null) {
            return super.method_6101();
        }
        Object obj = this.builder.onClimbable.apply(this);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for onClimbable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to super.onClimbable(): " + super.method_6101());
        return super.method_6101();
    }

    public boolean method_6094() {
        return Objects.requireNonNullElseGet(this.builder.canBreatheUnderwater, () -> super.method_6094());
    }

    public boolean method_5747(float distance, float damageMultiplier, @NotNull class_1282 damageSource) {
        if (this.builder.onLivingFall != null) {
            ContextUtils.EntityFallDamageContext context = new ContextUtils.EntityFallDamageContext((class_1309)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onLivingFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.method_5747(distance, damageMultiplier, damageSource);
    }

    public void method_5728(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.method_5728(sprinting);
    }

    public float method_37416() {
        if (this.builder.jumpBoostPower == null) {
            return super.method_37416();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.jumpBoostPower.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for jumpBoostPower from entity: " + this.entityName() + ". Value: " + this.builder.jumpBoostPower.apply(this) + ". Must be a float. Defaulting to " + super.method_37416());
        return super.method_37416();
    }

    public boolean method_26319(@NotNull class_3610 fluidState) {
        if (this.builder.canStandOnFluid != null) {
            ContextUtils.EntityFluidStateContext context = new ContextUtils.EntityFluidStateContext((class_1309)this, fluidState);
            Object obj = this.builder.canStandOnFluid.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canStandOnFluid from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_26319(fluidState));
        }
        return super.method_26319(fluidState);
    }

    public boolean method_29503() {
        if (this.builder.isSensitiveToWater != null) {
            Object obj = this.builder.isSensitiveToWater.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSensitiveToWater from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_29503());
        }
        return super.method_29503();
    }

    public void method_5848() {
        super.method_5848();
        if (this.builder.onStopRiding != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
    }

    public void method_5842() {
        super.method_5842();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void method_29499(@NotNull class_1542 p_21054_) {
        super.method_29499(p_21054_);
        if (this.builder.onItemPickup != null) {
            ContextUtils.EntityItemEntityContext context = new ContextUtils.EntityItemEntityContext((class_1309)this, p_21054_);
            EntityJSHelperClass.consumerCallback(this.builder.onItemPickup, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onItemPickup.");
        }
    }

    public boolean method_6057(@NotNull class_1297 entity) {
        if (this.builder.hasLineOfSight != null) {
            ContextUtils.LineOfSightContext context = new ContextUtils.LineOfSightContext(entity, (class_1309)this);
            Object obj = this.builder.hasLineOfSight.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for hasLineOfSight from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_6057(entity));
        }
        return super.method_6057(entity);
    }

    public void method_6000() {
        if (this.builder.onEnterCombat != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onEnterCombat, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEnterCombat.");
        } else {
            super.method_6000();
        }
    }

    public void method_6044() {
        if (this.builder.onLeaveCombat != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onLeaveCombat, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLeaveCombat.");
        }
        super.method_6044();
    }

    public boolean method_6086() {
        if (this.builder.isAffectedByPotions != null) {
            Object obj = this.builder.isAffectedByPotions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAffectedByPotions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_6086());
        }
        return super.method_6086();
    }

    public boolean method_6102() {
        if (this.builder.isAttackable != null) {
            Object obj = this.builder.isAttackable.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_6102());
        }
        return super.method_6102();
    }

    public boolean method_18397(@NotNull class_1799 itemStack) {
        if (this.builder.canTakeItem != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((class_1309)this, itemStack, this.method_37908());
            Object obj = this.builder.canTakeItem.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canTakeItem from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_18397(itemStack));
        }
        return super.method_18397(itemStack);
    }

    public boolean method_6113() {
        if (this.builder.isSleeping != null) {
            Object obj = this.builder.isSleeping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isSleeping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_6113());
        }
        return super.method_6113();
    }

    public void method_18403(@NotNull class_2338 blockPos) {
        if (this.builder.onStartSleeping != null) {
            ContextUtils.EntityBlockPosContext context = new ContextUtils.EntityBlockPosContext((class_1309)this, blockPos);
            EntityJSHelperClass.consumerCallback(this.builder.onStartSleeping, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStartSleeping.");
        }
        super.method_18403(blockPos);
    }

    public void method_18400() {
        if (this.builder.onStopSleeping != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopSleeping, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopSleeping.");
        }
        super.method_18400();
    }

    @NotNull
    public class_1799 method_18866(@NotNull class_1937 level, @NotNull class_1799 itemStack) {
        if (this.builder.eat != null) {
            ContextUtils.EntityItemLevelContext context = new ContextUtils.EntityItemLevelContext((class_1309)this, itemStack, level);
            EntityJSHelperClass.consumerCallback(this.builder.eat, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: eat.");
            return itemStack;
        }
        return super.method_18866(level, itemStack);
    }

    public boolean method_32316() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_32316());
        }
        return super.method_32316();
    }

    public boolean method_40071() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_40071());
        }
        return super.method_40071();
    }

    public boolean method_5851() {
        if (this.builder.isCurrentlyGlowing != null && !this.method_37908().method_8608()) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5851());
        }
        return super.method_5851();
    }

    public boolean method_42149() {
        if (this.builder.canDisableShield != null) {
            Object obj = this.builder.canDisableShield.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canDisableShield from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_42149());
        }
        return super.method_42149();
    }

    public void method_36209() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.method_36209();
    }

    public void method_6074(class_1282 pDamageSource, float pDamageAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityDamageContext context = new ContextUtils.EntityDamageContext(pDamageSource, pDamageAmount, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        super.method_6074(pDamageSource, pDamageAmount);
    }

    public void method_5730() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.method_5730();
    }

    public int method_6110() {
        if (this.builder.experienceReward != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.experienceReward.apply(this), "integer");
            if (obj != null) {
                return (Integer)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for experienceReward from entity: " + this.entityName() + ". Value: " + this.builder.experienceReward.apply(this) + ". Must be an integer. Defaulting to " + super.method_6110());
        }
        return super.method_6110();
    }

    public boolean method_33189() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_33189());
        }
        return super.method_33189();
    }

    public void method_5694(class_1657 p_20081_) {
        if (this.builder.playerTouch != null) {
            ContextUtils.PlayerEntityContext context = new ContextUtils.PlayerEntityContext(p_20081_, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        }
    }

    public boolean method_5709() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5709());
        }
        return super.method_5709();
    }

    public void method_5800(class_3218 p_19927_, class_1538 p_19928_) {
        if (this.builder.thunderHit != null) {
            super.method_5800(p_19927_, p_19928_);
            ContextUtils.ThunderHitContext context = new ContextUtils.ThunderHitContext(p_19927_, p_19928_, (class_1309)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean method_5679(class_1282 p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.DamageContext context = new ContextUtils.DamageContext((class_1309)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5679(p_20122_));
        }
        return super.method_5679(p_20122_);
    }

    public boolean method_5822() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5822());
        }
        return super.method_5822();
    }

    public boolean method_36971(@NotNull class_1937 p_146843_, @NotNull class_2338 p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.MayInteractContext context = new ContextUtils.MayInteractContext(p_146843_, p_146844_, (class_1309)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_36971(p_146843_, p_146844_));
        }
        return super.method_36971(p_146843_, p_146844_);
    }

    public void onRemovedFromWorld() {
        if (this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
    }

    public int method_5850() {
        if (this.builder.setMaxFallDistance == null) {
            return super.method_5850();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + this.builder.setMaxFallDistance.apply(this) + ". Must be an integer. Defaulting to " + super.method_5850());
        return super.method_5850();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.method_5759(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, (class_1297)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }
}

