/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.entityjs;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityBuilder;
import net.liopyu.entityjs.builders.nonliving.entityjs.ArrowEntityJSBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.IArrowEntityJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6328;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@class_6328
public class ArrowEntityJS
extends class_1665
implements IArrowEntityJS {
    public final ArrowEntityJSBuilder builder;
    @NotNull
    protected class_1799 pickUpStack;
    private double baseDamage;
    private int knockback;
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<class_1297> piercedAndKilledEntities;
    private EntityJSHelperClass.EntityMovementTracker movementTracker;
    private boolean isMoving;
    private boolean isRemovedFromWorld = false;
    private boolean isAddedToWorld = false;

    public ArrowEntityJS(ArrowEntityJSBuilder builder, class_1299<? extends class_1665> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.builder = builder;
        this.pickUpStack = class_1799.field_8037;
        this.baseDamage = builder.setBaseDamage;
        this.movementTracker = new EntityJSHelperClass.EntityMovementTracker();
    }

    public ArrowEntityJS(class_1937 level, class_1309 shooter, ArrowEntityJSBuilder builder) {
        super((class_1299)builder.get(), shooter, level);
        this.builder = builder;
        this.pickUpStack = class_1799.field_8037;
        this.baseDamage = builder.setBaseDamage;
        this.movementTracker = new EntityJSHelperClass.EntityMovementTracker();
    }

    public ArrowEntityBuilder<?> getArrowBuilder() {
        return this.builder;
    }

    @Override
    public void setPickUpItem(class_1799 stack) {
        this.pickUpStack = stack;
    }

    protected class_1799 method_7445() {
        return this.pickUpStack;
    }

    public String entityName() {
        return this.method_5864().toString();
    }

    public boolean method_5810() {
        return true;
    }

    public void method_5697(class_1297 pEntity) {
        if (this.builder.onEntityCollision != null) {
            ContextUtils.CollidingProjectileEntityContext context = new ContextUtils.CollidingProjectileEntityContext((class_1297)this, pEntity);
            EntityJSHelperClass.consumerCallback(this.builder.onEntityCollision, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onEntityCollision.");
        }
        if (this.builder.isPushable) {
            super.method_5697(pEntity);
        }
    }

    protected void method_7446() {
        if (this.builder.tickDespawn != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tickDespawn, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tickDespawn.");
        } else {
            super.method_7446();
        }
    }

    protected void method_7450(class_1309 target) {
        if (this.builder.doPostHurtEffects != null) {
            ContextUtils.ArrowLivingEntityContext context = new ContextUtils.ArrowLivingEntityContext(this, target);
            EntityJSHelperClass.consumerCallback(this.builder.doPostHurtEffects, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: doPostHurtEffects.");
        } else {
            super.method_7450(target);
        }
    }

    protected class_3414 method_7440() {
        if (this.builder != null && this.builder.defaultHitGroundSoundEvent != null) {
            return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.defaultHitGroundSoundEvent));
        }
        return super.method_7440();
    }

    protected float method_7436() {
        return this.builder.setWaterInertia != null ? this.builder.setWaterInertia.floatValue() : super.method_7436();
    }

    protected boolean method_34713(class_1657 player) {
        if (this.builder.tryPickup == null) {
            return super.method_34713(player);
        }
        ContextUtils.ArrowPlayerContext context = new ContextUtils.ArrowPlayerContext(player, this);
        Object obj = this.builder.tryPickup.apply(context);
        if (obj instanceof Boolean) {
            Boolean b = (Boolean)obj;
            return b;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid value for tryPickup from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_34713(player));
        return super.method_34713(player);
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    public double setDamageFunction() {
        if (this.builder.setDamageFunction != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setDamageFunction.apply(this), "double");
            if (obj != null) {
                return (Double)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid setDamageFunction for arrow builder: " + this.builder.setDamageFunction.apply(this) + ". Must be a double. Defaulting to super method: 0");
            return 0.0;
        }
        return 0.0;
    }

    public void method_7438(double pBaseDamage) {
        this.baseDamage = pBaseDamage + this.builder.setBaseDamage + this.setDamageFunction();
    }

    public double method_7448() {
        return this.baseDamage;
    }

    public void method_7449(int pKnockback) {
        this.knockback = this.builder.setKnockback != null ? this.builder.setKnockback + pKnockback : pKnockback;
    }

    public int method_35207() {
        return this.knockback;
    }

    public void method_7435(class_1309 pShooter, float pVelocity) {
        int i = class_1890.method_8203((class_1887)class_1893.field_9103, (class_1309)pShooter);
        int j = class_1890.method_8203((class_1887)class_1893.field_9116, (class_1309)pShooter);
        this.method_7438((double)(pVelocity * 2.0f) + this.field_5974.method_43385((double)this.method_37908().method_8407().method_5461() * 0.11, 0.57425));
        if (i > 0) {
            this.method_7438(this.method_7448() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.method_7449(j);
        }
        if (class_1890.method_8203((class_1887)class_1893.field_9126, (class_1309)pShooter) > 0) {
            this.method_5639(100);
        }
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        if (this.builder.onHurt != null) {
            ContextUtils.EntityHurtContext context = new ContextUtils.EntityHurtContext((class_1297)this, pSource, pAmount);
            EntityJSHelperClass.consumerCallback(this.builder.onHurt, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHurt.");
        }
        return super.method_5643(pSource, pAmount);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.method_5759(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, (class_1297)this);
            EntityJSHelperClass.consumerCallback(this.builder.lerpTo, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: lerpTo.");
        }
    }

    public void method_5773() {
        if (!this.isAddedToWorld && !this.method_31481()) {
            this.onAddedToWorld();
            this.isAddedToWorld = true;
            this.isRemovedFromWorld = false;
        } else if (this.method_31481() && !this.isRemovedFromWorld) {
            this.onRemovedFromWorld();
            this.isAddedToWorld = false;
            this.isRemovedFromWorld = true;
        }
        super.method_5773();
        this.isMoving = this.movementTracker.isMoving((class_1297)this);
        if (this.builder.tick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.tick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: tick.");
        }
    }

    public void method_5784(class_1313 pType, class_243 pPos) {
        super.method_5784(pType, pPos);
        if (this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, (class_1297)this);
            EntityJSHelperClass.consumerCallback(this.builder.move, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: move.");
        }
    }

    public void method_5694(class_1657 player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, (class_1297)this);
            EntityJSHelperClass.consumerCallback(this.builder.playerTouch, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: playerTouch.");
        } else {
            super.method_5694(player);
        }
    }

    public void onRemovedFromWorld() {
        if (this.builder.onRemovedFromWorld != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onRemovedFromWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onRemovedFromWorld.");
        }
    }

    public void method_5800(class_3218 p_19927_, class_1538 p_19928_) {
        if (this.builder.thunderHit != null) {
            super.method_5800(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, (class_1297)this);
            EntityJSHelperClass.consumerCallback(this.builder.thunderHit, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: thunderHit.");
        }
    }

    public boolean method_5747(float distance, float damageMultiplier, @NotNull class_1282 damageSource) {
        if (this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext((class_1297)this, damageMultiplier, distance, damageSource);
            EntityJSHelperClass.consumerCallback(this.builder.onFall, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onLivingFall.");
        }
        return super.method_5747(distance, damageMultiplier, damageSource);
    }

    public void onAddedToWorld() {
        if (this.builder.onAddedToWorld != null && !this.method_37908().method_8608()) {
            EntityJSHelperClass.consumerCallback(this.builder.onAddedToWorld, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onAddedToWorld.");
        }
    }

    public void method_5728(boolean sprinting) {
        if (this.builder.onSprint != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onSprint, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onSprint.");
        }
        super.method_5728(sprinting);
    }

    public void method_5848() {
        super.method_5848();
        if (this.builder.onStopRiding != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onStopRiding, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onStopRiding.");
        }
    }

    public void method_5842() {
        super.method_5842();
        if (this.builder.rideTick != null) {
            EntityJSHelperClass.consumerCallback(this.builder.rideTick, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: rideTick.");
        }
    }

    public void method_36209() {
        if (this.builder.onClientRemoval != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onClientRemoval, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onClientRemoval.");
        }
        super.method_36209();
    }

    public void method_5730() {
        if (this.builder.lavaHurt != null) {
            EntityJSHelperClass.consumerCallback(this.builder.lavaHurt, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: lavaHurt.");
        }
        super.method_5730();
    }

    protected void method_5801() {
        if (this.builder.onFlap != null) {
            EntityJSHelperClass.consumerCallback(this.builder.onFlap, this, "[EntityJS]: Error in " + this.entityName() + "builder for field: onFlap.");
        }
        super.method_5801();
    }

    public boolean method_5640(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, (class_1297)this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for arrow builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.method_5640(distance));
        }
        return super.method_5640(distance);
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public boolean method_5732() {
        return this.builder.isAttackable != null ? this.builder.isAttackable.booleanValue() : super.method_5732();
    }

    protected void method_7454(class_3966 pResult) {
        class_1282 damagesource;
        class_1297 entity1;
        class_1297 entity = pResult.method_17782();
        float f = (float)this.method_18798().method_1033();
        int i = class_3532.method_15384((double)class_3532.method_15350((double)((double)f * this.baseDamage), (double)0.0, (double)2.147483647E9));
        if (this.method_7447() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.method_7447() + 1) {
                this.method_31472();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.method_5628());
        }
        if (this.method_7443()) {
            long j = this.field_5974.method_43048(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.method_24921()) == null) {
            damagesource = this.method_48923().method_48803((class_1665)this, (class_1297)this);
        } else {
            damagesource = this.method_48923().method_48803((class_1665)this, entity1);
            if (entity1 instanceof class_1309) {
                ((class_1309)entity1).method_6114(entity);
            }
        }
        boolean flag = entity.method_5864() == class_1299.field_6091;
        int k = entity.method_20802();
        if (this.method_5809() && !flag) {
            entity.method_5639(5);
        }
        if (entity.method_5643(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 livingentity = (class_1309)entity;
                if (!this.method_37908().field_9236 && this.method_7447() <= 0) {
                    livingentity.method_6097(livingentity.method_6022() + 1);
                }
                if (this.knockback > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.method_26825(class_5134.field_23718));
                    class_243 vec3 = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)this.knockback * 0.6 * d0);
                    if (vec3.method_1027() > 0.0) {
                        livingentity.method_5762(vec3.field_1352, 0.1, vec3.field_1350);
                    }
                }
                if (!this.method_37908().field_9236 && entity1 instanceof class_1309) {
                    class_1890.method_8210((class_1309)livingentity, (class_1297)entity1);
                    class_1890.method_8213((class_1309)((class_1309)entity1), (class_1297)livingentity);
                }
                this.method_7450(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof class_1657 && entity1 instanceof class_3222 && !this.method_5701()) {
                    ((class_3222)entity1).field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                }
                if (!entity.method_5805() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((class_1297)livingentity);
                }
                if (!this.method_37908().field_9236 && entity1 instanceof class_3222) {
                    class_3222 serverplayer = (class_3222)entity1;
                    if (this.piercedAndKilledEntities != null && this.method_7456()) {
                        class_174.field_1197.method_8980(serverplayer, this.piercedAndKilledEntities);
                    } else if (!entity.method_5805() && this.method_7456()) {
                        class_174.field_1197.method_8980(serverplayer, Arrays.asList(entity));
                    }
                }
            }
            this.method_5783(this.method_7440(), 1.0f, 1.2f / (this.field_5974.method_43057() * 0.2f + 0.9f));
            if (this.method_7447() <= 0) {
                this.method_31472();
            }
        } else {
            entity.method_20803(k);
            this.method_18799(this.method_18798().method_1021(-0.1));
            this.method_36456(this.method_36454() + 180.0f);
            this.field_5982 += 180.0f;
            if (!this.method_37908().field_9236 && this.method_18798().method_1027() < 1.0E-7) {
                if (this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            }
        }
        if (this.builder != null && this.builder.onHitEntity != null) {
            ContextUtils.ArrowEntityHitContext context = new ContextUtils.ArrowEntityHitContext(pResult, this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitEntity, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitEntity.");
        }
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10549("damage", this.baseDamage);
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        if (pCompound.method_10573("damage", 99)) {
            this.baseDamage = pCompound.method_10574("damage");
        }
    }

    protected void method_24920(class_3965 result) {
        this.method_7444(this.method_7440());
        this.resetPiercedEntities();
        if (this.builder != null && this.builder.onHitBlock != null) {
            ContextUtils.ArrowBlockHitContext context = new ContextUtils.ArrowBlockHitContext(result, this);
            EntityJSHelperClass.consumerCallback(this.builder.onHitBlock, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: onHitBlock.");
        }
        super.method_24920(result);
    }

    protected boolean method_26958(class_1297 entity) {
        if (this.builder != null && this.builder.canHitEntity != null) {
            Object obj = this.builder.canHitEntity.apply(entity);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return super.method_26958(entity) && b != false;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid canHitEntity for arrow builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.method_26958(entity));
        }
        return super.method_26958(entity);
    }

    public class_1309 method_5642() {
        class_1309 entity;
        class_1297 var2 = this.method_31483();
        class_1309 var10000 = var2 instanceof class_1309 ? (entity = (class_1309)var2) : null;
        return var10000;
    }

    public boolean method_30949(class_1297 pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext((class_1297)this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_30949(pEntity));
        }
        return super.method_30949(pEntity);
    }

    protected float method_23313() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.method_23313();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + this.builder.setBlockJumpFactor.apply(this) + ". Must be a float. Defaulting to " + super.method_23313());
        return super.method_23313();
    }

    protected float method_23326() {
        if (this.builder.blockSpeedFactor == null) {
            return super.method_23326();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (this.builder.blockSpeedFactor == null) {
            return super.method_23326();
        }
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + this.builder.blockSpeedFactor.apply(this) + ". Must be a float, defaulting to " + super.method_23326());
        return super.method_23326();
    }

    protected void method_5865(class_1297 pPassenger, class_1297.class_4738 pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext((class_1297)this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.method_5865(pPassenger, pCallback);
    }

    protected boolean method_5818(@NotNull class_1297 entity) {
        if (this.builder.canAddPassenger == null) {
            return super.method_5818(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, (class_1297)this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.method_5818(entity));
        return super.method_5818(entity);
    }

    protected boolean method_5776() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5776());
        }
        return super.method_5776();
    }

    protected boolean method_5638() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.method_5638());
    }

    protected float method_5867() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + this.builder.nextStep.apply(this) + ". Must be a float, defaulting to " + super.method_5867());
        }
        return super.method_5867();
    }

    protected class_3414 method_5625() {
        if (this.builder.setSwimSplashSound == null) {
            return super.method_5625();
        }
        return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setSwimSplashSound));
    }

    protected class_3414 method_5737() {
        if (this.builder.setSwimSound == null) {
            return super.method_5737();
        }
        return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setSwimSound));
    }

    public boolean method_32316() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_32316());
        }
        return super.method_32316();
    }

    public boolean method_40071() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_40071());
        }
        return super.method_40071();
    }

    public boolean method_5851() {
        if (this.builder.isCurrentlyGlowing != null && !this.method_37908().method_8608()) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5851());
        }
        return super.method_5851();
    }

    public boolean method_33189() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_33189());
        }
        return super.method_33189();
    }

    public boolean method_5709() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5709());
        }
        return super.method_5709();
    }

    public boolean method_5679(class_1282 p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext((class_1297)this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5679(p_20122_));
        }
        return super.method_5679(p_20122_);
    }

    public boolean method_5822() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5822());
        }
        return super.method_5822();
    }

    public boolean method_36971(@NotNull class_1937 p_146843_, @NotNull class_2338 p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, (class_1297)this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_36971(p_146843_, p_146844_));
        }
        return super.method_36971(p_146843_, p_146844_);
    }

    public int method_5850() {
        if (this.builder.setMaxFallDistance == null) {
            return super.method_5850();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + this.builder.setMaxFallDistance.apply(this) + ". Must be an integer. Defaulting to " + super.method_5850());
        return super.method_5850();
    }
}

