/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.entities.nonliving.entityjs;

import java.util.Objects;
import net.liopyu.entityjs.builders.nonliving.entityjs.PartBuilder;
import net.liopyu.entityjs.entities.nonliving.entityjs.PartEntity;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class PartEntityJS<T extends class_1309>
extends PartEntity<T> {
    public final T parentMob;
    public final String name;
    private final class_4048 size;
    public float width;
    public float height;
    protected final PartBuilder<T> builder;
    private boolean isRemovedFromWorld = false;
    private boolean isAddedToWorld = false;

    public PartEntityJS(T pParentMob, String pName, float pWidth, float pHeight, PartBuilder<T> builder) {
        super(pParentMob);
        this.builder = builder;
        this.size = class_4048.method_18384((float)pWidth, (float)pHeight);
        this.method_18382();
        this.parentMob = pParentMob;
        this.name = pName;
        this.width = pWidth;
        this.height = pHeight;
    }

    public String entityName() {
        return this.name;
    }

    public boolean method_5863() {
        return this.builder.isPickable;
    }

    @Override
    public boolean method_5643(class_1282 pSource, float pAmount) {
        return !this.method_5679(pSource) && this.partHurt(this, pSource, pAmount);
    }

    private boolean partHurt(PartEntityJS<T> partEntity, class_1282 pSource, float pDamage) {
        if (pDamage <= 0.0f) {
            return false;
        }
        if (this.builder.onPartHurt != null) {
            ContextUtils.PartHurtContext<T> context = new ContextUtils.PartHurtContext<T>(partEntity, pSource, pDamage, (class_1309)this.parentMob);
            this.builder.onPartHurt.accept(context);
            return true;
        }
        this.parentMob.method_5643(pSource, pDamage);
        return true;
    }

    @Override
    public boolean method_5779(class_1297 pEntity) {
        return this == pEntity || this.parentMob == pEntity;
    }

    public void movePart(double pX, double pY, double pZ, float pYRot, float pXRot) {
        super.method_5808(pX, pY, pZ, pYRot, pXRot);
    }

    public class_4048 method_18377(class_4050 pPose) {
        return this.size;
    }

    @Override
    public boolean method_31746() {
        return false;
    }

    public boolean method_5640(double distance) {
        if (this.builder.shouldRenderAtSqrDistance != null) {
            ContextUtils.EntitySqrDistanceContext context = new ContextUtils.EntitySqrDistanceContext(distance, this);
            Object obj = this.builder.shouldRenderAtSqrDistance.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid shouldRenderAtSqrDistance for arrow builder: " + obj + ". Must be a boolean. Defaulting to super method: " + super.method_5640(distance));
        }
        return super.method_5640(distance);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        super.method_5759(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        if (this.builder.lerpTo != null) {
            ContextUtils.LerpToContext context = new ContextUtils.LerpToContext(x, y, z, yaw, pitch, posRotationIncrements, teleport, this);
            this.builder.lerpTo.accept(context);
        }
    }

    @Override
    public T getParent() {
        return this.parentMob;
    }

    public void method_5773() {
        if (!this.isAddedToWorld && !this.method_31481()) {
            this.onAddedToWorld();
            this.isAddedToWorld = true;
            this.isRemovedFromWorld = false;
        } else if (this.method_31481() && !this.isRemovedFromWorld) {
            this.onRemovedFromWorld();
            this.isAddedToWorld = false;
            this.isRemovedFromWorld = true;
        }
        super.method_5773();
        if (this.builder.tick != null) {
            this.builder.tick.accept(this);
        }
    }

    public void method_5784(class_1313 pType, class_243 pPos) {
        super.method_5784(pType, pPos);
        if (this.builder.move != null) {
            ContextUtils.MovementContext context = new ContextUtils.MovementContext(pType, pPos, this);
            this.builder.move.accept(context);
        }
    }

    public void method_5694(class_1657 player) {
        if (this.builder != null && this.builder.playerTouch != null) {
            ContextUtils.EntityPlayerContext context = new ContextUtils.EntityPlayerContext(player, this);
            this.builder.playerTouch.accept(context);
        } else {
            super.method_5694(player);
        }
    }

    public boolean method_5732() {
        if (this.builder.isAttackable != null) {
            Object obj = this.builder.isAttackable.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isAttackable from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5732());
        }
        return super.method_5732();
    }

    public class_1309 method_5642() {
        class_1309 entity;
        class_1297 var2 = this.method_31483();
        class_1309 var10000 = var2 instanceof class_1309 ? (entity = (class_1309)var2) : null;
        return var10000;
    }

    public boolean method_30949(class_1297 pEntity) {
        if (this.builder.canCollideWith != null) {
            ContextUtils.ECollidingEntityContext context = new ContextUtils.ECollidingEntityContext(this, pEntity);
            Object obj = this.builder.canCollideWith.apply(context);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                return b;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canCollideWith from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_30949(pEntity));
        }
        return super.method_30949(pEntity);
    }

    protected float method_23313() {
        if (this.builder.setBlockJumpFactor == null) {
            return super.method_23313();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setBlockJumpFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setBlockJumpFactor from entity: " + this.entityName() + ". Value: " + this.builder.setBlockJumpFactor.apply(this) + ". Must be a float. Defaulting to " + super.method_23313());
        return super.method_23313();
    }

    public boolean method_5810() {
        return this.builder.isPushable;
    }

    protected float method_23326() {
        if (this.builder.blockSpeedFactor == null) {
            return super.method_23326();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.blockSpeedFactor.apply(this), "float");
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for blockSpeedFactor from entity: " + this.entityName() + ". Value: " + this.builder.blockSpeedFactor.apply(this) + ". Must be a float, defaulting to " + super.method_23326());
        return super.method_23326();
    }

    protected void method_5865(class_1297 pPassenger, class_1297.class_4738 pCallback) {
        if (this.builder.positionRider != null) {
            ContextUtils.PositionRiderContext context = new ContextUtils.PositionRiderContext(this, pPassenger, pCallback);
            EntityJSHelperClass.consumerCallback(this.builder.positionRider, context, "[EntityJS]: Error in " + this.entityName() + "builder for field: positionRider.");
            return;
        }
        super.method_5865(pPassenger, pCallback);
    }

    protected boolean method_5818(@NotNull class_1297 entity) {
        if (this.builder.canAddPassenger == null) {
            return super.method_5818(entity);
        }
        ContextUtils.EPassengerEntityContext context = new ContextUtils.EPassengerEntityContext(entity, this);
        Object obj = this.builder.canAddPassenger.apply(context);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canAddPassenger from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean, defaulting to " + super.method_5818(entity));
        return super.method_5818(entity);
    }

    protected boolean method_5776() {
        if (this.builder.isFlapping != null) {
            Object obj = this.builder.isFlapping.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFlapping from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5776());
        }
        return super.method_5776();
    }

    public void onAddedToWorld() {
        if (this.builder.onAddedToWorld != null && !this.method_37908().method_8608()) {
            this.builder.onAddedToWorld.accept(this);
        }
    }

    protected boolean method_5638() {
        return Objects.requireNonNullElseGet(this.builder.repositionEntityAfterLoad, () -> super.method_5638());
    }

    protected float method_5867() {
        if (this.builder.nextStep != null) {
            Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.nextStep.apply(this), "float");
            if (obj != null) {
                return ((Float)obj).floatValue();
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for nextStep from entity: " + this.entityName() + ". Value: " + this.builder.nextStep.apply(this) + ". Must be a float, defaulting to " + super.method_5867());
        }
        return super.method_5867();
    }

    protected class_3414 method_5625() {
        if (this.builder.setSwimSplashSound == null) {
            return super.method_5625();
        }
        return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setSwimSplashSound));
    }

    protected class_3414 method_5737() {
        if (this.builder.setSwimSound == null) {
            return super.method_5737();
        }
        return Objects.requireNonNull((class_3414)class_7923.field_41172.method_10223((class_2960)this.builder.setSwimSound));
    }

    public boolean method_5747(float distance, float damageMultiplier, @NotNull class_1282 damageSource) {
        if (this.builder.onFall != null) {
            ContextUtils.EEntityFallDamageContext context = new ContextUtils.EEntityFallDamageContext(this, damageMultiplier, distance, damageSource);
            this.builder.onFall.accept(context);
        }
        return super.method_5747(distance, damageMultiplier, damageSource);
    }

    public void method_5728(boolean sprinting) {
        if (this.builder.onSprint != null) {
            this.builder.onSprint.accept(this);
        }
        super.method_5728(sprinting);
    }

    public void method_5848() {
        super.method_5848();
        if (this.builder.onStopRiding != null) {
            this.builder.onStopRiding.accept(this);
        }
    }

    public void method_5842() {
        super.method_5842();
        if (this.builder.rideTick != null) {
            this.builder.rideTick.accept(this);
        }
    }

    public boolean method_32316() {
        if (this.builder.canFreeze != null) {
            Object obj = this.builder.canFreeze.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canFreeze from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_32316());
        }
        return super.method_32316();
    }

    public boolean method_40071() {
        if (this.builder.isFreezing != null) {
            Object obj = this.builder.isFreezing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isFreezing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_40071());
        }
        return super.method_40071();
    }

    public boolean method_5851() {
        if (this.builder.isCurrentlyGlowing != null && !this.method_37908().method_8608()) {
            Object obj = this.builder.isCurrentlyGlowing.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isCurrentlyGlowing from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5851());
        }
        return super.method_5851();
    }

    public void method_36209() {
        if (this.builder.onClientRemoval != null) {
            this.builder.onClientRemoval.accept(this);
        }
        super.method_36209();
    }

    public void method_5730() {
        if (this.builder.lavaHurt != null) {
            this.builder.lavaHurt.accept(this);
        }
        super.method_5730();
    }

    protected void method_5801() {
        if (this.builder.onFlap != null) {
            this.builder.onFlap.accept(this);
        }
        super.method_5801();
    }

    public boolean method_33189() {
        if (this.builder.dampensVibrations != null) {
            Object obj = this.builder.dampensVibrations.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for dampensVibrations from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_33189());
        }
        return super.method_33189();
    }

    public boolean method_5709() {
        if (this.builder.showVehicleHealth != null) {
            Object obj = this.builder.showVehicleHealth.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for showVehicleHealth from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5709());
        }
        return super.method_5709();
    }

    public void method_5800(class_3218 p_19927_, class_1538 p_19928_) {
        if (this.builder.thunderHit != null) {
            super.method_5800(p_19927_, p_19928_);
            ContextUtils.EThunderHitContext context = new ContextUtils.EThunderHitContext(p_19927_, p_19928_, this);
            this.builder.thunderHit.accept(context);
        }
    }

    public boolean method_5679(class_1282 p_20122_) {
        if (this.builder.isInvulnerableTo != null) {
            ContextUtils.EDamageContext context = new ContextUtils.EDamageContext(this, p_20122_);
            Object obj = this.builder.isInvulnerableTo.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for isInvulnerableTo from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5679(p_20122_));
        }
        return super.method_5679(p_20122_);
    }

    public boolean method_5822() {
        if (this.builder.canChangeDimensions != null) {
            Object obj = this.builder.canChangeDimensions.apply(this);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for canChangeDimensions from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_5822());
        }
        return super.method_5822();
    }

    public boolean method_36971(@NotNull class_1937 p_146843_, @NotNull class_2338 p_146844_) {
        if (this.builder.mayInteract != null) {
            ContextUtils.EMayInteractContext context = new ContextUtils.EMayInteractContext(p_146843_, p_146844_, this);
            Object obj = this.builder.mayInteract.apply(context);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for mayInteract from entity: " + this.entityName() + ". Value: " + obj + ". Must be a boolean. Defaulting to " + super.method_36971(p_146843_, p_146844_));
        }
        return super.method_36971(p_146843_, p_146844_);
    }

    public void onRemovedFromWorld() {
        if (this.builder.onRemovedFromWorld != null) {
            this.builder.onRemovedFromWorld.accept(this);
        }
    }

    public int method_5850() {
        if (this.builder.setMaxFallDistance == null) {
            return super.method_5850();
        }
        Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.setMaxFallDistance.apply(this), "integer");
        if (obj != null) {
            return (Integer)obj;
        }
        EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for setMaxFallDistance from entity: " + this.entityName() + ". Value: " + this.builder.setMaxFallDistance.apply(this) + ". Must be an integer. Defaulting to " + super.method_5850());
        return super.method_5850();
    }
}

