/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.events;

import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.liopyu.entityjs.events.GoalEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.ai.CustomGoal;
import net.minecraft.class_1267;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1339;
import net.minecraft.class_1341;
import net.minecraft.class_1342;
import net.minecraft.class_1344;
import net.minecraft.class_1345;
import net.minecraft.class_1346;
import net.minecraft.class_1347;
import net.minecraft.class_1348;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1355;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1368;
import net.minecraft.class_1369;
import net.minecraft.class_1370;
import net.minecraft.class_1371;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1379;
import net.minecraft.class_1381;
import net.minecraft.class_1382;
import net.minecraft.class_1384;
import net.minecraft.class_1386;
import net.minecraft.class_1387;
import net.minecraft.class_1391;
import net.minecraft.class_1393;
import net.minecraft.class_1394;
import net.minecraft.class_1395;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1603;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3993;
import net.minecraft.class_4018;
import net.minecraft.class_4255;
import net.minecraft.class_4291;
import net.minecraft.class_6868;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class AddGoalSelectorsEventJS<T extends class_1308>
extends GoalEventJS<T> {
    public AddGoalSelectorsEventJS(T mob, class_1355 selector) {
        super(mob, selector);
    }

    @Info(value="Remove a goal from the entity via class reference.\n\nExample of usage:\n=====================================\nlet $PanicGoal = Java.loadClass(\"net.minecraft.world.entity.ai.goal.PanicGoal\")\nbuilder.removeGoal($PanicGoal)\n=====================================\n", params={@Param(name="goal", value="The goal class to remove")})
    public void removeGoal(Class<? extends class_1352> goal) {
        this.selector.method_35113(g -> goal == g.getClass());
    }

    @Info(value="Remove all goals fitting the specified predicate. Returns a boolean\n\nExample of usage:\n=====================================\nlet $PanicGoal = Java.loadClass(\"net.minecraft.world.entity.ai.goal.PanicGoal\")\ne.removeGoals(context => {\n    const { goal, entity } = context\n    return goal.getClass() == $PanicGoal\n})\n=====================================\n", params={@Param(name="goalFunction", value="A function to remove goals with entity & available goals as arguments")})
    public void removeGoals(Function<ContextUtils.GoalContext, Boolean> goalFunction) {
        this.selector.method_35113(g -> {
            ContextUtils.GoalContext context = new ContextUtils.GoalContext(this.getEntity(), (class_1352)g);
            Object remove = EntityJSHelperClass.convertObjectToDesired(goalFunction.apply(context), "boolean");
            if (remove != null) {
                return (Boolean)remove;
            }
            ConsoleJS.SERVER.error((Object)("[EntityJS]: Failed to remove goals from entity " + this.getEntity().method_5477() + ": function must return a boolean."));
            return false;
        });
    }

    @Info(value="Remove all goals.\n\nExample of usage:\n=====================================\nbuilder.removeAllGoals()\n=====================================\n", params={@Param(name="goal", value="The goal to remove")})
    public void removeAllGoals() {
        this.selector.method_35113(goal -> true);
    }

    @Info(value="Enables the addition of arbitrary goals to an entity\n\nIt is the responsibility of the user to ensure the goal is\ncompatible with the entity\n\nExample of usage:\n=====================================\nbuilder.arbitraryGoal(3, entity -> new $PathFindToRaidGoal(entity))\n=====================================\n\nNote in the example the entity must be an instance of Raider\n", params={@Param(name="priority", value="The priority of the goal"), @Param(name="goalSupplier", value="The goal supplier, a function that takes a Mob and returns a Goal")})
    public void arbitraryGoal(int priority, Function<T, class_1352> goalSupplier) {
        this.selector.method_6277(priority, goalSupplier.apply(this.mob));
    }

    @Info(value="Adds a custom goal to the entity", params={@Param(name="name", value="The name of the custom goal"), @Param(name="priority", value="The priority of the goal"), @Param(name="canUse", value="Determines if the entity can use the goal"), @Param(name="canContinueToUse", value="Determines if the entity can continue to use the goal, may be null"), @Param(name="isInterruptable", value="If the goal may be interrupted"), @Param(name="start", value="The action to perform when the goal starts"), @Param(name="stop", value="The action to perform when the goal stops"), @Param(name="requiresUpdateEveryTick", value="If the goal needs to be updated every tick"), @Param(name="tick", value="The action to perform when the goal ticks")})
    public void customGoal(String name, int priority, Predicate<T> canUse, @Nullable Predicate<T> canContinueToUse, boolean isInterruptable, Consumer<T> start, Consumer<T> stop, boolean requiresUpdateEveryTick, Consumer<T> tick) {
        this.selector.method_6277(priority, new CustomGoal<class_1308>(name, this.mob, canUse, canContinueToUse, isInterruptable, start, stop, requiresUpdateEveryTick, tick));
    }

    @Info(value="Adds a `AvoidEntityGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="entityClassToAvoid", value="The class of entity to avoid"), @Param(name="avoidPredicate", value="The conditions under which an entity will be avoided"), @Param(name="maxDist", value="The maximum distance from a entity the mob will detect and flee from it"), @Param(name="walkSpeedModifier", value="Modifies the mob's speed when avoiding an entity"), @Param(name="sprintSpeedModifier", value="Modifies the mob's speed when avoiding an entity at close range"), @Param(name="onAvoidEntityPredicate", value="An additional predicate for entity avoidance")})
    public <E extends class_1309> void avoidEntity(int priority, Class<E> entityClassToAvoid, Predicate<class_1309> avoidPredicate, float maxDist, double walkSpeedModifier, double sprintSpeedModifier, Predicate<class_1309> onAvoidEntityPredicate) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1338((class_1314)this.mob, entityClassToAvoid, avoidPredicate, maxDist, walkSpeedModifier, sprintSpeedModifier, onAvoidEntityPredicate));
        }
    }

    @Info(value="Adds a `BreakDoorGoal` to the entity", params={@Param(name="priority", value="The priority of the goal"), @Param(name="doorBreakTime", value="The time it takes to break a door, limited to 240 ticks"), @Param(name="validDifficulties", value="Determines what difficulties are valid for the goal")})
    public void breakDoor(int priority, int doorBreakTime, Predicate<class_1267> validDifficulties) {
        this.selector.method_6277(priority, (class_1352)new class_1339(this.mob, doorBreakTime, validDifficulties));
    }

    @Info(value="Adds a `BreathAirGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal")})
    public void breathAir(int priority) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1342((class_1314)this.mob));
        }
    }

    @Info(value="Adds a `BreedGoal` to the entity, only applicable to **animal** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="partnerClass", value="The class of animal that this entity breeds with, may be null to specify it be the same class as this entity")})
    public void breed(int priority, double speedModifier, @Nullable Class<? extends class_1429> partnerClass) {
        if (this.isAnimal) {
            this.selector.method_6277(priority, (class_1352)new class_1341((class_1429)this.mob, speedModifier, partnerClass != null ? partnerClass : (Class)UtilsJS.cast(this.mob.getClass())));
        }
    }

    @Info(value="Adds a `FloatGoal` to the entity", params={@Param(name="priority", value="The priority of the goal")})
    public void floatSwim(int priority) {
        this.selector.method_6277(priority, (class_1352)new class_1347(this.mob));
    }

    @Info(value="Adds a `RemoveBlockGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="block", value="The registry name of a block, the block to be removed"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="verticalSearchRange", value="The vertical range the mob will search for the block")})
    public void removeBlock(int priority, class_2960 block, double speedModifier, int verticalSearchRange) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1382(Objects.requireNonNull((class_2248)class_7923.field_41175.method_10223(block)), (class_1314)this.mob, speedModifier, verticalSearchRange));
        }
    }

    @Info(value="Adds a `ClimbOnTopOfPowderSnowGoal` to the entity", params={@Param(name="priority", value="The priority of the goal")})
    public void climbOnTopOfPowderedSnow(int priority) {
        this.selector.method_6277(priority, (class_1352)new class_6868(this.mob, this.mob.method_37908()));
    }

    @Info(value="Adds a `EatBlockGoal` to the entity", params={@Param(name="priority", value="The priority of the goal")})
    public void eatGrass(int priority) {
        this.selector.method_6277(priority, (class_1352)new class_1345(this.mob));
    }

    @Info(value="Adds a `MeleeAttackGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="followTargetEventIfNotSeen", value="Determines if the entity should follow the target even if it doesn't see it")})
    public void meleeAttack(int priority, double speedModifier, boolean followTargetEvenIfNotSeen) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1366((class_1314)this.mob, speedModifier, followTargetEvenIfNotSeen));
        }
    }

    @Info(value="Adds a `FleeSunGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move")})
    public void fleeSun(int priority, double speedModifier) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1344((class_1314)this.mob, speedModifier));
        }
    }

    @Info(value="Adds a `FollowBoatGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal")})
    public void followBoat(int priority) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1346((class_1314)this.mob));
        }
    }

    @Info(value="Adds a `FollowMobGoal` to the entity", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="stopDistance", value="The distance away from the target the mob will stop"), @Param(name="areaSize", value="The distance away from the mob, that will be searched for mobs to follow")})
    public void followMob(int priority, double speedModifier, float stopDistance, float areaSize) {
        this.selector.method_6277(priority, (class_1352)new class_1348(this.mob, speedModifier, stopDistance, areaSize));
    }

    @Info(value="Adds a `FollowOwnerGoal` to the entity, only applicable to **tamable** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="startDistance", value="The distance away from the owner the mob will start moving"), @Param(name="stopDistance", value="The distance away from the owner the mob will stop moving"), @Param(name="canFly", value="If the mob can teleport into leaves")})
    public void followOwner(int priority, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        if (this.isTamable) {
            this.selector.method_6277(priority, (class_1352)new class_1350((class_1321)this.mob, speedModifier, startDistance, stopDistance, canFly));
        }
    }

    @Info(value="Adds a `FollowParentGoal` to the entity, only applicable to **animal** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move")})
    public void followParent(int priority, double speedModifier) {
        if (this.isAnimal) {
            this.selector.method_6277(priority, (class_1352)new class_1353((class_1429)this.mob, speedModifier));
        }
    }

    @Info(value="Adds a `LookAtPlayerGoal` to the entity", params={@Param(name="priority", value="The priority of the goal"), @Param(name="targetClass", value="The entity class that should be looked at"), @Param(name="lookDistance", value="How far away the entity should be looked at"), @Param(name="probability", value="The probability, in the range [0, 1], that the goal may be used"), @Param(name="onlyHorizontal", value="Determines if the eye level must be the same to follow the target entity")})
    public <E extends class_1309> void lookAtEntity(int priority, Class<E> targetClass, float lookDistance, float probability, boolean onlyHorizontal) {
        this.selector.method_6277(priority, (class_1352)new class_1361(this.mob, targetClass, lookDistance, probability, onlyHorizontal));
    }

    @Info(value="Adds a `LeapAtTargetGoal` to the entity", params={@Param(name="priority", value="The priority of the goal"), @Param(name="deltaY", value="Sets the delta movement of the animal in the y-axis")})
    public void leapAtTarget(int priority, float deltaY) {
        this.selector.method_6277(priority, (class_1352)new class_1359(this.mob, deltaY));
    }

    @Info(value="Adds a `RandomStrollGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="interval", value="Sets the interval at which the goal will be 'refreshed, any values below 1 will be 1.'"), @Param(name="checkNoActionTime", value="Determines if the mob's noActionTime property should be checked")})
    public void randomStroll(int priority, double speedModifier, int interval, boolean checkNoActionTime) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1379((class_1314)this.mob, speedModifier, Math.max(1, interval), checkNoActionTime));
        }
    }

    @Info(value="Adds a `MoveBackToVillageGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="checkNoActionTime", value="Determines if the mob's noActionTime property should be checked")})
    public void moveBackToVillage(int priority, double speedModifier, boolean checkNoActionTime) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_4291((class_1314)this.mob, speedModifier, checkNoActionTime));
        }
    }

    @Info(value="Adds a `MoveThroughVillageGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="onlyAtNight", value="If this goal should only apply at night"), @Param(name="distanceToPoi", value="The minimum distance to a poi the mob must be to have it be considered 'visited'"), @Param(name="canDealWithDoors", value="If doors can be opened to navigate as part of this goal")})
    public void moveThroughVillage(int priority, double speedModifier, boolean onlyAtNight, int distanceToPoi, Supplier<Boolean> canDealWithDoors) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1368((class_1314)this.mob, speedModifier, onlyAtNight, distanceToPoi, canDealWithDoors::get));
        }
    }

    @Info(value="Adds a `MoveTowardsRestrictionGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move")})
    public void moveTowardsRestriction(int priority, double speedModifier) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1370((class_1314)this.mob, speedModifier));
        }
    }

    @Info(value="Adds a `MoveTowardsTargetGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="distanceWithin", value="The distance the target must be within to move towards it")})
    public void moveTowardsTarget(int priority, double speedModifier, float distanceWithin) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1369((class_1314)this.mob, speedModifier, distanceWithin));
        }
    }

    @Info(value="Adds a `OcelotAttackGoal` to the entity", params={@Param(name="priority", value="The priority of the goal")})
    public void ocelotAttack(int priority) {
        this.selector.method_6277(priority, (class_1352)new class_1371(this.mob));
    }

    @Info(value="Adds a `OpenDoorGoal` to the entity", params={@Param(name="priority", value="The priority of the goal"), @Param(name="closeDoor", value="If the entity should also close doors")})
    public void openDoor(int priority, boolean closeDoor) {
        this.selector.method_6277(priority, (class_1352)new class_4255(this.mob, closeDoor));
    }

    @Info(value="Adds a `PanicGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move")})
    public void panic(int priority, double speedModifier) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1374((class_1314)this.mob, speedModifier));
        }
    }

    @Info(value="Adds a `RandomLookAroundGoal` to the entity", params={@Param(name="priority", value="The priority of the goal")})
    public void randomLookAround(int priority) {
        this.selector.method_6277(priority, (class_1352)new class_1376(this.mob));
    }

    @Info(value="Adds a `RandomSwimmingGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="interval", value="Sets the interval at which the goal will be refreshed")})
    public void randomSwimming(int priority, double speedModifier, int interval) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1378((class_1314)this.mob, speedModifier, interval));
        }
    }

    @Info(value="Adds a `RangedAttackGoal` to the entity, only applicable to **ranged attack** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="attackIntervalMin", value="The minimum interval between attacks"), @Param(name="attackIntervalMax", value="The maximum interval between attacks"), @Param(name="attackRadius", value="The maximum distance something can be attacked from")})
    public <E extends class_1308> void rangedAttack(int priority, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
        if (this.isRangedAttack) {
            this.selector.method_6277(priority, (class_1352)new class_1381((class_1603)this.mob, speedModifier, attackIntervalMin, attackIntervalMax, attackRadius));
        }
    }

    @Info(value="Adds a `RestrictSunGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal")})
    public void restrictSun(int priority) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1384((class_1314)this.mob));
        }
    }

    @Info(value="Adds a `RunAroundLikeCrazyGoal` to the entity, only applicable to **horse** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move")})
    public void horseRunAroundLikeCrazy(int priority, double speedModifier) {
        if (this.isHorse) {
            this.selector.method_6277(priority, (class_1352)new class_1387((class_1496)this.mob, speedModifier));
        }
    }

    @Info(value="Adds a `SitWhenOrderedToGoal` to the entity, only applicable to **tamable** mobs", params={@Param(name="priority", value="The priority of the goal")})
    public void sitWhenOrdered(int priority) {
        if (this.isTamable) {
            this.selector.method_6277(priority, (class_1352)new class_1386((class_1321)this.mob));
        }
    }

    @Info(value="Adds a `StrollThroughVillageGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="interval", value="Sets how often the goal 'refreshes'")})
    public void strollThroughVillage(int priority, int interval) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_4018((class_1314)this.mob, interval));
        }
    }

    @Info(value="Adds a `TemptGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="temptItems", value="The ingredient that determines what items tempt the mob"), @Param(name="canScare", value="If the mob can be scared by getting to close to the tempter")})
    public void tempt(int priority, double speedModifier, class_1856 temptItems, boolean canScare) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1391((class_1314)this.mob, speedModifier, temptItems, canScare));
        }
    }

    @Info(value="Adds a `TryFindWaterGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal")})
    public void tryFindWater(int priority) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1393((class_1314)this.mob));
        }
    }

    @Info(value="Adds a `UseItemGoal` to the entity", params={@Param(name="priority", value="The priority of the goal"), @Param(name="itemToUse", value="The item that will be used"), @Param(name="soundEvent", value="The registry name of a sound event that should play when the item is used, may be null to indicate not sound event should play"), @Param(name="canUseSelector", value="Determines when the item may be used")})
    public void useItem(int priority, class_1799 itemToUse, @Nullable class_2960 soundEvent, Predicate<T> canUseSelector) {
        this.selector.method_6277(priority, (class_1352)new class_3993(this.mob, itemToUse, soundEvent == null ? null : (class_3414)class_7923.field_41172.method_10223(soundEvent), canUseSelector));
    }

    @Info(value="Adds a `WaterAvoidingRandomFlyingGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move")})
    public void waterAvoidingRandomFlying(int priority, double speedModifier) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1395((class_1314)this.mob, speedModifier));
        }
    }

    @Info(value="Adds a `WaterAvoidRandomStrollingGoal` to the entity, only applicable to **pathfinder** mobs", params={@Param(name="priority", value="The priority of the goal"), @Param(name="speedModifier", value="Sets the speed at which the mob should try to move"), @Param(name="probability", value="The probability, in the range [0, 1], that the entity picks a new position")})
    public void waterAvoidingRandomStroll(int priority, double speedModifier, float probability) {
        if (this.isPathFinder) {
            this.selector.method_6277(priority, (class_1352)new class_1394((class_1314)this.mob, speedModifier, probability));
        }
    }
}

