/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.events;

import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Generics;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6007;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class BiomeSpawnsEventJS
extends EventJS {
    @HideFromJS
    public final List<Addition> additions = new ArrayList<Addition>();
    @HideFromJS
    public final List<Removal> removals = new ArrayList<Removal>();
    public final BiomeModification event = BiomeModifications.create((class_2960)new class_2960("entityjs", "biome_modifiers"));

    @Info(value="Adds a spawn to the given entity type in the given biomes", params={@Param(name="entityType", value="The entity type to add a spawn to"), @Param(name="biomes", value="A list of biomes and biome tags to spawn in"), @Param(name="weight", value="The spawn weight"), @Param(name="minCount", value="The minimum number of entities to spawn"), @Param(name="maxCount", value="The maximum number of entities to spawn")})
    @Generics(value={class_1297.class, String.class})
    public void addSpawn(class_1299<?> entityType, List<String> biomes, int weight, int minCount, int maxCount) {
        this.event.add(ModificationPhase.ADDITIONS, biomeSelectionContext -> true, biomeModificationContext -> {});
        this.additions.add(new Addition(entityType, new class_5483.class_1964(entityType, class_6007.method_34977((int)weight), minCount, maxCount), BiomeSpawnsEventJS.processBiomes(biomes)));
    }

    @Info(value="Removes the given entity type spawns from the given biomes", params={@Param(name="entityType", value="The entity type to remove spawns from"), @Param(name="biomes", value="A list of biomes and biome tags to remove the spawns from")})
    @Generics(value={class_1297.class, String.class})
    public void removeSpawn(class_1299<?> entityType, List<String> biomes) {
        this.removals.add(new Removal(entityType, BiomeSpawnsEventJS.processBiomes(biomes)));
    }

    @HideFromJS
    public static List<Either<class_2960, class_6862<class_1959>>> processBiomes(List<String> biomes) {
        ArrayList<Either<class_2960, class_6862<class_1959>>> biomeList = new ArrayList<Either<class_2960, class_6862<class_1959>>>();
        for (String biome : biomes) {
            if (biome.charAt(0) == '#') {
                biomeList.add((Either<class_2960, class_6862<class_1959>>)Either.right((Object)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(biome.substring(1)))));
                continue;
            }
            biomeList.add((Either<class_2960, class_6862<class_1959>>)Either.left((Object)new class_2960(biome)));
        }
        return biomeList;
    }

    public record Addition(class_1299<?> entityType, class_5483.class_1964 spawnData, List<Either<class_2960, class_6862<class_1959>>> biomes) {
    }

    public record Removal(class_1299<?> entityType, List<Either<class_2960, class_6862<class_1959>>> biomes) {
    }
}

