/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.events;

import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.liopyu.entityjs.builders.modification.ModifyEntityBuilder;
import net.liopyu.entityjs.builders.modification.ModifyLivingEntityBuilder;
import net.liopyu.entityjs.builders.modification.ModifyMobBuilder;
import net.liopyu.entityjs.builders.modification.ModifyPathfinderMobBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;

public class EntityModificationEventJS
extends EventJS {
    public static final Map<class_1299<?>, EntityModificationEventJS> eventMap = new HashMap();
    public static final Map<class_1299<?>, Object> builderMap = new HashMap();
    private final Object builder;
    private final class_1297 entity;

    public EntityModificationEventJS(class_1299<?> entityType, class_1297 entity) {
        this.entity = entity;
        this.builder = this.determineModificationType(entityType, entity);
    }

    public static EntityModificationEventJS getOrCreate(class_1299<?> entityType, class_1297 entity) {
        if (!eventMap.containsKey(entityType)) {
            EntityModificationEventJS event = new EntityModificationEventJS(entityType, entity);
            eventMap.put(entityType, event);
            return event;
        }
        return eventMap.get(entityType);
    }

    @HideFromJS
    public Object getBuilder() {
        return this.builder;
    }

    @Info(value="Entity type modification event. Allows modification of methods for any existing entity. \n \nThis event determines the entity's type and uses the appropriate builder for modification. \n \nBuilders: \n    - ModifyPathfinderMobBuilder: For entities extending {@link PathfinderMob} \n    - ModifyMobBuilder: For entities extending {@link Mob} \n    - ModifyLivingEntityBuilder: For entities extending {@link LivingEntity} \n    - ModifyEntityBuilder: For entities extending {@link Entity} \n \nExample usage: \n```javascript\nEntityJSEvents.modifyEntity(event => {\n    event.modify(\"minecraft:zombie\", builder => {\n        builder.onRemovedFromWorld(entity => {\n            // Execute code when the zombie is removed from the world.\n        })\n    })\n})\n```\n", params={@Param(name="entityType", value="The entity type to modify"), @Param(name="modifyBuilder", value="A consumer to modify the entity type.")})
    public void modify(class_1299<?> entityType, Consumer<? extends ModifyEntityBuilder> modifyBuilder) {
        boolean entityTypeMatch;
        class_1297 entity = this.entity;
        boolean bl = entityTypeMatch = entityType == entity.method_5864();
        if (!entityTypeMatch) {
            return;
        }
        Object builder = EntityModificationEventJS.getOrCreate(entityType, entity).getBuilder();
        if (builder instanceof ModifyPathfinderMobBuilder) {
            modifyBuilder.accept((ModifyPathfinderMobBuilder)((Object)builder));
        } else if (builder instanceof ModifyMobBuilder) {
            modifyBuilder.accept((ModifyMobBuilder)((Object)builder));
        } else if (builder instanceof ModifyLivingEntityBuilder) {
            modifyBuilder.accept((ModifyLivingEntityBuilder)((Object)builder));
        } else if (builder instanceof ModifyEntityBuilder) {
            modifyBuilder.accept((ModifyEntityBuilder)((Object)builder));
        } else {
            throw new IllegalArgumentException("Unsupported builder type or consumer type.");
        }
    }

    public ModifyEntityBuilder determineModificationType(class_1299<?> type, class_1297 entity) {
        if (entity instanceof class_1314) {
            return new ModifyPathfinderMobBuilder(type);
        }
        if (entity instanceof class_1308) {
            return new ModifyMobBuilder(type);
        }
        if (entity instanceof class_1309) {
            return new ModifyLivingEntityBuilder(type);
        }
        return new ModifyEntityBuilder(type);
    }
}

